/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.openide.util.ImageUtilities;

public class ToolbarWithOverflow
extends JToolBar {
    private JButton overflowButton;
    private JPopupMenu popup;
    private JToolBar overflowToolbar;
    private int visibleButtons;
    private boolean displayOverflowOnHover = true;
    private final String toolbarArrowHorizontal = "org/openide/awt/resources/toolbar_arrow_horizontal.png";
    private final String toolbarArrowVertical = "org/openide/awt/resources/toolbar_arrow_vertical.png";
    private final String PROP_PREF_ICON_SIZE = "PreferredIconSize";
    private final String PROP_DRAGGER = "_toolbar_dragger_";

    public ToolbarWithOverflow() {
        this(0);
    }

    public ToolbarWithOverflow(int orientation) {
        this(null, orientation);
    }

    public ToolbarWithOverflow(String name) {
        this(name, 0);
    }

    public ToolbarWithOverflow(String name, int orientation) {
        super(name, orientation);
        this.setupOverflowButton();
        this.popup = new JPopupMenu();
        this.popup.setBorderPainted(false);
        this.popup.setBorder(BorderFactory.createEmptyBorder());
        this.overflowToolbar = new JToolBar("overflowToolbar", orientation == 0 ? 1 : 0);
        this.overflowToolbar.setFloatable(false);
        this.overflowToolbar.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY, 1));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ToolbarWithOverflow.this.maybeAddOverflow();
            }
        });
        this.overflowToolbar.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (ToolbarWithOverflow.this.popup.isShowing()) {
                    int minX = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().x;
                    int maxX = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().x + ToolbarWithOverflow.this.popup.getWidth();
                    int minY = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().y;
                    int maxY = ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().y + ToolbarWithOverflow.this.popup.getHeight();
                    if (e.getXOnScreen() < minX || e.getXOnScreen() >= maxX || e.getYOnScreen() < minY || e.getYOnScreen() >= maxY) {
                        ToolbarWithOverflow.this.popup.setVisible(false);
                    }
                }
            }
        });
    }

    public boolean isDisplayOverflowOnHover() {
        return this.displayOverflowOnHover;
    }

    public void setDisplayOverflowOnHover(boolean displayOverflowOnHover) {
        this.displayOverflowOnHover = displayOverflowOnHover;
        this.setupOverflowButton();
    }

    @Override
    public Dimension getPreferredSize() {
        Component[] comps = this.getAllComponents();
        int width = 0;
        int height = 0;
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            width += this.getOrientation() == 0 ? comp.getPreferredSize().width : comp.getPreferredSize().height;
            height = Math.max(height, this.getOrientation() == 0 ? comp.getPreferredSize().height : comp.getPreferredSize().width);
        }
        if (this.overflowToolbar.getComponentCount() > 0) {
            width += this.getOrientation() == 0 ? this.overflowButton.getPreferredSize().width : this.overflowButton.getPreferredSize().height;
        }
        Dimension dim = this.getOrientation() == 0 ? new Dimension(width, height) : new Dimension(height, width);
        return dim;
    }

    @Override
    public void setOrientation(int o) {
        super.setOrientation(o);
        this.setupOverflowButton();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.overflowToolbar.removeAll();
    }

    @Override
    public void validate() {
        this.computeVisibleButtons();
        if (this.visibleButtons == -1) {
            this.handleOverflowRemoval();
        } else {
            this.handleOverflowAddittion();
        }
        super.validate();
    }

    private void setupOverflowButton() {
        this.overflowButton = new JButton(ImageUtilities.loadImageIcon((String)(this.getOrientation() == 0 ? "org/openide/awt/resources/toolbar_arrow_vertical.png" : "org/openide/awt/resources/toolbar_arrow_horizontal.png"), (boolean)false));
        this.overflowButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ToolbarWithOverflow.this.displayOverflow();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (ToolbarWithOverflow.this.displayOverflowOnHover) {
                    ToolbarWithOverflow.this.displayOverflow();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (ToolbarWithOverflow.this.popup.isShowing()) {
                    int maxY;
                    int minX = ((ToolbarWithOverflow)ToolbarWithOverflow.this).overflowButton.getLocationOnScreen().x;
                    int maxX = ToolbarWithOverflow.this.getOrientation() == 0 ? minX + ToolbarWithOverflow.this.overflowButton.getWidth() : ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().x + ToolbarWithOverflow.this.popup.getWidth();
                    int minY = ((ToolbarWithOverflow)ToolbarWithOverflow.this).overflowButton.getLocationOnScreen().y;
                    int n = maxY = ToolbarWithOverflow.this.getOrientation() == 0 ? ((ToolbarWithOverflow)ToolbarWithOverflow.this).popup.getLocationOnScreen().y + ToolbarWithOverflow.this.popup.getHeight() : minY + ToolbarWithOverflow.this.overflowButton.getHeight();
                    if (e.getXOnScreen() < minX || e.getXOnScreen() >= maxX || e.getYOnScreen() < minY || e.getYOnScreen() >= maxY) {
                        ToolbarWithOverflow.this.popup.setVisible(false);
                    }
                }
            }
        });
    }

    private void displayOverflow() {
        int x = this.getOrientation() == 0 ? this.overflowButton.getLocationOnScreen().x : this.overflowButton.getLocationOnScreen().x + this.overflowButton.getWidth();
        int y = this.getOrientation() == 0 ? this.overflowButton.getLocationOnScreen().y + this.overflowButton.getHeight() : this.overflowButton.getLocationOnScreen().y;
        this.popup.setLocation(x, y);
        this.popup.setVisible(true);
    }

    private void maybeAddOverflow() {
        this.validate();
        this.repaint();
    }

    private void computeVisibleButtons() {
        if (this.isShowing()) {
            int w = this.getOrientation() == 0 ? this.overflowButton.getIcon().getIconWidth() + 4 : this.getWidth() - this.getInsets().left - this.getInsets().right;
            int h = this.getOrientation() == 0 ? this.getHeight() - this.getInsets().top - this.getInsets().bottom : this.overflowButton.getIcon().getIconHeight() + 4;
            this.overflowButton.setMaximumSize(new Dimension(w, h));
            this.overflowButton.setMinimumSize(new Dimension(w, h));
            this.overflowButton.setPreferredSize(new Dimension(w, h));
        }
        this.handleIconResize();
        Component[] comps = this.getAllComponents();
        int sizeSoFar = 0;
        int maxSize = this.getOrientation() == 0 ? this.getWidth() : this.getHeight();
        int overflowButtonSize = this.getOrientation() == 0 ? this.overflowButton.getPreferredSize().width : this.overflowButton.getPreferredSize().height;
        int showingButtons = 0;
        for (int i = 0; i < comps.length; ++i) {
            Component comp = comps[i];
            if (!comp.isVisible()) continue;
            ++showingButtons;
            if ((sizeSoFar += this.getOrientation() == 0 ? comp.getPreferredSize().width : comp.getPreferredSize().height) > maxSize) {
                this.visibleButtons = i;
                break;
            }
            if (sizeSoFar + overflowButtonSize > maxSize && i + 1 != comps.length) {
                this.visibleButtons = i;
                break;
            }
            this.visibleButtons = i + 1;
        }
        if (this.visibleButtons == 0 && comps.length > 0 && comps[0] instanceof JComponent && Boolean.TRUE.equals(((JComponent)comps[0]).getClientProperty("_toolbar_dragger_"))) {
            this.visibleButtons = 1;
        }
        if (this.visibleButtons >= showingButtons) {
            this.visibleButtons = -1;
        }
    }

    private void handleOverflowAddittion() {
        Component[] comps = this.getAllComponents();
        if (this.visibleButtons <= comps.length) {
            int i;
            this.removeAll();
            this.overflowToolbar.setOrientation(this.getOrientation() == 0 ? 1 : 0);
            this.popup.removeAll();
            for (i = 0; i < this.visibleButtons; ++i) {
                this.add(comps[i]);
            }
            for (i = this.visibleButtons; i < comps.length; ++i) {
                this.overflowToolbar.add(comps[i]);
            }
            this.popup.add(this.overflowToolbar);
            this.add(this.overflowButton);
        }
    }

    private void handleOverflowRemoval() {
        if (this.overflowToolbar.getComponents().length > 0) {
            this.remove(this.overflowButton);
            this.handleIconResize();
            for (Component comp : this.overflowToolbar.getComponents()) {
                this.add(comp);
            }
            this.overflowToolbar.removeAll();
            this.popup.removeAll();
        }
    }

    private void handleIconResize() {
        for (Component comp : this.overflowToolbar.getComponents()) {
            boolean smallToolbarIcons;
            boolean bl = smallToolbarIcons = this.getClientProperty("PreferredIconSize") == null;
            if (smallToolbarIcons) {
                ((JComponent)comp).putClientProperty("PreferredIconSize", null);
                continue;
            }
            ((JComponent)comp).putClientProperty("PreferredIconSize", 24);
        }
    }

    private Component[] getAllComponents() {
        Component[] toolbarComps;
        Component[] overflowComps = this.overflowToolbar.getComponents();
        if (overflowComps.length == 0) {
            toolbarComps = this.getComponents();
        } else if (this.getComponentCount() > 0) {
            toolbarComps = new Component[this.getComponents().length - 1];
            System.arraycopy(this.getComponents(), 0, toolbarComps, 0, toolbarComps.length);
        } else {
            toolbarComps = new Component[]{};
        }
        Component[] comps = new Component[toolbarComps.length + overflowComps.length];
        System.arraycopy(toolbarComps, 0, comps, 0, toolbarComps.length);
        System.arraycopy(overflowComps, 0, comps, toolbarComps.length, overflowComps.length);
        return comps;
    }
}

