/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import org.netbeans.core.options.keymap.api.KeyStrokeUtils;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.ActionHolder;
import org.netbeans.modules.options.keymap.KeymapModel;
import org.netbeans.modules.options.keymap.KeymapPanel;
import org.netbeans.modules.options.keymap.LayersBridge;
import org.netbeans.modules.options.keymap.ShortcutsDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class KeymapViewModel
extends DefaultTableModel
implements ShortcutsFinder {
    private String currentProfile;
    private KeymapModel model = new KeymapModel();
    private Map<String, List<Object>> categoryToActionsCache = new HashMap<String, List<Object>>();
    private Map<String, Map<ShortcutAction, Set<String>>> modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    private Set<String> deletedProfiles = new HashSet<String>();
    private Map<String, Map<ShortcutAction, Set<String>>> shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
    static final ActionsComparator actionsComparator = new ActionsComparator();
    private String searchText = "";
    private Map<String, List<String>> categories;
    private boolean supressDataEvents;
    private volatile boolean applyInProgress = false;

    public KeymapViewModel() {
        super(new String[]{NbBundle.getMessage(KeymapViewModel.class, (String)"ActionsColumnName"), NbBundle.getMessage(KeymapViewModel.class, (String)"ShortcutColumnName"), NbBundle.getMessage(KeymapViewModel.class, (String)"CategoryColumnName")}, 0);
        this.currentProfile = this.model.getCurrentProfile();
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return ActionHolder.class;
            }
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public Map<String, List<String>> getCategories() {
        if (this.categories == null) {
            this.categories = new TreeMap<String, List<String>>();
            ArrayList<String> c = new ArrayList<String>(this.model.getActionCategories());
            Collections.sort(c);
            for (String cn : c) {
                String folderName = "";
                StringTokenizer st = new StringTokenizer(cn, "/");
                while (st.hasMoreTokens()) {
                    String name = st.nextToken();
                    List<String> asd = this.categories.get(folderName);
                    if (asd == null) {
                        asd = new ArrayList<String>();
                        this.categories.put(folderName, asd);
                    }
                    String string = folderName = folderName.length() == 0 ? name : folderName + '/' + name;
                    if (!asd.isEmpty() && asd.get(asd.size() - 1).equals(folderName)) continue;
                    asd.add(folderName);
                }
            }
        }
        return this.categories;
    }

    public List<Object> getItems(String category) {
        List<Object> result = this.categoryToActionsCache.get(category);
        if (result == null) {
            result = new ArrayList<Object>();
            List<String> ll = this.getCategories().get(category);
            if (ll != null) {
                result.addAll(ll);
            }
            ArrayList<ShortcutAction> l = new ArrayList<ShortcutAction>(this.model.getActions(category));
            Collections.sort(l, new ActionsComparator());
            result.addAll(l);
            this.categoryToActionsCache.put(category, result);
        }
        return result;
    }

    @Override
    public void fireTableDataChanged() {
        if (!this.supressDataEvents) {
            super.fireTableDataChanged();
        }
    }

    @Override
    public void fireTableRowsInserted(int firstRow, int lastRow) {
        if (!this.supressDataEvents) {
            super.fireTableRowsInserted(firstRow, lastRow);
        }
    }

    @Override
    public void fireTableRowsDeleted(int firstRow, int lastRow) {
        if (!this.supressDataEvents) {
            super.fireTableRowsDeleted(firstRow, lastRow);
        }
    }

    @Override
    public void fireTableChanged(TableModelEvent e) {
        if (!this.supressDataEvents) {
            super.fireTableChanged(e);
        }
    }

    void update() {
        String searchTxt;
        boolean caseSensitiveSearch = false;
        if (this.searchText.matches(".*[A-Z].*")) {
            caseSensitiveSearch = true;
            searchTxt = this.searchText;
        } else {
            searchTxt = this.searchText.toLowerCase();
        }
        this.supressDataEvents = true;
        this.getDataVector().removeAllElements();
        for (String categorySet : this.getCategories().keySet()) {
            for (String category : this.getCategories().get(categorySet)) {
                for (Object o : this.getItems(category)) {
                    if (!(o instanceof ShortcutAction)) continue;
                    ShortcutAction sca = (ShortcutAction)o;
                    String[] shortcuts = this.getShortcuts(sca);
                    String displayName = sca.getDisplayName();
                    if (displayName.isEmpty() || !this.searched(caseSensitiveSearch ? displayName : displayName.toLowerCase(), searchTxt)) continue;
                    if (shortcuts.length == 0) {
                        this.addRow(new Object[]{new ActionHolder(sca, false), "", category});
                        continue;
                    }
                    for (int i = 0; i < shortcuts.length; ++i) {
                        String shortcut = shortcuts[i];
                        this.addRow(new Object[]{i == 0 ? new ActionHolder(sca, false) : new ActionHolder(sca, true), shortcut, category});
                    }
                }
            }
        }
        this.supressDataEvents = false;
        this.fireTableDataChanged();
    }

    private boolean searched(String displayName, String searchText) {
        return displayName.length() == 0 || displayName.startsWith(searchText) || displayName.contains(searchText);
    }

    List<String> getProfiles() {
        HashSet<String> result = new HashSet<String>(this.model.getProfiles());
        result.addAll(this.modifiedProfiles.keySet());
        ArrayList<String> r = new ArrayList<String>(result);
        Collections.sort(r);
        return r;
    }

    boolean isCustomProfile(String profile) {
        return this.model.isCustomProfile(profile);
    }

    void deleteOrRestoreProfile(String profile) {
        if (this.model.isCustomProfile(profile)) {
            this.deletedProfiles.add(profile);
            this.modifiedProfiles.remove(profile);
        } else {
            Map<ShortcutAction, Set<String>> m = this.model.getKeymapDefaults(profile);
            m = KeymapViewModel.convertFromEmacs(m);
            this.modifiedProfiles.put(profile, m);
            this.update();
        }
    }

    String getCurrentProfile() {
        return this.currentProfile;
    }

    void setCurrentProfile(String currentKeymap) {
        this.currentProfile = currentKeymap;
    }

    void cloneProfile(String newProfileName) {
        HashMap<ShortcutAction, Set<String>> result = new HashMap<ShortcutAction, Set<String>>();
        this.cloneProfile("", result);
        this.modifiedProfiles.put(newProfileName, result);
    }

    private void cloneProfile(String category, Map<ShortcutAction, Set<String>> result) {
        for (Object o : this.getItems(category)) {
            if (o instanceof String) {
                this.cloneProfile((String)o, result);
                continue;
            }
            String[] shortcuts = this.getShortcuts((ShortcutAction)o);
            result.put((ShortcutAction)o, new HashSet<String>(Arrays.asList(shortcuts)));
        }
    }

    @Override
    public ShortcutAction findActionForShortcut(String shortcut) {
        return this.findActionForShortcut(shortcut, "", false, null, "");
    }

    Collection<ShortcutAction> filterSameScope(Set<ShortcutAction> actions, ShortcutAction anchor) {
        return this.model.filterSameScope(actions, anchor);
    }

    Set<ShortcutAction> findActionForShortcutPrefix(String shortcut) {
        HashSet<ShortcutAction> set = new HashSet<ShortcutAction>();
        if (shortcut.length() == 0) {
            return set;
        }
        if (shortcut.contains(" ")) {
            this.findActionForShortcut(shortcut.substring(0, shortcut.indexOf(32)), "", true, set, shortcut);
        } else {
            this.findActionForShortcut(shortcut, "", true, set, shortcut);
        }
        return set;
    }

    private ShortcutAction findActionForShortcut(String shortcut, String category, boolean prefixSearch, Set<ShortcutAction> set, String completeMultikeySC) {
        Map<ShortcutAction, Set<String>> map = this.modifiedProfiles.get(this.currentProfile);
        if (map != null) {
            for (Map.Entry<ShortcutAction, Set<String>> entry : map.entrySet()) {
                for (String sc : entry.getValue()) {
                    if (prefixSearch) {
                        if (!sc.equals(shortcut) && (!sc.startsWith(completeMultikeySC) || !shortcut.equals(completeMultikeySC) || !sc.contains(" "))) continue;
                        set.add(entry.getKey());
                        continue;
                    }
                    if (!sc.equals(shortcut)) continue;
                    return entry.getKey();
                }
            }
        }
        for (Object o : this.getItems(category)) {
            if (o instanceof String) {
                ShortcutAction result = this.findActionForShortcut(shortcut, (String)o, prefixSearch, set, completeMultikeySC);
                if (result == null || prefixSearch) continue;
                return result;
            }
            ShortcutAction action = (ShortcutAction)o;
            String[] shortcuts = this.getShortcuts(action);
            int k = shortcuts.length;
            for (int i = 0; i < k; ++i) {
                if (prefixSearch) {
                    if (!shortcuts[i].equals(shortcut) && (!shortcuts[i].startsWith(completeMultikeySC) || !shortcut.equals(completeMultikeySC) || !shortcuts[i].contains(" "))) continue;
                    set.add(action);
                    continue;
                }
                if (!shortcuts[i].equals(shortcut)) continue;
                return action;
            }
        }
        return null;
    }

    @Override
    public ShortcutAction findActionForId(final String actionId) {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.findActionForId(actionId, "");
        }
        final ShortcutAction[] result = new ShortcutAction[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    result[0] = KeymapViewModel.this.findActionForId(actionId, "");
                }
            });
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return result[0];
    }

    private ShortcutAction findActionForId(String actionId, String category) {
        if (this.model.isDuplicateId(actionId)) {
            return null;
        }
        ShortcutAction ac = this.findActionForId(actionId, category, false);
        if (ac == null) {
            ac = this.findActionForId(actionId, category, true);
        }
        return ac;
    }

    private ShortcutAction findActionForId(String actionId, String category, boolean delegate) {
        for (Object o : this.getItems(category)) {
            if (o instanceof String) {
                ShortcutAction result = this.findActionForId(actionId, (String)o, delegate);
                if (result == null) continue;
                return result;
            }
            String id = delegate ? LayersBridge.getOrigActionClass((ShortcutAction)o) : ((ShortcutAction)o).getId();
            if (id == null || !actionId.equals(id)) continue;
            return (ShortcutAction)o;
        }
        return null;
    }

    @Override
    public String[] getShortcuts(ShortcutAction action) {
        Map<ShortcutAction, Set<String>> actionToShortcuts;
        if (this.modifiedProfiles.containsKey(this.currentProfile) && (actionToShortcuts = this.modifiedProfiles.get(this.currentProfile)).containsKey(action)) {
            Set<String> s = actionToShortcuts.get(action);
            return s.toArray(new String[s.size()]);
        }
        Map<ShortcutAction, Set<String>> profileMap = this.getProfileMap(this.currentProfile);
        Set<String> shortcuts = profileMap.get(action);
        if (shortcuts == null) {
            return new String[0];
        }
        return shortcuts.toArray(new String[shortcuts.size()]);
    }

    private Map<ShortcutAction, Set<String>> getProfileMap(String profile) {
        if (!this.shortcutsCache.containsKey(profile)) {
            Map<ShortcutAction, Set<String>> profileMap = KeymapViewModel.convertFromEmacs(this.model.getKeymap(profile));
            this.shortcutsCache.put(profile, profileMap);
        }
        return this.shortcutsCache.get(profile);
    }

    public Set<String> getAllCurrentlyUsedShortcuts() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        Map<ShortcutAction, Set<String>> modMap = this.modifiedProfiles.get(this.currentProfile);
        if (modMap != null) {
            for (Map.Entry<ShortcutAction, Set<String>> entry : modMap.entrySet()) {
                for (String sc : entry.getValue()) {
                    set.add(sc);
                    if (!sc.contains(" ")) continue;
                    set.add(sc.substring(0, sc.indexOf(32)));
                }
            }
        }
        for (Map.Entry<ShortcutAction, Set<String>> entry : this.getProfileMap(this.currentProfile).entrySet()) {
            for (String sc : entry.getValue()) {
                set.add(sc);
                if (!sc.contains(" ")) continue;
                set.add(sc.substring(0, sc.indexOf(32)));
            }
        }
        return set;
    }

    void addShortcut(ShortcutAction action, String shortcut) {
        ShortcutAction act = this.findActionForShortcut(shortcut);
        LinkedHashSet<String> s = new LinkedHashSet<String>();
        s.addAll(Arrays.asList(this.getShortcuts(action)));
        s.add(shortcut);
        this.setShortcuts(action, s);
    }

    void revertShortcutsToDefault(ShortcutAction action) {
        Map<ShortcutAction, Set<String>> m = this.model.getKeymapDefaults(this.currentProfile);
        Set<String> shortcuts = (m = KeymapViewModel.convertFromEmacs(m)).get(action);
        if (shortcuts == null) {
            shortcuts = Collections.emptySet();
        }
        HashSet<ShortcutAction> conflictingActions = new HashSet<ShortcutAction>();
        for (String sc : shortcuts) {
            ShortcutAction ac = this.findActionForShortcut(sc);
            if (ac == null || ac.equals(action)) continue;
            conflictingActions.add(ac);
        }
        if (conflictingActions.size() > 0) {
            if (this.overrideAll(conflictingActions)) {
                for (String sc : shortcuts) {
                    ShortcutAction sca = this.findActionForShortcut(sc);
                    this.removeShortcut(sca, sc);
                }
            } else {
                return;
            }
        }
        this.setShortcuts(action, shortcuts);
        this.update();
    }

    private boolean overrideAll(Set<ShortcutAction> actions) {
        JPanel innerPane = new JPanel();
        StringBuffer display = new StringBuffer();
        for (ShortcutAction sc : actions) {
            display.append(" '" + sc.getDisplayName() + "'<br>");
        }
        innerPane.add(new JLabel(NbBundle.getMessage(KeymapViewModel.class, (String)"Override_All", (Object)display)));
        DialogDescriptor descriptor = new DialogDescriptor((Object)innerPane, NbBundle.getMessage(KeymapViewModel.class, (String)"Conflicting_Shortcut_Dialog"), true, 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        return descriptor.getValue().equals(DialogDescriptor.YES_OPTION);
    }

    @Override
    public void setShortcuts(ShortcutAction action, Set<String> shortcuts) {
        Map<ShortcutAction, Set<String>> actionToShortcuts = this.modifiedProfiles.get(this.currentProfile);
        if (actionToShortcuts == null) {
            actionToShortcuts = new HashMap<ShortcutAction, Set<String>>();
            this.modifiedProfiles.put(this.currentProfile, actionToShortcuts);
        }
        actionToShortcuts.put(action, shortcuts);
    }

    public void removeShortcut(ShortcutAction action, String shortcut) {
        LinkedHashSet<String> s = new LinkedHashSet<String>(Arrays.asList(this.getShortcuts(action)));
        s.remove(shortcut);
        this.setShortcuts(action, s);
    }

    @Override
    public void refreshActions() {
        this.categoryToActionsCache = new HashMap<String, List<Object>>();
        this.shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.model.refreshActions();
    }

    @Override
    public void apply() {
        if (this.applyInProgress) {
            return;
        }
        this.applyInProgress = true;
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                for (String profile : KeymapViewModel.this.modifiedProfiles.keySet()) {
                    Map actionToShortcuts = (Map)KeymapViewModel.this.modifiedProfiles.get(profile);
                    actionToShortcuts = KeymapViewModel.convertToEmacs(actionToShortcuts);
                    KeymapViewModel.this.model.changeKeymap(profile, actionToShortcuts);
                }
                for (String profile : KeymapViewModel.this.deletedProfiles) {
                    KeymapViewModel.this.model.deleteProfile(profile);
                }
                KeymapViewModel.this.model.setCurrentProfile(KeymapViewModel.this.currentProfile);
                KeymapViewModel.this.modifiedProfiles = new HashMap();
                KeymapViewModel.this.deletedProfiles = new HashSet();
                KeymapViewModel.this.shortcutsCache = new HashMap();
                KeymapViewModel.this.model = new KeymapModel();
                KeymapViewModel.this.applyInProgress = false;
            }
        });
    }

    public boolean isChanged() {
        return !this.modifiedProfiles.isEmpty() || !this.deletedProfiles.isEmpty();
    }

    public void cancel() {
        this.modifiedProfiles = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.deletedProfiles = new HashSet<String>();
        this.shortcutsCache = new HashMap<String, Map<ShortcutAction, Set<String>>>();
        this.setCurrentProfile(this.model.getCurrentProfile());
        this.model = new KeymapModel();
    }

    Map<String, Map<ShortcutAction, Set<String>>> getModifiedProfiles() {
        return this.modifiedProfiles;
    }

    Set<String> getDeletedProfiles() {
        return this.deletedProfiles;
    }

    void setModifiedProfiles(Map<String, Map<ShortcutAction, Set<String>>> mp) {
        this.modifiedProfiles = mp;
    }

    void setDeletedProfiles(Set<String> dp) {
        this.deletedProfiles = dp;
    }

    @Override
    public String showShortcutsDialog() {
        final ShortcutsDialog d = new ShortcutsDialog();
        d.init(this);
        final DialogDescriptor descriptor = new DialogDescriptor((Object)d, KeymapViewModel.loc("Add_Shortcut_Dialog"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, (ActionListener)d.getListener());
        descriptor.setClosingOptions(new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION});
        descriptor.setAdditionalOptions(new Object[]{d.getBClear(), d.getBTab()});
        descriptor.setValid(d.isShortcutValid());
        d.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == null || "ShortcutsDialog.PROP_SHORTCUT_VALID".equals(evt.getPropertyName())) {
                    descriptor.setValid(d.isShortcutValid());
                }
            }
        });
        DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
            return d.getTfShortcut().getText();
        }
        return null;
    }

    private static Map<ShortcutAction, Set<String>> convertToEmacs(Map<ShortcutAction, Set<String>> shortcuts) {
        HashMap<ShortcutAction, Set<String>> result = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : shortcuts.entrySet()) {
            ShortcutAction action = entry.getKey();
            HashSet<String> newSet = new HashSet<String>();
            for (String s : entry.getValue()) {
                KeyStroke[] ks;
                if (s.length() == 0 || (ks = KeymapViewModel.getKeyStrokes(s, " ")) == null) continue;
                StringBuffer sb = new StringBuffer(Utilities.keyToString((KeyStroke)ks[0]));
                int k = ks.length;
                for (int i = 1; i < k; ++i) {
                    sb.append(' ').append(Utilities.keyToString((KeyStroke)ks[i]));
                }
                newSet.add(sb.toString());
            }
            result.put(action, newSet);
        }
        return result;
    }

    private static Map<ShortcutAction, Set<String>> convertFromEmacs(Map<ShortcutAction, Set<String>> emacs) {
        HashMap<ShortcutAction, Set<String>> result = new HashMap<ShortcutAction, Set<String>>();
        for (Map.Entry<ShortcutAction, Set<String>> entry : emacs.entrySet()) {
            ShortcutAction action = entry.getKey();
            LinkedHashSet<String> shortcuts = new LinkedHashSet<String>();
            for (String emacsShortcut : entry.getValue()) {
                KeyStroke[] keyStroke = Utilities.stringToKeys((String)emacsShortcut);
                shortcuts.add(KeyStrokeUtils.getKeyStrokesAsText(keyStroke, " "));
            }
            result.put(action, shortcuts);
        }
        return result;
    }

    private static KeyStroke[] getKeyStrokes(String keyStrokes, String delim) {
        if (keyStrokes.length() == 0) {
            return new KeyStroke[0];
        }
        StringTokenizer st = new StringTokenizer(keyStrokes, delim);
        ArrayList<KeyStroke> result = new ArrayList<KeyStroke>();
        while (st.hasMoreTokens()) {
            String ks = st.nextToken().trim();
            KeyStroke keyStroke = KeyStrokeUtils.getKeyStroke(ks);
            if (keyStroke == null) {
                return null;
            }
            result.add(keyStroke);
        }
        return result.toArray(new KeyStroke[result.size()]);
    }

    private static String loc(String key) {
        return NbBundle.getMessage(KeymapPanel.class, (String)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runWithoutEvents(Runnable r) {
        try {
            this.supressDataEvents = true;
            r.run();
        }
        finally {
            this.supressDataEvents = false;
        }
    }

    static class ActionsComparator
    implements Comparator {
        ActionsComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof String) {
                if (o2 instanceof String) {
                    return ((String)o1).compareTo((String)o2);
                }
                return 1;
            }
            if (o2 instanceof String) {
                return -1;
            }
            return ((ShortcutAction)o1).getDisplayName().compareTo(((ShortcutAction)o2).getDisplayName());
        }
    }
}

