/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.utilities;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import org.netbeans.modules.utilities.Bundle;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.util.Lookup;
import org.openide.util.datatransfer.ExClipboard;

public final class CopyPathToClipboardAction
implements ActionListener,
ClipboardOwner {
    private final List<DataObject> context;

    public CopyPathToClipboardAction(List<DataObject> context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String pathListString;
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        int items = 0;
        for (DataObject dataObject : this.context) {
            if (items > 0) {
                sb.append(lineSeparator);
            }
            sb.append(this.getAbsolutePath(dataObject));
            ++items;
        }
        if (items > 0 && !(pathListString = sb.toString()).isEmpty()) {
            this.setClipboardContents(pathListString, items);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public String getAbsolutePath(DataObject dataObject) {
        String fileName = null;
        if (null != dataObject) {
            FileObject primaryFile = this.getFileObjectWithShadowSupport(dataObject);
            if (null != primaryFile.getPath()) {
                fileName = primaryFile.getPath();
            }
            if (null != FileUtil.getArchiveFile((FileObject)primaryFile)) {
                String fullJARPath = FileUtil.getArchiveFile((FileObject)primaryFile).getPath();
                String archiveFileName = primaryFile.getPath();
                boolean hasFileName = null != archiveFileName && !"".equals(archiveFileName);
                fileName = hasFileName ? fullJARPath + File.pathSeparator + archiveFileName : fullJARPath;
            }
        }
        return fileName;
    }

    private FileObject getFileObjectWithShadowSupport(DataObject dataObject) {
        if (dataObject instanceof DataShadow) {
            DataShadow dataShadow = (DataShadow)dataObject;
            return dataShadow.getOriginal().getPrimaryFile();
        }
        return dataObject.getPrimaryFile();
    }

    private void setClipboardContents(String content, int items) {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        if (clipboard != null) {
            String statusText = items > 1 ? Bundle.CTL_Status_CopyToClipboardMulti(items) : Bundle.CTL_Status_CopyToClipboardSingle(content);
            StatusDisplayer.getDefault().setStatusText(statusText);
            clipboard.setContents(new StringSelection(content), null);
        }
    }
}

