/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.builders.VHDLCodeBuilder;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.GlobalsPanel;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.TemplateList;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParser;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParserException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class TemplateChooserPanel
extends JPanel
implements ListSelectionListener {
    private static final Logger logger = Logger.getLogger(TemplateChooserPanel.class.getName());
    private final Object[] templates;
    private final Entity.EntityType templateType;
    private final boolean showEntityName;
    private final String id;
    private JSplitPane jSplitPaneHorizontal;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JSplitPane jSplitPaneVertical;
    private JPanel topPanel;
    private JScrollPane topScroll;
    private TemplateList list;
    private JPanel bottomPanel;
    private JScrollPane bottomScroll;
    private JPanel radioButtonsPanel;
    private JRadioButton fileButton;
    private JRadioButton clipboardButton;
    private GlobalsPanel globalsPanel;
    private JScrollPane rightScroll;
    private JEditorPane editor;
    private FileObject tmp;
    private Map<String, String> dollars;

    private TemplateChooserPanel(Object[] templates, Entity.EntityType templateType, boolean showEntityName, String id) {
        this.templates = templates;
        this.templateType = templateType;
        this.showEntityName = showEntityName;
        this.id = id;
        this.initComponents();
    }

    public static TemplateChooserPanel createTemplateChooserPanel(Object[] templates, Entity.EntityType templateType, boolean showEntityName, String id) {
        return new TemplateChooserPanel(templates, templateType, showEntityName, id);
    }

    public static TemplateChooserPanel createTemplateChooserPanelParametrized(Object[] templates, Entity.EntityType templateType, boolean showEntityName, String id) {
        TemplateChooserPanel templatePanel = TemplateChooserPanel.createTemplateChooserPanel(templates, templateType, showEntityName, id);
        int incPanelWidth = NbPreferences.forModule(TemplateChooserPanel.class).getInt(id + "Width", 1000);
        int incPanelHeight = NbPreferences.forModule(TemplateChooserPanel.class).getInt(id + "Height", 600);
        int incPanelHorDiv = NbPreferences.forModule(TemplateChooserPanel.class).getInt(id + "HorDiv", 200);
        String tb = templateType.equals((Object)Entity.EntityType.TESTBENCH_TEMPLATE) ? "TB" : "";
        int defaultVertDiv = templateType.equals((Object)Entity.EntityType.TESTBENCH_TEMPLATE) ? 520 : 260;
        int incPanelVertDiv = NbPreferences.forModule(TemplateChooserPanel.class).getInt(tb + id + "VertDiv", defaultVertDiv);
        templatePanel.setPreferredSize(new Dimension(incPanelWidth, incPanelHeight));
        templatePanel.setHorizontalDividerLocation(incPanelHorDiv);
        templatePanel.setVerticalDividerLocation(incPanelVertDiv);
        return templatePanel;
    }

    public void storeParameters() {
        NbPreferences.forModule(TemplateChooserPanel.class).putInt(this.id + "Width", (int)this.getSize().getWidth());
        NbPreferences.forModule(TemplateChooserPanel.class).putInt(this.id + "Height", (int)this.getSize().getHeight());
        NbPreferences.forModule(TemplateChooserPanel.class).putInt(this.id + "HorDiv", this.getHorizontalDividerLocation());
        String tb = this.isTBTemplate() ? "TB" : "";
        NbPreferences.forModule(TemplateChooserPanel.class).putInt(tb + this.id + "VertDiv", this.getVerticalDividerLocation());
    }

    private void initComponents() {
        this.jSplitPaneHorizontal = new JSplitPane();
        this.jSplitPaneHorizontal.setOrientation(1);
        this.leftPanel = new JPanel(new BorderLayout());
        this.rightPanel = new JPanel(new BorderLayout());
        this.jSplitPaneVertical = new JSplitPane();
        this.jSplitPaneVertical.setOrientation(0);
        this.topPanel = new JPanel(new BorderLayout());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.topScroll = new JScrollPane();
        this.list = new TemplateList(this.templates);
        this.list.addListSelectionListener(this);
        this.topScroll.setViewportView(this.list);
        this.topPanel.add((Component)this.topScroll, "Center");
        this.bottomScroll = new JScrollPane();
        this.fileButton = new JRadioButton("file");
        this.fileButton.setActionCommand("file");
        this.fileButton.setSelected(true);
        this.clipboardButton = new JRadioButton("clipboard");
        this.clipboardButton.setActionCommand("clipboard");
        ButtonGroup destinationGroup = new ButtonGroup();
        destinationGroup.add(this.fileButton);
        destinationGroup.add(this.clipboardButton);
        this.radioButtonsPanel = new JPanel();
        this.radioButtonsPanel.add(this.fileButton);
        this.radioButtonsPanel.add(this.clipboardButton);
        if (this.templateType.equals((Object)Entity.EntityType.TESTBENCH_TEMPLATE)) {
            this.bottomPanel.add((Component)new JLabel("OUTPUT: "), "First");
            this.bottomPanel.add((Component)this.radioButtonsPanel, "Center");
        } else {
            this.bottomPanel.add((Component)this.bottomScroll, "Center");
        }
        this.jSplitPaneVertical.setDividerLocation(0.5);
        this.jSplitPaneVertical.setResizeWeight(0.5);
        this.jSplitPaneVertical.setTopComponent(this.topPanel);
        this.jSplitPaneVertical.setBottomComponent(this.bottomPanel);
        this.leftPanel.add((Component)this.jSplitPaneVertical, "Center");
        this.rightScroll = new JScrollPane();
        this.editor = new JEditorPane();
        this.editor.setEditable(false);
        try {
            this.tmp = FileUtil.createMemoryFileSystem().getRoot().createData("tmp", "vhdl");
            DialogBinding.bindComponentToFile((FileObject)this.tmp, (int)0, (int)0, (JTextComponent)this.editor);
            this.editor.setText("choose template");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.rightScroll.setViewportView(this.editor);
        this.rightPanel.add((Component)this.rightScroll, "Center");
        this.jSplitPaneHorizontal.setDividerLocation(200);
        this.jSplitPaneHorizontal.setLeftComponent(this.leftPanel);
        this.jSplitPaneHorizontal.setBottomComponent(this.rightPanel);
        this.setPreferredSize(new Dimension(1000, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jSplitPaneHorizontal, "Center");
    }

    public FileObject getSelectedFile() {
        return (FileObject)this.list.getSelectedValue();
    }

    public String getEntityName() {
        return this.globalsPanel.getEntityName();
    }

    public String getNewName(String origName) {
        return this.globalsPanel.getNewName(origName);
    }

    public Map<String, String> getDollarMarks() {
        return this.dollars;
    }

    public boolean isFileOutput() {
        return this.fileButton.isSelected();
    }

    private boolean isTBTemplate() {
        return this.templateType.equals((Object)Entity.EntityType.TESTBENCH_TEMPLATE);
    }

    private int getHorizontalDividerLocation() {
        return this.jSplitPaneHorizontal.getDividerLocation();
    }

    private void setHorizontalDividerLocation(int location) {
        this.jSplitPaneHorizontal.setDividerLocation(location);
    }

    private int getVerticalDividerLocation() {
        return this.jSplitPaneVertical.getDividerLocation();
    }

    private void setVerticalDividerLocation(int location) {
        this.jSplitPaneVertical.setDividerLocation(location);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.list.getSelectedIndex() == -1) {
                this.editor.setText("choose template");
            } else {
                try {
                    FileObject fob = (FileObject)this.list.getSelectedValue();
                    this.editor.setText(fob.asText());
                    this.editor.setCaretPosition(0);
                    this.readDollarMarks(fob);
                    this.globalsPanel = new GlobalsPanel(fob.getName(), this.dollars, this.showEntityName);
                    this.bottomScroll.setViewportView(this.globalsPanel);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    private void readDollarMarks(FileObject template) {
        this.dollars = new LinkedHashMap<String, String>();
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)template));
            parser.getDollarMarks(this.dollars);
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_SEVERE_ParserError");
            Exceptions.printStackTrace((Throwable)e);
            logger.log(Level.SEVERE, msg);
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_SEVERE_ParserIOError");
            Exceptions.printStackTrace((Throwable)e);
            logger.log(Level.SEVERE, msg);
        }
    }
}

