/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class InconsistentEntityTable
extends JTable {
    public InconsistentEntityTable(List<InconsistentEntity> inconsistentEntities) {
        this.setModel(new EntityTableModel(inconsistentEntities));
        TableColumn entity = this.getColumnModel().getColumn(0);
        entity.setMinWidth(50);
        entity.setPreferredWidth(200);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setToolTipText("Select entity to show its inconsistencies");
    }

    public InconsistentEntity getSelectedInconsistentEntity() {
        EntityTableModel eModel = (EntityTableModel)this.getModel();
        return eModel.getSelectedInconsistentEntity();
    }

    public void setTableData(List<InconsistentEntity> dataList) {
        EntityTableModel incModel = (EntityTableModel)this.getModel();
        incModel.setTableData(dataList);
    }

    private class EntityTableModel
    extends AbstractTableModel {
        public static final int ENTITY_INDEX = 0;
        protected final String[] columnNames = new String[]{"Entity"};
        protected List<InconsistentEntity> dataList;

        public EntityTableModel(List<InconsistentEntity> dataList) {
            this.dataList = dataList;
        }

        public void setTableData(List<InconsistentEntity> dataList) {
            this.dataList = dataList;
            this.fireTableDataChanged();
            if (!dataList.isEmpty()) {
                InconsistentEntityTable.this.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public InconsistentEntity getSelectedInconsistentEntity() {
            if (InconsistentEntityTable.this.getSelectedRow() != -1 && this.dataList != null && InconsistentEntityTable.this.getSelectedRow() < this.dataList.size()) {
                return this.dataList.get(InconsistentEntityTable.this.getSelectedRow());
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class<? extends Object> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            InconsistentEntity entity = this.dataList.get(row);
            switch (column) {
                case 0: {
                    return entity.getEntity().getEntityName();
                }
            }
            return new Object();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            switch (column) {
                default: 
            }
            System.err.println("Invalid index when setting value in InconsistencyModalWindow.");
        }

        @Override
        public int getRowCount() {
            return this.dataList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }
    }
}

