/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class InconsistencyTable
extends JTable {
    public InconsistencyTable() {
        this.setModel(new InconsistencyTableModel());
        TableColumn checked = this.getColumnModel().getColumn(0);
        checked.setMinWidth(20);
        checked.setPreferredWidth(45);
        checked.setMaxWidth(100);
        TableColumn desc = this.getColumnModel().getColumn(1);
        desc.setMinWidth(150);
        desc.setPreferredWidth(450);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setToolTipText("Check inconsistencies to repair");
    }

    public void setTableData(List<Inconsistency> dataList) {
        InconsistencyTableModel incModel = (InconsistencyTableModel)this.getModel();
        incModel.setTableData(dataList);
    }

    public Inconsistency getSelectedInconsistency() {
        InconsistencyTableModel incModel = (InconsistencyTableModel)this.getModel();
        return incModel.getSelectedInconsistency();
    }

    private class InconsistencyTableModel
    extends AbstractTableModel {
        public static final int CHECKED_INDEX = 0;
        public static final int DESCRIPTION_INDEX = 1;
        protected final String[] columnNames = new String[]{"Check", "Description"};
        protected List<Inconsistency> dataList = null;

        public void setTableData(List<Inconsistency> dataList) {
            this.dataList = dataList;
            this.fireTableDataChanged();
            if (!dataList.isEmpty()) {
                InconsistencyTable.this.getSelectionModel().setSelectionInterval(0, 0);
            }
        }

        public Inconsistency getSelectedInconsistency() {
            if (InconsistencyTable.this.getSelectedRow() != -1 && this.dataList != null && InconsistencyTable.this.getSelectedRow() < this.dataList.size()) {
                return this.dataList.get(InconsistencyTable.this.getSelectedRow());
            }
            return null;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        public Class<? extends Object> getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            Inconsistency inconsistency = this.dataList.get(row);
            switch (column) {
                case 0: {
                    return inconsistency.isChecked();
                }
                case 1: {
                    return inconsistency.getTableDescription();
                }
            }
            return new Object();
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Inconsistency inconsistency = this.dataList.get(row);
            switch (column) {
                case 0: {
                    inconsistency.setChecked((Boolean)value);
                    break;
                }
                default: {
                    System.err.println("Invalid index when setting value in InconsistencyModalWindow.");
                }
            }
        }

        @Override
        public int getRowCount() {
            if (this.dataList == null) {
                return 0;
            }
            return this.dataList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }
    }
}

