/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.InconsistentEntityPanel;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.InconsistencyService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.EIInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.ESInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.FixPack;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class InconsistencyPanel
extends JPanel
implements ListSelectionListener,
ActionListener {
    private final List<InconsistentEntity> inconsistentEntities;
    private final List<InconsistentEntity> inconsistentEntitiesNoSignals;
    private final String id;
    private JSplitPane jSplitPaneVertical;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private InconsistentEntityPanel inconsistentEntityPanel;
    private JSplitPane jSplitPaneHorizontal;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel radioButtonPanel;
    private JScrollPane jScrollPaneLeft;
    private JScrollPane jScrollPaneRight;
    private JEditorPane leftEditor;
    private JEditorPane rightEditor;
    JCheckBox filterSignalsCheckBox;
    JRadioButton inlineGenericsButton;
    JRadioButton belowGenericsButton;
    JRadioButton inlinePortsButton;
    JRadioButton belowPortsButton;
    private FileObject tmpOld;
    private FileObject tmpFixed;
    InconsistencyService service;
    Inconsistency lastSelected;
    Inconsistency selected;

    private InconsistencyPanel(List<InconsistentEntity> inconsistentEntities, boolean filterSignals, String id) {
        this.inconsistentEntities = inconsistentEntities;
        this.inconsistentEntitiesNoSignals = this.getInconsistentEntitiesWithoutSignals();
        this.id = id;
        this.initComponents(filterSignals);
    }

    public static InconsistencyPanel createInconsistencyPanel(List<InconsistentEntity> inconsistentEntities, String id) {
        return new InconsistencyPanel(inconsistentEntities, true, id);
    }

    public static InconsistencyPanel createInconsistencyPanelParametrized(List<InconsistentEntity> inconsistentEntities, String id) {
        boolean filterSignals = NbPreferences.forModule(InconsistencyPanel.class).getBoolean(id + "FilterSignals", true);
        InconsistencyPanel inconsistencyPanel = new InconsistencyPanel(inconsistentEntities, filterSignals, id);
        int incPanelWidth = NbPreferences.forModule(InconsistencyPanel.class).getInt(id + "Width", 1000);
        int incPanelHeight = NbPreferences.forModule(InconsistencyPanel.class).getInt(id + "Height", 600);
        int incPanelHorDiv = NbPreferences.forModule(InconsistencyPanel.class).getInt(id + "HorDiv", 495);
        int incPanelVertDiv = NbPreferences.forModule(InconsistencyPanel.class).getInt(id + "VertDiv", 120);
        int incPanelTableDiv = NbPreferences.forModule(InconsistencyPanel.class).getInt(id + "TableDiv", 300);
        inconsistencyPanel.setPreferredSize(new Dimension(incPanelWidth, incPanelHeight));
        inconsistencyPanel.setHorizontalDividerLocation(incPanelHorDiv);
        inconsistencyPanel.setVerticalDividerLocation(incPanelVertDiv);
        inconsistencyPanel.setTableDividerLocation(incPanelTableDiv);
        return inconsistencyPanel;
    }

    public void storeParameters() {
        NbPreferences.forModule(InconsistencyPanel.class).putInt(this.id + "Width", (int)this.getSize().getWidth());
        NbPreferences.forModule(InconsistencyPanel.class).putInt(this.id + "Height", (int)this.getSize().getHeight());
        NbPreferences.forModule(InconsistencyPanel.class).putInt(this.id + "HorDiv", this.getHorizontalDividerLocation());
        NbPreferences.forModule(InconsistencyPanel.class).putInt(this.id + "VertDiv", this.getVerticalDividerLocation());
        NbPreferences.forModule(InconsistencyPanel.class).putInt(this.id + "TableDiv", this.getTableDividerLocation());
        NbPreferences.forModule(InconsistencyPanel.class).putBoolean(this.id + "FilterSignals", this.getFilterSignalsCheckBoxValue());
    }

    private void initComponents(boolean filterSignals) {
        this.jSplitPaneVertical = new JSplitPane();
        this.jSplitPaneVertical.setOrientation(0);
        this.topPanel = new JPanel(new BorderLayout());
        this.bottomPanel = new JPanel(new BorderLayout());
        this.inconsistentEntityPanel = filterSignals ? new InconsistentEntityPanel(this.inconsistentEntitiesNoSignals) : new InconsistentEntityPanel(this.inconsistentEntities);
        this.inconsistentEntityPanel.getSelectionModel().addListSelectionListener(this);
        this.topPanel.add((Component)this.inconsistentEntityPanel, "Center");
        this.jSplitPaneHorizontal = new JSplitPane();
        this.jSplitPaneHorizontal.setOrientation(1);
        this.leftPanel = new JPanel(new BorderLayout());
        this.leftPanel.add((Component)new JLabel("To remove:"), "First");
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((Component)new JLabel("To add:"), "First");
        this.jScrollPaneLeft = new JScrollPane();
        this.leftEditor = new JEditorPane();
        this.leftEditor.setEditable(false);
        try {
            this.tmpOld = FileUtil.createMemoryFileSystem().getRoot().createData("tmpOld", "vhdl");
            DialogBinding.bindComponentToFile((FileObject)this.tmpOld, (int)0, (int)0, (JTextComponent)this.leftEditor);
            this.leftEditor.setText("choose inconsistency");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.jScrollPaneLeft.setViewportView(this.leftEditor);
        this.leftPanel.add((Component)this.jScrollPaneLeft, "Center");
        this.jScrollPaneRight = new JScrollPane();
        this.rightEditor = new JEditorPane();
        this.rightEditor.setEditable(false);
        this.rightEditor.setFocusTraversalKeys(0, Collections.emptySet());
        try {
            this.tmpFixed = FileUtil.createMemoryFileSystem().getRoot().createData("tmpFixed", "vhdl");
            DialogBinding.bindComponentToFile((FileObject)this.tmpFixed, (int)0, (int)0, (JTextComponent)this.rightEditor);
            this.rightEditor.setText("choose inconsistency");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.jScrollPaneRight.setViewportView(this.rightEditor);
        this.rightPanel.add((Component)this.jScrollPaneRight, "Center");
        this.jSplitPaneHorizontal.setDividerLocation(0.5);
        this.jSplitPaneHorizontal.setResizeWeight(0.5);
        this.jSplitPaneHorizontal.setLeftComponent(this.leftPanel);
        this.jSplitPaneHorizontal.setRightComponent(this.rightPanel);
        this.inlineGenericsButton = new JRadioButton("inline");
        this.inlineGenericsButton.setActionCommand("inlineGenerics");
        this.inlineGenericsButton.setSelected(true);
        this.inlineGenericsButton.addActionListener(this);
        this.belowGenericsButton = new JRadioButton("below");
        this.belowGenericsButton.setActionCommand("belowGenerics");
        this.belowGenericsButton.addActionListener(this);
        ButtonGroup genericsGroup = new ButtonGroup();
        genericsGroup.add(this.inlineGenericsButton);
        genericsGroup.add(this.belowGenericsButton);
        this.inlinePortsButton = new JRadioButton("inline");
        this.inlinePortsButton.setActionCommand("inlinePorts");
        this.inlinePortsButton.setSelected(true);
        this.inlinePortsButton.addActionListener(this);
        this.belowPortsButton = new JRadioButton("below");
        this.belowPortsButton.setActionCommand("belowPorts");
        this.belowPortsButton.addActionListener(this);
        ButtonGroup portsGroup = new ButtonGroup();
        portsGroup.add(this.inlinePortsButton);
        portsGroup.add(this.belowPortsButton);
        this.filterSignalsCheckBox = new JCheckBox("filter signal inconsistencies");
        this.filterSignalsCheckBox.setToolTipText("show signal inconsistencies only if component or instance differs");
        this.filterSignalsCheckBox.setSelected(filterSignals);
        this.filterSignalsCheckBox.setActionCommand("filterSignals");
        this.filterSignalsCheckBox.addActionListener(this);
        this.radioButtonPanel = new JPanel(new FlowLayout(2));
        this.radioButtonPanel.add(this.filterSignalsCheckBox);
        this.radioButtonPanel.add(new JLabel("                        GENERICS:"));
        this.radioButtonPanel.add(this.inlineGenericsButton);
        this.radioButtonPanel.add(this.belowGenericsButton);
        this.radioButtonPanel.add(new JLabel("            PORTS:"));
        this.radioButtonPanel.add(this.inlinePortsButton);
        this.radioButtonPanel.add(this.belowPortsButton);
        this.bottomPanel.add((Component)this.radioButtonPanel, "First");
        this.bottomPanel.add((Component)this.jSplitPaneHorizontal, "Center");
        this.jSplitPaneVertical.setDividerLocation(200);
        this.jSplitPaneVertical.setTopComponent(this.topPanel);
        this.jSplitPaneVertical.setBottomComponent(this.bottomPanel);
        this.setPreferredSize(new Dimension(1000, 600));
        this.setLayout(new BorderLayout());
        this.add((Component)this.jSplitPaneVertical, "Center");
        this.service = InconsistencyService.getDefault();
        this.setRadioButtonsEnabled(false);
        this.lastSelected = null;
        this.selected = null;
    }

    @Override
    public void valueChanged(ListSelectionEvent ev) {
        this.valueChanged(false);
    }

    private void valueChanged(boolean rebuildFixPack) {
        this.selected = this.inconsistentEntityPanel.getSelectedInconsistency();
        this.storeChanges();
        this.lastSelected = this.selected;
        if (this.selected == null) {
            this.leftEditor.setText("choose inconsistency");
            this.rightEditor.setText("choose inconsistency");
        } else {
            FixPack fixPack = this.selected.getFixPack();
            try {
                if (fixPack == null || rebuildFixPack) {
                    fixPack = this.service.fixInconsistency(this.selected);
                    this.selected.setFixPack(fixPack);
                }
                String text = this.selected.getEntityFOB().asText();
                this.leftEditor.setText(text);
                if (fixPack.getRemovePosition() != null) {
                    int from = (int)fixPack.getRemovePosition().getFrom();
                    int to = (int)fixPack.getRemovePosition().getTo();
                    String beforeText = text.substring(0, from);
                    int fromCount = 0;
                    for (char c : beforeText.toCharArray()) {
                        if (c != '\r') continue;
                        ++fromCount;
                    }
                    String selectedText = text.substring(from, to);
                    int toCount = fromCount;
                    for (char c : selectedText.toCharArray()) {
                        if (c != '\r') continue;
                        ++toCount;
                    }
                    this.leftEditor.select(from - fromCount, to - toCount);
                    this.leftEditor.scrollRectToVisible(new Rectangle(this.leftEditor.modelToView(from)));
                }
                this.rightEditor.setEditable(true);
                this.rightEditor.setText(fixPack.getFixedCode());
                this.rightEditor.setSelectionStart(0);
                this.rightEditor.scrollRectToVisible(new Rectangle());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (BadLocationException be) {
                Exceptions.printStackTrace((Throwable)be);
            }
            if (this.selected.getRelationship().equals((Object)Inconsistency.InconsistencyRelationship.EI)) {
                this.setRadioButtonsEnabled(true);
                EIInconsistency inc = (EIInconsistency)this.selected;
                if (!rebuildFixPack) {
                    if (inc.isGenericsInRow().booleanValue()) {
                        this.inlineGenericsButton.setSelected(true);
                    } else {
                        this.belowGenericsButton.setSelected(true);
                    }
                    if (inc.isPortsInRow().booleanValue()) {
                        this.inlinePortsButton.setSelected(true);
                    } else {
                        this.belowPortsButton.setSelected(true);
                    }
                }
            } else {
                this.setRadioButtonsEnabled(false);
            }
        }
    }

    public void activateLeftEditorListener(final Dialog dialog) {
        MouseCaretListener l = new MouseCaretListener(){

            @Override
            protected void closeInconsistencyDialog() {
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        this.leftEditor.addMouseListener(l);
        this.leftEditor.addCaretListener(l);
    }

    public void storeChanges() {
        if (this.lastSelected != null) {
            FixPack fixPack = this.lastSelected.getFixPack();
            fixPack.setFixedCode(this.rightEditor.getText());
        }
    }

    private int getHorizontalDividerLocation() {
        return this.jSplitPaneHorizontal.getDividerLocation();
    }

    private void setHorizontalDividerLocation(int location) {
        this.jSplitPaneHorizontal.setDividerLocation(location);
    }

    private int getVerticalDividerLocation() {
        return this.jSplitPaneVertical.getDividerLocation();
    }

    private void setVerticalDividerLocation(int location) {
        this.jSplitPaneVertical.setDividerLocation(location);
    }

    private int getTableDividerLocation() {
        return this.inconsistentEntityPanel.getHorizontalDividerLocation();
    }

    private void setTableDividerLocation(int location) {
        this.inconsistentEntityPanel.setHorizontalDividerLocation(location);
    }

    private boolean getFilterSignalsCheckBoxValue() {
        return this.filterSignalsCheckBox.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("filterSignals")) {
            if (!this.filterSignalsCheckBox.isSelected()) {
                this.inconsistentEntityPanel.setNewData(this.inconsistentEntities);
            } else {
                this.inconsistentEntityPanel.setNewData(this.inconsistentEntitiesNoSignals);
            }
            this.valueChanged(false);
        } else {
            EIInconsistency inc = (EIInconsistency)this.inconsistentEntityPanel.getSelectedInconsistency();
            if (e.getActionCommand().equals("inlineGenerics")) {
                inc.setGenericsInRow(Boolean.valueOf(true));
            } else if (e.getActionCommand().equals("belowGenerics")) {
                inc.setGenericsInRow(Boolean.valueOf(false));
            } else if (e.getActionCommand().equals("inlinePorts")) {
                inc.setPortsInRow(Boolean.valueOf(true));
            } else if (e.getActionCommand().equals("belowPorts")) {
                inc.setPortsInRow(Boolean.valueOf(false));
            }
            this.valueChanged(true);
        }
    }

    private void setRadioButtonsEnabled(boolean enabled) {
        this.inlineGenericsButton.setEnabled(enabled);
        this.belowGenericsButton.setEnabled(enabled);
        this.inlinePortsButton.setEnabled(enabled);
        this.belowPortsButton.setEnabled(enabled);
    }

    private List<InconsistentEntity> getInconsistentEntitiesWithoutSignals() {
        ArrayList<InconsistentEntity> without = new ArrayList<InconsistentEntity>();
        for (InconsistentEntity entity : this.inconsistentEntities) {
            ArrayList<Inconsistency> inconsistencies = new ArrayList<Inconsistency>();
            for (Inconsistency inc : entity.getInconsistencies()) {
                if (!inc.getRelationship().equals((Object)Inconsistency.InconsistencyRelationship.ES)) {
                    inconsistencies.add(inc);
                    continue;
                }
                ESInconsistency esinc = (ESInconsistency)inc;
                if (!esinc.isDeclarationInconsistent() && !esinc.isInstantiationInconsistent()) continue;
                inconsistencies.add(inc);
            }
            if (inconsistencies.isEmpty()) continue;
            InconsistentEntity shadow = new InconsistentEntity(entity.getEntity(), entity.getEntityFOB(), inconsistencies);
            without.add(shadow);
        }
        return without;
    }

    public abstract class MouseCaretListener
    extends MouseAdapter
    implements CaretListener {
        private int dot = -1;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() >= 2 && this.dot >= 0 && InconsistencyPanel.this.selected != null && InconsistencyPanel.this.selected.getEntityFOB() != null) {
                this.closeInconsistencyDialog();
                this.openEditor(this.dot);
            }
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (e.getDot() >= 0) {
                this.dot = e.getDot();
            }
        }

        protected abstract void closeInconsistencyDialog();

        private void openEditor(int dot) {
            try {
                DataObject dao = DataObject.find((FileObject)InconsistencyPanel.this.selected.getEntityFOB());
                if (dao != null) {
                    OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                    open.open();
                    EditorCookie edit = (EditorCookie)dao.getLookup().lookup(EditorCookie.class);
                    JEditorPane pane = edit.getOpenedPanes()[0];
                    if (pane.getDocument().getLength() < dot) {
                        pane.setCaretPosition(pane.getDocument().getLength());
                    } else {
                        pane.setCaretPosition(dot);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

