/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.services;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.ProjectRefreshEvent;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.VHDLProject;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.builders.VHDLCodeBuilder;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.ProjectStructure;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.EntityPanel;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.InconsistencyPanel;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.TemplateChooserPanel;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.ConsistencyCheckerService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.EntityService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.InconsistencyService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Declaration;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.VHDLDataObject;
import java.awt.Dialog;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class VHDLProjectServiceImpl
implements VHDLProjectService {
    private static final Logger logger = Logger.getLogger(VHDLProjectServiceImpl.class.getName());
    private InstanceContent content;
    private Lookup lookup;
    private final VHDLProject project;
    private final FileObject root;
    private static final RequestProcessor RP = new RequestProcessor("VHDLProjectServiceImpl", 1, true);
    private final String generateBT = "GENERATE";
    private final String fixBT = "FIX";
    private final String openBT = "OPEN";
    private final String cancelBT = "Cancel";

    public VHDLProjectServiceImpl(VHDLProject project) {
        this.project = project;
        this.root = project.getProjectDirectory();
        this.content = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.content);
    }

    public void refreshProject() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                boolean interrupted = VHDLProjectServiceImpl.this.findAllVHDLFiles();
                if (!interrupted) {
                    VHDLProjectServiceImpl.this.content.set(Arrays.asList(new ProjectRefreshEvent()), null);
                    ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                    StatusDisplayer.getDefault().setStatusText("Project " + info.getDisplayName() + " refreshed.");
                    logger.info(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ProjectRefreshed"));
                } else {
                    StatusDisplayer.getDefault().setStatusText("Project refreshing was cancelled.");
                    logger.info(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ProjectRefreshingCancelled"));
                }
            }
        };
        ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
        String msg = "Analyzing structure of project " + info.getDisplayName() + "...";
        this.runTask(runner, msg);
    }

    public void forceRefreshProject() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProjectStructure projectStructure = (ProjectStructure)VHDLProjectServiceImpl.this.project.getLookup().lookup(ProjectStructure.class);
                for (VHDLDataObject dao : projectStructure.getPackages().values()) {
                    dao.nullStructure();
                }
                for (VHDLDataObject dao : projectStructure.getTestbenches().values()) {
                    dao.nullStructure();
                }
                for (VHDLDataObject dao : projectStructure.getEntities().values()) {
                    dao.nullStructure();
                }
                boolean interrupted = VHDLProjectServiceImpl.this.findAllVHDLFiles();
                if (!interrupted) {
                    VHDLProjectServiceImpl.this.content.set(Arrays.asList(new ProjectRefreshEvent()), null);
                    ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                    StatusDisplayer.getDefault().setStatusText("Project " + info.getDisplayName() + " force refreshed.");
                    logger.info(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ProjectForceRefreshed"));
                } else {
                    StatusDisplayer.getDefault().setStatusText("Project refreshing was cancelled.");
                    logger.info(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ProjectRefreshingCancelled"));
                }
            }
        };
        ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
        String msg = "Analyzing structure of project " + info.getDisplayName() + "...";
        this.runTask(runner, msg);
    }

    private boolean findAllVHDLFiles() {
        ProjectStructure projectStructure = (ProjectStructure)this.project.getLookup().lookup(ProjectStructure.class);
        projectStructure.clear();
        HashSet<String> duplicates = new HashSet<String>();
        FileObject[] objs = this.root.getChildren();
        return this.findVHDLFiles(objs, projectStructure, duplicates);
    }

    private boolean findVHDLFiles(FileObject[] objs, ProjectStructure projectStructure, Set<String> duplicates) {
        for (FileObject obj : objs) {
            if (Thread.interrupted()) {
                return true;
            }
            if (obj.getMIMEType().equals("text/x-vhdl")) {
                try {
                    VHDLDataObject object = (VHDLDataObject)DataObject.find((FileObject)obj);
                    Entity entity = object.getStructure();
                    if (entity == null) {
                        return true;
                    }
                    Entity.EntityType type = entity.getEntityType();
                    if (type.equals((Object)Entity.EntityType.ENTITY)) {
                        this.storeEntity(projectStructure.getEntities(), object, obj, duplicates);
                        continue;
                    }
                    if (type.equals((Object)Entity.EntityType.TESTBENCH)) {
                        this.storeEntity(projectStructure.getTestbenches(), object, obj, duplicates);
                        continue;
                    }
                    if (!type.equals((Object)Entity.EntityType.PACKAGE)) continue;
                    this.storeEntity(projectStructure.getPackages(), object, obj, duplicates);
                }
                catch (DataObjectNotFoundException e) {
                    logger.severe(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_SEVERE_DataObjectNotFoundError"));
                }
                continue;
            }
            if (!obj.isFolder() || !this.findVHDLFiles(obj.getChildren(), projectStructure, duplicates)) continue;
            return true;
        }
        return false;
    }

    private void storeEntity(Map<String, VHDLDataObject> map, VHDLDataObject object, FileObject obj, Set<String> duplicates) {
        String name = object.getStructure().getEntityName().toLowerCase();
        if (map.containsKey(name)) {
            boolean isNew;
            FileObject currentFile = map.get(name).getPrimaryFile();
            if (obj.lastModified().after(currentFile.lastModified())) {
                map.put(name, object);
            }
            if (isNew = duplicates.add(name.toUpperCase())) {
                logger.info(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_NameConflict", (Object)name.toUpperCase()));
            }
        } else {
            map.put(name, object);
        }
    }

    public void findAndOpenEntity(final String entityName) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                final ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)("Searching in " + info.getDisplayName() + " for entity " + entityName + " usage..."));
                progressNotifier.start();
                String key = entityName.trim().toLowerCase();
                ProjectStructure projectStructure = (ProjectStructure)VHDLProjectServiceImpl.this.project.getLookup().lookup(ProjectStructure.class);
                final ArrayList<VHDLDataObject> entities = new ArrayList<VHDLDataObject>();
                for (Map.Entry<String, VHDLDataObject> entry : projectStructure.getEntities().entrySet()) {
                    if (!entry.getKey().contains(key)) continue;
                    entities.add(entry.getValue());
                }
                for (Map.Entry<String, VHDLDataObject> entry : projectStructure.getTestbenches().entrySet()) {
                    if (!entry.getKey().contains(key)) continue;
                    entities.add(entry.getValue());
                }
                for (Map.Entry<String, VHDLDataObject> entry : projectStructure.getPackages().entrySet()) {
                    if (!entry.getKey().contains(key)) continue;
                    entities.add(entry.getValue());
                }
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (entities.isEmpty()) {
                            StatusDisplayer.getDefault().setStatusText("No entity found with name containing given string.");
                            String msg = "Entity with name containing string \"" + entityName + "\" not found in " + info.getDisplayName() + ".";
                            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                            logger.info(msg);
                        } else {
                            VHDLProjectServiceImpl.this.showFoundEntitiesDialog(entities);
                        }
                    }
                });
            }
        };
        RP.post(runner);
    }

    public void findUsage(final String entityName) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)("Searching in " + info.getDisplayName() + " for entity " + entityName + " usage..."));
                progressNotifier.start();
                final List relatedEntities = VHDLProjectServiceImpl.this.findEntityUsage(entityName);
                StatusDisplayer.getDefault().setStatusText("Entity " + entityName + " is instantiated or declared in " + relatedEntities.size() + " entities.");
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VHDLProjectServiceImpl.this.showUsageDialog(relatedEntities, entityName);
                    }
                });
            }
        };
        RP.post(runner);
    }

    private List<VHDLDataObject> findEntityUsage(String entityName) {
        String key = entityName.toLowerCase();
        ProjectStructure structure = (ProjectStructure)this.project.getLookup().lookup(ProjectStructure.class);
        ArrayList<VHDLDataObject> relatedEntities = new ArrayList<VHDLDataObject>();
        if (!structure.getEntities().containsKey(key)) {
            if (structure.getTestbenches().containsKey(key) || structure.getPackages().containsKey(key)) {
                logger.info(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_TestbenchOrPackageUsage"));
            } else {
                logger.severe(NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_SEVERE_ProjectStructureNotFoundUsage"));
            }
            return relatedEntities;
        }
        for (VHDLDataObject object : structure.getTestbenches().values()) {
            if (!this.isUsedInEntity(object.getStructure(), key)) continue;
            relatedEntities.add(object);
        }
        for (VHDLDataObject object : structure.getEntities().values()) {
            if (!this.isUsedInEntity(object.getStructure(), key)) continue;
            relatedEntities.add(object);
        }
        return relatedEntities;
    }

    private boolean isUsedInEntity(Entity entityIn, String key) {
        Declaration dec = (Declaration)entityIn.getDeclarations().get(key);
        if (dec != null) {
            return true;
        }
        for (Instantiation inst : entityIn.getInstantiations().values()) {
            if (!inst.getComponentName().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private void showUsageDialog(List<VHDLDataObject> relatedEntities, String entityName) {
        EntityPanel entityPanel = EntityPanel.createEntityPanelParametrized(relatedEntities.toArray(), VHDTConstants.PARAM_ENTITY_USAGE_PANEL.getName());
        String title = "Usage of " + entityName;
        DialogDescriptor dialog = new DialogDescriptor((Object)entityPanel, title, true, new Object[]{"OPEN", "Cancel"}, (Object)"OPEN", 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialog);
        if (dialog.getValue().equals("OPEN") && entityPanel.getSelectedValuesList() != null) {
            List<Object> selectedEntities = entityPanel.getSelectedValuesList();
            for (Object o : selectedEntities) {
                if (!(o instanceof VHDLDataObject)) continue;
                VHDLDataObject dao = (VHDLDataObject)o;
                OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                open.open();
            }
        }
        entityPanel.storeParameters();
    }

    private void showFoundEntitiesDialog(List<VHDLDataObject> relatedEntities) {
        EntityPanel entityPanel = EntityPanel.createEntityPanelParametrized(relatedEntities.toArray(), VHDTConstants.PARAM_FOUND_ENTITY_PANEL.getName());
        String title = "Found entities";
        DialogDescriptor dialog = new DialogDescriptor((Object)entityPanel, title, true, new Object[]{"OPEN", "Cancel"}, (Object)"OPEN", 0, null, null);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialog);
        if (dialog.getValue().equals("OPEN") && entityPanel.getSelectedValuesList() != null) {
            List<Object> selectedEntities = entityPanel.getSelectedValuesList();
            for (Object o : selectedEntities) {
                if (!(o instanceof VHDLDataObject)) continue;
                VHDLDataObject dao = (VHDLDataObject)o;
                OpenCookie open = (OpenCookie)dao.getLookup().lookup(OpenCookie.class);
                open.open();
            }
        }
        entityPanel.storeParameters();
    }

    public void checkConsistencyUp(final String entityName) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)("Searching in " + info.getDisplayName() + " for entity " + entityName + " inconsistencies..."));
                progressNotifier.start();
                final List inconsistentEntities = ConsistencyCheckerService.getDefault().checkConsistencyUp((Project)VHDLProjectServiceImpl.this.project, entityName);
                String msg = "START******\n";
                msg = msg + NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ConsistencyChecked");
                for (InconsistentEntity ent : inconsistentEntities) {
                    for (Inconsistency inc : ent.getInconsistencies()) {
                        msg = msg + "\n" + inc.getDescription();
                    }
                }
                msg = msg + "\nEND******";
                logger.info(msg);
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VHDLProjectServiceImpl.this.showInconsistencyDialog(inconsistentEntities, entityName);
                    }
                });
            }
        };
        RP.post(runner);
    }

    public void checkConsistencyDown(final String entityName) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)("Searching for inconsistencies in entity " + entityName + ", project " + info.getDisplayName()));
                progressNotifier.start();
                final List inconsistentEntities = ConsistencyCheckerService.getDefault().checkConsistencyDown((Project)VHDLProjectServiceImpl.this.project, entityName);
                String msg = "START******\n";
                msg = msg + NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ConsistencyChecked");
                for (InconsistentEntity ent : inconsistentEntities) {
                    for (Inconsistency inc : ent.getInconsistencies()) {
                        msg = msg + "\n" + inc.getDescription();
                    }
                }
                msg = msg + "\nEND******";
                logger.info(msg);
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VHDLProjectServiceImpl.this.showInconsistencyDialog(inconsistentEntities, entityName);
                    }
                });
            }
        };
        RP.post(runner);
    }

    public void checkConsistency() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectServiceImpl.this.project);
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)("Searching in " + info.getDisplayName() + " for inconsistencies..."));
                progressNotifier.start();
                final List inconsistentEntities = ConsistencyCheckerService.getDefault().checkConsistency((Project)VHDLProjectServiceImpl.this.project);
                String msg = "START******\n";
                msg = msg + NbBundle.getMessage(VHDLProjectServiceImpl.class, (String)"LOG_INFO_ConsistencyChecked");
                for (InconsistentEntity ent : inconsistentEntities) {
                    for (Inconsistency inc : ent.getInconsistencies()) {
                        msg = msg + "\n" + inc.getDescription();
                    }
                }
                msg = msg + "\nEND******";
                logger.info(msg);
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VHDLProjectServiceImpl.this.showInconsistencyDialog(inconsistentEntities, null);
                    }
                });
            }
        };
        RP.post(runner);
    }

    private void showInconsistencyDialog(List<InconsistentEntity> inconsistentEntities, String entityName) {
        ProjectInformation info = ProjectUtils.getInformation((Project)this.project);
        String title = "Inconsistencies of " + info.getDisplayName();
        if (entityName != null) {
            title = title + ", entity " + entityName;
        }
        InconsistencyPanel inconsistencyPanel = InconsistencyPanel.createInconsistencyPanelParametrized(inconsistentEntities, VHDTConstants.PARAM_INCONSISTENCY_PANEL.getName());
        DialogDescriptor dd = new DialogDescriptor((Object)inconsistencyPanel, title, true, new Object[]{"FIX", "Cancel"}, (Object)"FIX", 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        inconsistencyPanel.activateLeftEditorListener(dialog);
        dialog.setVisible(true);
        if (dd.getValue().equals("FIX")) {
            inconsistencyPanel.storeChanges();
            this.fixSelectedInconsistencies(inconsistentEntities);
            StatusDisplayer.getDefault().setStatusText("Selected inconsistencies fixed.");
            this.refreshProject();
        }
        inconsistencyPanel.storeParameters();
    }

    private void fixSelectedInconsistencies(List<InconsistentEntity> inconsistentEntities) {
        InconsistencyService.getDefault().fixAndStoreInconsistencies(inconsistentEntities);
    }

    public void generateNewEntity() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)"Searching for templates...");
                progressNotifier.start();
                final Object[] templateFiles = EntityService.getDefault().getAllTemplateFiles(Entity.EntityType.CODE_TEMPLATE);
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplateChooserPanel templatePanel = TemplateChooserPanel.createTemplateChooserPanelParametrized(templateFiles, Entity.EntityType.CODE_TEMPLATE, true, VHDTConstants.PARAM_TEMPLATE_PANEL.getName());
                        DialogDescriptor dialog = new DialogDescriptor((Object)templatePanel, "Choose Template", true, new Object[]{"GENERATE", "Cancel"}, (Object)"GENERATE", 0, null, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialog);
                        if (dialog.getValue().equals("GENERATE") && templatePanel.getSelectedFile() != null) {
                            VHDLProjectServiceImpl.this.createNewEntity(templatePanel.getSelectedFile(), templatePanel);
                        }
                        templatePanel.storeParameters();
                    }
                });
            }
        };
        RP.post(runner);
    }

    private void createNewEntity(FileObject templateFile, TemplateChooserPanel tp) {
        try {
            VHDLDataObject templateDAO = (VHDLDataObject)DataObject.find((FileObject)templateFile);
            if (!templateDAO.getStructure().getEntityType().equals((Object)Entity.EntityType.CODE_TEMPLATE)) {
                StatusDisplayer.getDefault().setStatusText("Selected VHDL file is not annotated as @CodeTemplate.");
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Selected VHDL file is not annotated as @CodeTemplate. Please choose code template.", 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                logger.warning("Selected VHDL file is not annotated as @CodeTemplate. Please choose code template.");
            } else {
                FileObject newEntity = this.generateNewEntityFOB(templateDAO, tp);
                if (newEntity != null) {
                    this.refreshProject();
                    VHDLDataObject newEntityDAO = (VHDLDataObject)DataObject.find((FileObject)newEntity);
                    OpenCookie open = (OpenCookie)newEntityDAO.getLookup().lookup(OpenCookie.class);
                    open.open();
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            logger.warning("DataObject for selected code template not found");
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private FileObject generateNewEntityFOB(VHDLDataObject template, TemplateChooserPanel tp) {
        try {
            VHDLCodeBuilder builder = VHDLCodeBuilder.getInstance();
            String[] code = builder.createNewEntity(template.getPrimaryFile(), tp);
            if (code != null) {
                String entityName = FileUtil.findFreeFileName((FileObject)this.root, (String)code[0], (String)"vhd");
                entityName = entityName + ".vhd";
                FileObject newEntity = FileUtil.createData((FileObject)this.root, (String)entityName);
                DataOutputStream dos = new DataOutputStream(newEntity.getOutputStream());
                dos.writeBytes(code[1]);
                dos.close();
                VHDLDataObject newEntityDAO = (VHDLDataObject)DataObject.find((FileObject)newEntity);
                String withCases = builder.addCases(newEntityDAO.getStructure(), newEntityDAO.getPrimaryFile());
                if (withCases != null) {
                    dos = new DataOutputStream(newEntity.getOutputStream());
                    dos.writeBytes(withCases);
                    dos.close();
                }
                String msg = "Entity " + code[0] + " successfully created.";
                StatusDisplayer.getDefault().setStatusText(msg);
                logger.info(msg);
                return newEntity;
            }
            return null;
        }
        catch (IOException e) {
            String msg = "Error while creating new entity from template " + template.getName() + ".";
            StatusDisplayer.getDefault().setStatusText(msg);
            logger.severe(msg);
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    private void runTask(Runnable runner, String msg) {
        RequestProcessor.Task theTask = RP.create(runner);
        final ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)msg, (Cancellable)theTask);
        theTask.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                progressNotifier.finish();
            }
        });
        progressNotifier.start();
        theTask.schedule(0);
    }

    public Lookup getLookup() {
        return this.lookup;
    }
}

