/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.services;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.builders.VHDLCodeBuilder;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.InconsistencyService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.EDInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.EIInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.ESInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.FixPack;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.VHDLDataObject;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class InconsistencyServiceImpl
extends InconsistencyService {
    public void fixAndStoreInconsistencies(List<InconsistentEntity> inconsistentEntities) {
        for (InconsistentEntity ent : inconsistentEntities) {
            ArrayList<Inconsistency> checkedFixedSortedInconsistencies = new ArrayList<Inconsistency>();
            for (Inconsistency inc : ent.getInconsistencies()) {
                if (!inc.isChecked().booleanValue()) continue;
                if (inc.getFixPack() == null) {
                    inc.setFixPack(this.fixInconsistency(inc));
                }
                checkedFixedSortedInconsistencies.add(inc);
            }
            if (checkedFixedSortedInconsistencies.isEmpty()) continue;
            Collections.sort(checkedFixedSortedInconsistencies, new Comparator<Inconsistency>(){

                @Override
                public int compare(Inconsistency o1, Inconsistency o2) {
                    if (o1.equals(o2)) {
                        return 0;
                    }
                    if (o1.getFixPack().getRemovePosition() == null || o2.getFixPack().getRemovePosition() == null) {
                        return -1;
                    }
                    long o1rp = o1.getFixPack().getRemovePosition().getFrom();
                    long o2rp = o2.getFixPack().getRemovePosition().getFrom();
                    if (o1.getRelationship() == Inconsistency.InconsistencyRelationship.ED && o1rp == o2rp) {
                        return 1;
                    }
                    if (o1rp <= o2rp) {
                        return 1;
                    }
                    return -1;
                }
            });
            try {
                StringBuilder fixedCode = new StringBuilder(ent.getEntityFOB().asText());
                for (Inconsistency inc : checkedFixedSortedInconsistencies) {
                    FixPack fixPack = inc.getFixPack();
                    String begin = "";
                    if (inc.getType().equals((Object)Inconsistency.InconsistencyType.MISSING)) {
                        begin = "\n";
                    }
                    String end = "";
                    if (inc.getRelationship().equals((Object)Inconsistency.InconsistencyRelationship.EI)) {
                        end = "\n";
                    }
                    fixedCode.replace((int)fixPack.getRemovePosition().getFrom(), (int)fixPack.getRemovePosition().getTo(), begin + fixPack.getFixedCode() + end);
                }
                DataOutputStream dos = new DataOutputStream(ent.getEntityFOB().getOutputStream());
                dos.writeBytes(fixedCode.toString());
                dos.close();
                VHDLDataObject obj = (VHDLDataObject)DataObject.find((FileObject)ent.getEntityFOB());
                obj.recreateStructure();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public FixPack fixInconsistency(Inconsistency inconsistency) {
        switch (inconsistency.getRelationship()) {
            case ED: {
                return this.fixEDInconsistency((EDInconsistency)inconsistency);
            }
            case EI: {
                return this.fixEIInconsistency((EIInconsistency)inconsistency);
            }
            case ES: {
                return this.fixESInconsistency((ESInconsistency)inconsistency);
            }
        }
        return new FixPack("", null);
    }

    private FixPack fixEDInconsistency(EDInconsistency inconsistency) {
        FixPack fixPack = inconsistency.getType().equals((Object)Inconsistency.InconsistencyType.DIFFERING) ? VHDLCodeBuilder.getInstance().fixDeclaration(inconsistency.getDeclaration().getComponentName(), inconsistency.getDeclarationEntityFOB(), inconsistency.getEntityFOB()) : VHDLCodeBuilder.getInstance().addDeclaration(inconsistency.getDeclaration().getComponentName(), inconsistency.getDeclarationEntityFOB(), inconsistency.getEntityFOB());
        return fixPack;
    }

    private FixPack fixEIInconsistency(EIInconsistency inconsistency) {
        FixPack fixPack = inconsistency.getType().equals((Object)Inconsistency.InconsistencyType.DIFFERING) ? VHDLCodeBuilder.getInstance().fixInstantiation(inconsistency) : VHDLCodeBuilder.getInstance().addInstantiation(inconsistency);
        return fixPack;
    }

    private FixPack fixESInconsistency(ESInconsistency inconsistency) {
        return VHDLCodeBuilder.getInstance().addSignals(inconsistency);
    }
}

