/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.services;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.builders.VHDLCodeBuilder;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.TemplateChooserPanel;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.EntityService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.VHDLDataObject;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class EntityServiceImpl
extends EntityService
implements ClipboardOwner {
    private static final RequestProcessor RP = new RequestProcessor(EntityServiceImpl.class);
    private final String generateBT = "GENERATE";
    private final String cancelBT = "Cancel";

    public void generateTestbench(final DataObject entity) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)"Searching for templates...");
                progressNotifier.start();
                final Object[] templateFiles = EntityServiceImpl.this.getAllTemplateFiles(Entity.EntityType.TESTBENCH_TEMPLATE);
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplateChooserPanel templatePanel = TemplateChooserPanel.createTemplateChooserPanelParametrized(templateFiles, Entity.EntityType.TESTBENCH_TEMPLATE, false, VHDTConstants.PARAM_TEMPLATE_PANEL.getName());
                        DialogDescriptor dialog = new DialogDescriptor((Object)templatePanel, "Choose Template", true, new Object[]{"GENERATE", "Cancel"}, (Object)"GENERATE", 0, null, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialog);
                        if (dialog.getValue().equals("GENERATE") && templatePanel.getSelectedFile() != null) {
                            EntityServiceImpl.this.createTestbench(templatePanel.getSelectedFile(), entity, templatePanel.isFileOutput());
                        }
                        templatePanel.storeParameters();
                    }
                });
            }
        };
        RP.post(runner);
    }

    private void createTestbench(FileObject templateFile, DataObject entity, boolean toFile) {
        try {
            VHDLDataObject templateDAO = (VHDLDataObject)DataObject.find((FileObject)templateFile);
            if (!templateDAO.getStructure().getEntityType().equals((Object)Entity.EntityType.TESTBENCH_TEMPLATE)) {
                StatusDisplayer.getDefault().setStatusText("Selected VHDL file is not annotated as @TestbenchTemplate.");
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Selected VHDL file is not annotated as @TestbenchTemplate.\nPlease choose testbench template.", 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                logger.warning("Selected VHDL file is not annotated as @TestbenchTemplate. Please choose testbench template.");
            } else {
                VHDLDataObject entityDAO = (VHDLDataObject)entity;
                FileObject testbench = this.generateTestbenchFOB(entityDAO, templateDAO.getPrimaryFile(), toFile);
                if (testbench != null) {
                    VHDLProjectService service = (VHDLProjectService)entityDAO.getFromProject(VHDLProjectService.class);
                    if (service != null) {
                        service.refreshProject();
                    }
                    VHDLDataObject testbenchDAO = (VHDLDataObject)DataObject.find((FileObject)testbench);
                    OpenCookie open = (OpenCookie)testbenchDAO.getLookup().lookup(OpenCookie.class);
                    open.open();
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            logger.warning("DataObject for selected testbench template not found");
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private FileObject generateTestbenchFOB(VHDLDataObject entityDAO, FileObject templateFOB, boolean toFile) {
        String tbName = FileUtil.findFreeFileName((FileObject)entityDAO.getPrimaryFile().getParent(), (String)(entityDAO.getName() + "_tb"), (String)"vhd");
        String tbFileName = tbName + ".vhd";
        try {
            VHDLCodeBuilder builder = VHDLCodeBuilder.getInstance();
            String code = builder.createTestbench(tbName, entityDAO.getStructure(), entityDAO.getPrimaryFile(), templateFOB);
            FileObject testbench = null;
            if (toFile) {
                testbench = FileUtil.createData((FileObject)entityDAO.getPrimaryFile().getParent(), (String)tbFileName);
                DataOutputStream dos = new DataOutputStream(testbench.getOutputStream());
                dos.writeBytes(code);
                dos.close();
                String msg = "Testbench " + tbName + " successfully created.";
                StatusDisplayer.getDefault().setStatusText(msg);
                logger.info(msg);
            } else {
                StringSelection stringSelection = new StringSelection(code);
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(stringSelection, this);
                String msg = "Testbench successfully created and copied into system clipboard.";
                StatusDisplayer.getDefault().setStatusText(msg);
                logger.info(msg);
            }
            return testbench;
        }
        catch (IOException e) {
            String msg = "Error while creating testbench " + tbName + ".";
            StatusDisplayer.getDefault().setStatusText(msg);
            logger.severe(msg);
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
    }

    public void insertCode(final int position, final Document document) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ProgressHandle progressNotifier = ProgressHandleFactory.createHandle((String)"Searching for templates...");
                progressNotifier.start();
                final Object[] templateFiles = EntityServiceImpl.this.getAllTemplateFiles(Entity.EntityType.CODE_TEMPLATE);
                progressNotifier.finish();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        TemplateChooserPanel templatePanel = TemplateChooserPanel.createTemplateChooserPanelParametrized(templateFiles, Entity.EntityType.CODE_TEMPLATE, false, VHDTConstants.PARAM_TEMPLATE_PANEL.getName());
                        DialogDescriptor dialog = new DialogDescriptor((Object)templatePanel, "Choose Template", true, new Object[]{"GENERATE", "Cancel"}, (Object)"GENERATE", 0, null, null);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialog);
                        if (dialog.getValue().equals("GENERATE") && templatePanel.getSelectedFile() != null) {
                            EntityServiceImpl.this.insertNewCode(templatePanel.getSelectedFile(), document, position, templatePanel);
                        }
                        templatePanel.storeParameters();
                    }
                });
            }
        };
        RP.post(runner);
    }

    private void insertNewCode(FileObject templateFile, Document document, int position, TemplateChooserPanel tp) {
        try {
            VHDLDataObject templateDAO = (VHDLDataObject)DataObject.find((FileObject)templateFile);
            if (!templateDAO.getStructure().getEntityType().equals((Object)Entity.EntityType.CODE_TEMPLATE)) {
                StatusDisplayer.getDefault().setStatusText("Selected VHDL file is not annotated as @CodeTemplate.");
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Selected VHDL file is not annotated as @CodeTemplate.\nPlease choose code template.", 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                logger.warning("Selected VHDL file is not annotated as @CodeTemplate. Please choose code template.");
            } else {
                VHDLCodeBuilder builder = VHDLCodeBuilder.getInstance();
                String[] code = builder.createNewEntity(templateFile, tp);
                if (code != null) {
                    String tempFileName = FileUtil.findFreeFileName((FileObject)templateFile.getParent(), (String)code[0], (String)"vhd");
                    tempFileName = tempFileName + ".vhd";
                    FileObject tempFile = FileUtil.createData((FileObject)templateFile.getParent(), (String)tempFileName);
                    DataOutputStream dos = new DataOutputStream(tempFile.getOutputStream());
                    dos.writeBytes(code[1]);
                    dos.close();
                    VHDLDataObject tempFileDAO = (VHDLDataObject)DataObject.find((FileObject)tempFile);
                    String withCases = builder.addCases(tempFileDAO.getStructure(), tempFileDAO.getPrimaryFile());
                    if (withCases != null) {
                        document.insertString(position, withCases, null);
                    } else {
                        document.insertString(position, code[1], null);
                    }
                    tempFile.delete();
                    String msg = "New code segment inserted.";
                    StatusDisplayer.getDefault().setStatusText(msg);
                    logger.info(msg);
                }
            }
        }
        catch (DataObjectNotFoundException e) {
            logger.warning("DataObject for selected code template not found");
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (IOException e) {
            String msg = "Error while creating new entity from template " + templateFile.getName() + ".";
            logger.severe(msg);
            Exceptions.printStackTrace((Throwable)e);
        }
        catch (BadLocationException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public Object[] getAllTemplateFiles(Entity.EntityType templateType) {
        HashSet<FileObject> templates = new HashSet<FileObject>();
        File templatesFolder = InstalledFileLocator.getDefault().locate("TEMPLATES", null, false);
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        if (templatesFolder != null) {
            templatesFolder = FileUtil.normalizeFile((File)templatesFolder);
            try {
                files.add(FileUtil.createData((File)templatesFolder));
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        this.findAllTemplates(files.toArray(new FileObject[0]), templates, templateType);
        return templates.toArray();
    }

    private void findAllTemplates(FileObject[] files, Set<FileObject> templates, Entity.EntityType templateType) {
        for (FileObject fob : files) {
            if (fob.isFolder()) {
                this.findAllTemplates(fob.getChildren(), templates, templateType);
                continue;
            }
            if (!fob.getMIMEType().equals("text/x-vhdl")) continue;
            try {
                VHDLDataObject template;
                DataObject dao = DataObject.find((FileObject)fob);
                if (!(dao instanceof VHDLDataObject) || !(template = (VHDLDataObject)dao).getStructure().getEntityType().equals((Object)templateType)) continue;
                templates.add(fob);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

