/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.services;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.ProjectStructure;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.ConsistencyCheckerService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Declaration;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.EDInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.EIInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.ESInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Generic;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Port;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Signal;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.SignalMap;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.VHDLDataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class ConsistencyCheckerServiceImpl
extends ConsistencyCheckerService {
    public List<InconsistentEntity> checkConsistencyUp(Project project, String entityName) {
        ArrayList<Object> inconsistencies;
        ArrayList<InconsistentEntity> inconsistentEntities = new ArrayList<InconsistentEntity>();
        ProjectStructure structure = (ProjectStructure)project.getLookup().lookup(ProjectStructure.class);
        if (structure == null) {
            logger.severe(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_SEVERE_ProjectStructureNotFound"));
            return inconsistentEntities;
        }
        String entityKey = entityName.toLowerCase();
        if (!structure.getEntities().containsKey(entityKey)) {
            if (structure.getTestbenches().containsKey(entityKey) || structure.getPackages().containsKey(entityKey)) {
                StatusDisplayer.getDefault().setStatusText("Testbench or Package - nothing to check.");
                logger.info(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_INFO_TestbenchOrPackage"));
            } else {
                StatusDisplayer.getDefault().setStatusText("Error while checking consistency.");
                logger.severe(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_SEVERE_ProjectStructureNotFound"));
            }
            return inconsistentEntities;
        }
        VHDLDataObject entityDAO = structure.getEntities().get(entityKey);
        for (VHDLDataObject object : structure.getTestbenches().values()) {
            inconsistencies = new ArrayList<Inconsistency>();
            this.findEntityInconsistencies(object, entityDAO, inconsistencies);
            if (inconsistencies.isEmpty()) continue;
            inconsistentEntities.add(new InconsistentEntity(object.getStructure(), object.getPrimaryFile(), inconsistencies));
        }
        for (VHDLDataObject object : structure.getEntities().values()) {
            inconsistencies = new ArrayList();
            this.findEntityInconsistencies(object, entityDAO, inconsistencies);
            if (inconsistencies.isEmpty()) continue;
            inconsistentEntities.add(new InconsistentEntity(object.getStructure(), object.getPrimaryFile(), inconsistencies));
        }
        return inconsistentEntities;
    }

    public List<InconsistentEntity> checkConsistencyDown(Project project, String entityName) {
        ArrayList<InconsistentEntity> inconsistentEntities = new ArrayList<InconsistentEntity>();
        ProjectStructure structure = (ProjectStructure)project.getLookup().lookup(ProjectStructure.class);
        if (structure == null) {
            logger.severe(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_SEVERE_ProjectStructureNotFound"));
            return inconsistentEntities;
        }
        String entityKey = entityName.toLowerCase();
        if (!structure.getEntities().containsKey(entityKey) && !structure.getTestbenches().containsKey(entityKey)) {
            if (structure.getPackages().containsKey(entityKey)) {
                StatusDisplayer.getDefault().setStatusText("Package - nothing to check.");
                logger.info(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_INFO_Package"));
            } else {
                StatusDisplayer.getDefault().setStatusText("Error while checking consistency.");
                logger.severe(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_SEVERE_ProjectStructureNotFound"));
            }
            return inconsistentEntities;
        }
        VHDLDataObject entityDAO = structure.getEntities().get(entityKey);
        if (entityDAO == null) {
            entityDAO = structure.getTestbenches().get(entityKey);
        }
        this.findInconsistenciesIn(entityDAO, structure.getEntities(), inconsistentEntities, new HashSet<String>());
        return inconsistentEntities;
    }

    public List<InconsistentEntity> checkConsistency(Project project) {
        ArrayList<InconsistentEntity> inconsistentEntities = new ArrayList<InconsistentEntity>();
        ProjectStructure structure = (ProjectStructure)project.getLookup().lookup(ProjectStructure.class);
        if (structure == null) {
            StatusDisplayer.getDefault().setStatusText("Error while checking consistency.");
            logger.severe(NbBundle.getMessage(ConsistencyCheckerServiceImpl.class, (String)"LOG_SEVERE_ProjectStructureNotFound"));
            return inconsistentEntities;
        }
        for (VHDLDataObject object : structure.getTestbenches().values()) {
            this.findInconsistenciesIn(object, structure.getEntities(), inconsistentEntities, null);
        }
        for (VHDLDataObject object : structure.getEntities().values()) {
            this.findInconsistenciesIn(object, structure.getEntities(), inconsistentEntities, null);
        }
        return inconsistentEntities;
    }

    private void findInconsistenciesIn(VHDLDataObject entityInDAO, Map<String, VHDLDataObject> projectEntities, List<InconsistentEntity> inconsistentEntities, Set<String> resolved) {
        Entity entityIn = entityInDAO.getStructure();
        String entityInName = entityIn.getEntityName().toLowerCase();
        if (resolved != null) {
            resolved.add(entityInName);
        }
        HashSet entitiesIn = new HashSet(entityIn.getDeclarations().keySet());
        for (Instantiation inst : entityIn.getInstantiations().values()) {
            entitiesIn.add(inst.getComponentName().toLowerCase());
        }
        ArrayList<Inconsistency> inconsistencies = new ArrayList<Inconsistency>();
        for (String name : entitiesIn) {
            VHDLDataObject obj = projectEntities.get(name);
            if (obj == null) continue;
            this.findEntityInconsistencies(entityInDAO, obj, inconsistencies);
            if (resolved == null || resolved.contains(name)) continue;
            this.findInconsistenciesIn(obj, projectEntities, inconsistentEntities, resolved);
        }
        if (!inconsistencies.isEmpty()) {
            inconsistentEntities.add(new InconsistentEntity(entityIn, entityInDAO.getPrimaryFile(), inconsistencies));
        }
    }

    private void findEntityInconsistencies(VHDLDataObject entityInDAO, VHDLDataObject entityDAO, List<Inconsistency> inconsistencies) {
        Entity entityIn = entityInDAO.getStructure();
        Entity entity = entityDAO.getStructure();
        String entityName = entity.getEntityName();
        String entityKey = entityName.toLowerCase();
        boolean decFound = false;
        boolean decInconsistent = false;
        boolean instFound = false;
        boolean instInconsistent = false;
        Declaration dec = (Declaration)entityIn.getDeclarations().get(entityKey);
        if (dec != null) {
            decInconsistent = this.checkDeclarationConsistency(dec, entityDAO, entityInDAO, inconsistencies);
            decFound = true;
        }
        for (Instantiation inst : entityIn.getInstantiations().values()) {
            if (!inst.getComponentName().equalsIgnoreCase(entityKey)) continue;
            instInconsistent = this.checkInstantiationConsistency(inst, entityDAO, entityInDAO, inconsistencies);
            instFound = true;
        }
        if (!decFound && instFound) {
            inconsistencies.add((Inconsistency)new EDInconsistency(Inconsistency.InconsistencyType.MISSING, entityIn, entityInDAO.getPrimaryFile(), new Declaration(entityName, new HashMap(), new HashMap()), entityDAO.getPrimaryFile()));
        }
        if (decFound && !instFound) {
            inconsistencies.add((Inconsistency)new EIInconsistency(Inconsistency.InconsistencyType.MISSING, entityIn, entityInDAO.getPrimaryFile(), this.createInstantiation(entity), entityDAO.getPrimaryFile()));
        }
        if (decFound || instFound) {
            this.checkSignalsConsistency(entityDAO, entityInDAO, inconsistencies, decInconsistent, instInconsistent);
        }
    }

    private boolean checkDeclarationConsistency(Declaration declaration, VHDLDataObject originalEntityDAO, VHDLDataObject entityInDAO, List<Inconsistency> inconsistencies) {
        Entity originalEntity = originalEntityDAO.getStructure();
        boolean inconsistencyFound = false;
        HashSet originalGenerics = new HashSet(originalEntity.getGenerics().keySet());
        for (Signal signal : declaration.getGenerics().values()) {
            String signalName = signal.getName().toLowerCase();
            if (originalGenerics.remove(signalName) && signal.equalsType((Signal)originalEntity.getGenerics().get(signalName))) continue;
            inconsistencyFound = true;
            break;
        }
        if (inconsistencyFound || !originalGenerics.isEmpty()) {
            inconsistencies.add((Inconsistency)new EDInconsistency(Inconsistency.InconsistencyType.DIFFERING, entityInDAO.getStructure(), entityInDAO.getPrimaryFile(), declaration, originalEntityDAO.getPrimaryFile()));
            return true;
        }
        HashSet originalPorts = new HashSet(originalEntity.getPorts().keySet());
        for (Port signal : declaration.getPorts().values()) {
            String signalName = signal.getName().toLowerCase();
            if (originalPorts.remove(signalName) && signal.equalsTypeAndMode((Port)originalEntity.getPorts().get(signalName))) continue;
            inconsistencyFound = true;
            break;
        }
        if (inconsistencyFound || !originalPorts.isEmpty()) {
            inconsistencies.add((Inconsistency)new EDInconsistency(Inconsistency.InconsistencyType.DIFFERING, entityInDAO.getStructure(), entityInDAO.getPrimaryFile(), declaration, originalEntityDAO.getPrimaryFile()));
            return true;
        }
        return false;
    }

    private boolean checkInstantiationConsistency(Instantiation instantiation, VHDLDataObject originalEntityDAO, VHDLDataObject entityInDAO, List<Inconsistency> inconsistencies) {
        Entity originalEntity = originalEntityDAO.getStructure();
        ArrayList genericsToAdd = new ArrayList(originalEntity.getGenerics().keySet());
        ArrayList<String> genericsToRemove = new ArrayList<String>();
        for (String signal : instantiation.getGenericMap().keySet()) {
            if (genericsToAdd.remove(signal)) continue;
            genericsToRemove.add(signal);
        }
        ArrayList portsToAdd = new ArrayList(originalEntity.getPorts().keySet());
        ArrayList<String> portsToRemove = new ArrayList<String>();
        for (String signal : instantiation.getPortMap().keySet()) {
            if (portsToAdd.remove(signal)) continue;
            portsToRemove.add(signal);
        }
        if (!(genericsToAdd.isEmpty() && genericsToRemove.isEmpty() && portsToAdd.isEmpty() && portsToRemove.isEmpty())) {
            ArrayList<SignalMap> gensMapToAdd = new ArrayList<SignalMap>();
            ArrayList<SignalMap> portsMapToAdd = new ArrayList<SignalMap>();
            for (String key : genericsToAdd) {
                String genName = ((Generic)originalEntity.getGenerics().get(key)).getName();
                gensMapToAdd.add(new SignalMap(genName, genName));
            }
            for (String key : portsToAdd) {
                String portName = ((Port)originalEntity.getPorts().get(key)).getName();
                portsMapToAdd.add(new SignalMap(portName, portName));
            }
            inconsistencies.add((Inconsistency)new EIInconsistency(Inconsistency.InconsistencyType.DIFFERING, entityInDAO.getStructure(), entityInDAO.getPrimaryFile(), instantiation, originalEntityDAO.getPrimaryFile(), gensMapToAdd, genericsToRemove, portsMapToAdd, portsToRemove));
            return true;
        }
        return false;
    }

    private void checkSignalsConsistency(VHDLDataObject originalEntityDAO, VHDLDataObject entityInDAO, List<Inconsistency> inconsistencies, boolean decInconsistent, boolean instInconsistent) {
        Entity originalEntity = originalEntityDAO.getStructure();
        Entity entityIn = entityInDAO.getStructure();
        ArrayList<Signal> signalsToAdd = new ArrayList<Signal>();
        for (Signal signal : originalEntity.getPorts().values()) {
            String signalName = signal.getName().toLowerCase();
            if (entityIn.getSignals().containsKey(signalName) && ((Signal)entityIn.getSignals().get(signalName)).equalsType(signal)) continue;
            signalsToAdd.add(signal);
        }
        if (!signalsToAdd.isEmpty()) {
            inconsistencies.add((Inconsistency)new ESInconsistency(entityIn, entityInDAO.getPrimaryFile(), originalEntity, originalEntityDAO.getPrimaryFile(), signalsToAdd, decInconsistent, instInconsistent));
        }
    }

    private Instantiation createInstantiation(Entity entity) {
        String name = entity.getEntityName() + "_INST";
        HashMap<String, SignalMap> genericMap = new HashMap<String, SignalMap>();
        HashMap<String, SignalMap> portMap = new HashMap<String, SignalMap>();
        for (Generic gen : entity.getGenerics().values()) {
            genericMap.put(gen.getName().toLowerCase(), new SignalMap(gen.getName(), gen.getName()));
        }
        for (Port port : entity.getPorts().values()) {
            portMap.put(port.getName().toLowerCase(), new SignalMap(port.getName(), port.getName()));
        }
        return new Instantiation(name, entity.getEntityName(), genericMap, portMap);
    }
}

