/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.factories;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.ProjectRefreshEvent;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.ProjectStructure;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.VHDLDataNode;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.VHDLEntityShadow;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.factories.VHDLEntityChildFactory;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.VHDLDataObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class VHDLProjectChildFactory
extends ChildFactory<VHDLEntityShadow>
implements LookupListener {
    private Lookup.Result<ProjectRefreshEvent> lookupResult;
    private final Project project;
    private final ProjectStructure projectStructure;
    private Map<String, VHDLEntityShadow> displayed;
    private boolean firstCall;

    public VHDLProjectChildFactory(Project project) {
        this.project = project;
        this.projectStructure = (ProjectStructure)project.getLookup().lookup(ProjectStructure.class);
        this.displayed = new TreeMap<String, VHDLEntityShadow>();
        this.firstCall = true;
        this.init();
    }

    private void init() {
        VHDLProjectService service = (VHDLProjectService)this.project.getLookup().lookup(VHDLProjectService.class);
        if (service != null) {
            this.lookupResult = service.getLookup().lookupResult(ProjectRefreshEvent.class);
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
        }
    }

    protected boolean createKeys(List<VHDLEntityShadow> toPopulate) {
        VHDLProjectService service = (VHDLProjectService)this.project.getLookup().lookup(VHDLProjectService.class);
        if (this.firstCall && service != null) {
            service.refreshProject();
            this.firstCall = false;
        }
        TreeMap<String, VHDLEntityShadow> toDisplay = new TreeMap<String, VHDLEntityShadow>();
        TreeMap<String, VHDLEntityShadow> helperTree = new TreeMap<String, VHDLEntityShadow>();
        for (VHDLDataObject object : this.projectStructure.getPackages().values()) {
            this.addEntity(object, toDisplay, helperTree);
        }
        toPopulate.addAll(helperTree.values());
        helperTree.clear();
        for (VHDLDataObject object : this.projectStructure.getTestbenches().values()) {
            this.addEntity(object, toDisplay, helperTree);
        }
        toPopulate.addAll(helperTree.values());
        helperTree.clear();
        for (VHDLDataObject object : this.processVHDLs()) {
            this.addEntity(object, toDisplay, helperTree);
        }
        toPopulate.addAll(helperTree.values());
        this.displayed = toDisplay;
        return true;
    }

    private void addEntity(VHDLDataObject object, Map<String, VHDLEntityShadow> toDisplay, Map<String, VHDLEntityShadow> helperTree) {
        VHDLEntityShadow shadow;
        String name = object.getStructure().getEntityName().toLowerCase();
        if (!this.displayed.containsKey(name)) {
            shadow = new VHDLEntityShadow(object);
        } else {
            VHDLEntityShadow oldShadow = this.displayed.get(name);
            shadow = object.hasChildren() != oldShadow.hasChildren() ? new VHDLEntityShadow(object) : oldShadow;
        }
        toDisplay.put(name, shadow);
        helperTree.put(name, shadow);
    }

    protected Node createNodeForKey(VHDLEntityShadow key) {
        if (key.hasChildren()) {
            return new VHDLDataNode(key.getObject(), Children.create((ChildFactory)new VHDLEntityChildFactory(key.getObject(), this.project), (boolean)true), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)this.project), key.getObject().getLookup()}));
        }
        return new VHDLDataNode(key.getObject(), Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)this.project), key.getObject().getLookup()}));
    }

    private Collection<VHDLDataObject> processVHDLs() {
        HashMap<String, VHDLDataObject> tops = new HashMap<String, VHDLDataObject>(this.projectStructure.getEntities());
        ArrayList<VHDLDataObject> objects = new ArrayList<VHDLDataObject>();
        objects.addAll(this.projectStructure.getTestbenches().values());
        objects.addAll(this.projectStructure.getEntities().values());
        HashSet<String> toRemove = new HashSet<String>();
        for (VHDLDataObject obj : objects) {
            Entity entity = obj.getStructure();
            for (Instantiation inst : entity.getInstantiations().values()) {
                if (entity.getEntityName().equalsIgnoreCase(inst.getComponentName())) continue;
                toRemove.add(inst.getComponentName().toLowerCase());
            }
        }
        for (String component : toRemove) {
            tops.remove(component);
        }
        return tops.values();
    }

    public void resultChanged(LookupEvent le) {
        this.refresh(true);
    }
}

