/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.factories;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.ProjectRefreshEvent;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.ProjectStructure;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.VHDLEntityShadow;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.VHDLInstantiationDataNode;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.VHDLInstantiationNoEntityNode;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.VHDLDataObject;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.api.project.Project;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class VHDLEntityChildFactory
extends ChildFactory<VHDLEntityShadow>
implements LookupListener {
    private Lookup.Result<ProjectRefreshEvent> lookupResult;
    private final VHDLDataObject object;
    private final Project project;
    private final Map<String, VHDLDataObject> allEntities;
    private Map<String, VHDLEntityShadow> displayed;

    public VHDLEntityChildFactory(VHDLDataObject object, Project project) {
        this.object = object;
        this.project = project;
        this.allEntities = ((ProjectStructure)project.getLookup().lookup(ProjectStructure.class)).getEntities();
        this.displayed = new TreeMap<String, VHDLEntityShadow>();
        this.init();
    }

    private void init() {
        VHDLProjectService service = (VHDLProjectService)this.project.getLookup().lookup(VHDLProjectService.class);
        this.lookupResult = service.getLookup().lookupResult(ProjectRefreshEvent.class);
        this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), this.lookupResult));
    }

    protected boolean createKeys(List<VHDLEntityShadow> toPopulate) {
        TreeMap<String, VHDLEntityShadow> toDisplay = new TreeMap<String, VHDLEntityShadow>();
        if (this.object != null && this.object.isValid()) {
            Entity entity = this.object.getStructure();
            for (Instantiation inst : entity.getInstantiations().values()) {
                String componentName = inst.getComponentName();
                this.addEntity(inst.getInstantiationName(), componentName, this.allEntities.get(componentName.toLowerCase()), toDisplay);
            }
        }
        toPopulate.addAll(toDisplay.values());
        this.displayed = toDisplay;
        return true;
    }

    private void addEntity(String instName, String componentName, VHDLDataObject object, Map<String, VHDLEntityShadow> toDisplay) {
        VHDLEntityShadow oldShadow;
        String nameId = instName.toLowerCase();
        VHDLEntityShadow shadow = !this.displayed.containsKey(nameId) || !componentName.equalsIgnoreCase(this.displayed.get(nameId).getComponentName()) ? (object != null ? new VHDLEntityShadow(instName, componentName, object) : new VHDLEntityShadow(instName, componentName)) : ((oldShadow = this.displayed.get(nameId)).getObject() == null && object != null ? new VHDLEntityShadow(instName, componentName, object) : (oldShadow.getObject() != null && object == null ? new VHDLEntityShadow(instName, componentName) : (object != null && object.hasChildren() != oldShadow.hasChildren() ? new VHDLEntityShadow(instName, componentName, object) : oldShadow)));
        toDisplay.put(nameId, shadow);
    }

    protected Node createNodeForKey(VHDLEntityShadow key) {
        if (key.getObject() == null) {
            return new VHDLInstantiationNoEntityNode(key.getInstantiationName(), key.getComponentName(), Lookups.singleton((Object)this.project));
        }
        if (key.hasChildren()) {
            return new VHDLInstantiationDataNode(key.getObject(), Children.create((ChildFactory)new VHDLEntityChildFactory(key.getObject(), this.project), (boolean)true), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)this.project), key.getObject().getLookup()}), key.getInstantiationName());
        }
        return new VHDLInstantiationDataNode(key.getObject(), Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)this.project), key.getObject().getLookup()}), key.getInstantiationName());
    }

    public void resultChanged(LookupEvent le) {
        this.refresh(true);
    }
}

