/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.builders;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.uicomponents.TemplateChooserPanel;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.EIInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.ESInconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.FixPack;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Named;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Position;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Signal;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.SignalMap;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Type;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParser;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class VHDLCodeBuilder {
    private static final Logger logger = Logger.getLogger(VHDLCodeBuilder.class.getName());
    private static final String universalGap = "    ";
    private static VHDLCodeBuilder codeBuilder;

    private VHDLCodeBuilder() {
    }

    public static synchronized VHDLCodeBuilder getInstance() {
        if (codeBuilder == null) {
            codeBuilder = new VHDLCodeBuilder();
        }
        return codeBuilder;
    }

    public FixPack addDeclaration(String declarationName, FileObject originalEntity, FileObject entityIn) {
        Position where;
        Position what;
        StringBuilder whatEntity = new StringBuilder();
        try {
            whatEntity.append(originalEntity.asText());
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)originalEntity));
            what = parser.getEntityPosition();
            parser.closeStream();
            parser = new VHDLParser(FileUtil.toFile((FileObject)entityIn));
            where = parser.getArchitecturePosition();
            where.setTo(where.getFrom());
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return new FixPack("", null);
        }
        catch (IOException e) {
            this.parserIOError(e);
            return new FixPack("", null);
        }
        String declaration = this.applyGap(where.getGap() + "component " + whatEntity.substring((int)what.getFrom(), (int)what.getTo()) + " component;", where.getGap());
        return new FixPack(declaration, where);
    }

    public FixPack fixDeclaration(String declarationName, FileObject originalEntity, FileObject entityIn) {
        Position where;
        Position what;
        StringBuilder whatEntity = new StringBuilder();
        try {
            whatEntity.append(originalEntity.asText());
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)originalEntity));
            what = parser.getEntityPosition();
            parser.closeStream();
            parser = new VHDLParser(FileUtil.toFile((FileObject)entityIn));
            where = parser.getDeclarationPosition(declarationName);
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return new FixPack("", null);
        }
        catch (IOException e) {
            this.parserIOError(e);
            return new FixPack("", null);
        }
        String declaration = this.applyGap(where.getGap() + "component " + whatEntity.substring((int)what.getFrom(), (int)what.getTo()) + " component;", where.getGap());
        return new FixPack(declaration, where);
    }

    public FixPack addSignals(ESInconsistency inc) {
        Position where;
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)inc.getEntityFOB()));
            where = parser.getDeclarationEndPosition(inc.getComponent().getEntityName());
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return new FixPack("", null);
        }
        catch (IOException e) {
            this.parserIOError(e);
            return new FixPack("", null);
        }
        StringBuilder signals = new StringBuilder();
        int longestLength = this.longestLength(inc.getSignalsToAdd());
        for (Signal signal : inc.getSignalsToAdd()) {
            signals.append(signal.toPrintableString(longestLength));
            signals.append("\n");
        }
        String sigs = "";
        if (signals.length() > 0) {
            signals.deleteCharAt(signals.length() - 1);
            sigs = this.applyGap(where.getGap() + signals.toString(), where.getGap());
        }
        return new FixPack(sigs, where);
    }

    public FixPack addInstantiation(EIInconsistency inc) {
        Position where;
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)inc.getEntityFOB()));
            where = parser.getArchitecturePosition();
            where.setFrom(where.getTo());
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return new FixPack("", null);
        }
        catch (IOException e) {
            this.parserIOError(e);
            return new FixPack("", null);
        }
        where.setGap(universalGap);
        boolean genericsInRow = true;
        boolean portsInRow = false;
        if (inc.isGenericsInRow() == null) {
            inc.setGenericsInRow(Boolean.valueOf(genericsInRow));
        } else {
            genericsInRow = inc.isGenericsInRow();
        }
        if (inc.isPortsInRow() == null) {
            inc.setPortsInRow(Boolean.valueOf(portsInRow));
        } else {
            portsInRow = inc.isPortsInRow();
        }
        int longestLength = this.longestLength(inc.getInstantiation().getGenericMap().values(), inc.getInstantiation().getPortMap().values());
        String inst = this.applyGap(where.getGap() + inc.getInstantiation().toPrintableString(longestLength, genericsInRow, portsInRow), where.getGap());
        return new FixPack(inst, where);
    }

    public FixPack fixInstantiation(EIInconsistency inc) {
        Position where;
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)inc.getEntityFOB()));
            where = parser.getInstantiationPosition(inc.getInstantiation().getInstantiationName(), inc.getInstantiation().getComponentName());
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return new FixPack("", null);
        }
        catch (IOException e) {
            this.parserIOError(e);
            return new FixPack("", null);
        }
        LinkedHashMap<String, SignalMap> fixedGens = new LinkedHashMap<String, SignalMap>(inc.getInstantiation().getGenericMap());
        LinkedHashMap<String, SignalMap> fixedPorts = new LinkedHashMap<String, SignalMap>(inc.getInstantiation().getPortMap());
        for (String key : inc.getGenericsToRemove()) {
            fixedGens.remove(key);
        }
        for (String key : inc.getPortsToRemove()) {
            fixedPorts.remove(key);
        }
        for (SignalMap map : inc.getGenericsToAdd()) {
            fixedGens.put(map.getName().toLowerCase(), map);
        }
        for (SignalMap map : inc.getPortsToAdd()) {
            fixedPorts.put(map.getName().toLowerCase(), map);
        }
        Instantiation fixedInst = new Instantiation(inc.getInstantiation().getInstantiationName(), inc.getInstantiation().getComponentName(), fixedGens, fixedPorts);
        boolean genericsInRow = true;
        boolean portsInRow = false;
        if (inc.isGenericsInRow() == null) {
            inc.setGenericsInRow(Boolean.valueOf(genericsInRow));
        } else {
            genericsInRow = inc.isGenericsInRow();
        }
        if (inc.isPortsInRow() == null) {
            inc.setPortsInRow(Boolean.valueOf(portsInRow));
        } else {
            portsInRow = inc.isPortsInRow();
        }
        int longestLength = this.longestLength(inc.getInstantiation().getGenericMap().values(), inc.getInstantiation().getPortMap().values());
        String inst = this.applyGap(where.getGap() + fixedInst.toPrintableString(longestLength, genericsInRow, portsInRow), where.getGap());
        return new FixPack(inst, where);
    }

    public String createTestbench(String tbName, Entity entity, FileObject entityFOB, FileObject testbench) {
        StringBuilder code;
        ArrayList positions = new ArrayList();
        try {
            code = new StringBuilder(testbench.asText());
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)testbench));
            parser.getMarkPositions(positions);
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return "";
        }
        catch (IOException e) {
            this.parserIOError(e);
            return "";
        }
        Collections.reverse(positions);
        for (Position pos : positions) {
            if (pos.getMark().startsWith("@")) {
                this.removeGlobal(pos, code);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_ENTITY_NAME.getName())) {
                this.insertName(entity.getEntityName(), pos, code);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_TB_NAME.getName())) {
                this.insertName(tbName, pos, code);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_COMPONENT.getName())) {
                this.insertComponent(entityFOB, pos, code);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_SIGNALS.getName())) {
                this.insertSignals(entity, pos, code);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_INSTANCE.getName())) {
                this.insertInstance(entity, pos, code);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_PORT_MAP.getName())) {
                this.insertPortMap(entity, pos, code, false);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_PORT_MAP_INLINE.getName())) {
                this.insertPortMap(entity, pos, code, true);
                continue;
            }
            if (pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_GENERIC_MAP.getName())) {
                this.insertGenericMap(entity, pos, code, false);
                continue;
            }
            if (!pos.getMark().equalsIgnoreCase(VHDTConstants.MARK_GENERIC_MAP_INLINE.getName())) continue;
            this.insertGenericMap(entity, pos, code, true);
        }
        return this.insertNamesIntoComments(entity.getEntityName(), tbName, code);
    }

    private void removeGlobal(Position pos, StringBuilder code) {
        code.delete((int)pos.getFrom(), (int)pos.getTo());
    }

    private void insertName(String name, Position pos, StringBuilder code) {
        code.replace((int)pos.getFrom(), (int)pos.getTo(), name);
    }

    private void insertComponent(FileObject entityFOB, Position pos, StringBuilder code) {
        Position what;
        StringBuilder whatEntity = new StringBuilder();
        try {
            whatEntity.append(entityFOB.asText());
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)entityFOB));
            what = parser.getEntityPosition();
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return;
        }
        catch (IOException e) {
            this.parserIOError(e);
            return;
        }
        String component = this.applyGap("component " + whatEntity.substring((int)what.getFrom(), (int)what.getTo()) + " component;", pos.getGap());
        code.replace((int)pos.getFrom(), (int)pos.getTo(), component);
    }

    private void insertSignals(Entity entity, Position pos, StringBuilder code) {
        StringBuilder signals = new StringBuilder();
        int longestLength = this.longestLength(entity.getPorts().values());
        for (Signal signal : entity.getPorts().values()) {
            signals.append(signal.toPrintableString(longestLength));
            signals.append("\n");
        }
        String sigs = "";
        if (signals.length() > 0) {
            signals.deleteCharAt(signals.length() - 1);
            sigs = this.applyGap(signals.toString(), pos.getGap());
        }
        code.replace((int)pos.getFrom(), (int)pos.getTo(), sigs);
    }

    private void insertInstance(Entity entity, Position pos, StringBuilder code) {
        boolean genericsInRow = true;
        boolean portsInRow = false;
        Instantiation inst = this.buildInstantiation("i_" + entity.getEntityName(), entity);
        int longestLength = this.longestLength(inst.getGenericMap().values(), inst.getPortMap().values());
        String instantiation = this.applyGap(inst.toPrintableString(longestLength, genericsInRow, portsInRow), pos.getGap());
        code.replace((int)pos.getFrom(), (int)pos.getTo(), instantiation);
    }

    private void insertGenericMap(Entity entity, Position pos, StringBuilder code, boolean inline) {
        Instantiation inst = this.buildInstantiation("i_" + entity.getEntityName(), entity);
        int longestLength = this.longestLength(inst.getGenericMap().values());
        String genericMap = this.applyGap("generic map(" + Instantiation.printableMap((Map)inst.getGenericMap(), (int)longestLength, (boolean)inline) + ")", pos.getGap());
        code.replace((int)pos.getFrom(), (int)pos.getTo(), genericMap);
    }

    private void insertPortMap(Entity entity, Position pos, StringBuilder code, boolean inline) {
        Instantiation inst = this.buildInstantiation("i_" + entity.getEntityName(), entity);
        int longestLength = this.longestLength(inst.getPortMap().values());
        String portMap = this.applyGap("port map(" + Instantiation.printableMap((Map)inst.getPortMap(), (int)longestLength, (boolean)inline) + ")", pos.getGap());
        code.replace((int)pos.getFrom(), (int)pos.getTo(), portMap);
    }

    private Instantiation buildInstantiation(String instName, Entity entity) {
        LinkedHashMap<String, SignalMap> genMap = new LinkedHashMap<String, SignalMap>();
        LinkedHashMap<String, SignalMap> portMap = new LinkedHashMap<String, SignalMap>();
        for (Signal sig : entity.getGenerics().values()) {
            genMap.put(sig.getName().toLowerCase(), new SignalMap(sig.getName(), sig.getName()));
        }
        for (Signal sig : entity.getPorts().values()) {
            portMap.put(sig.getName().toLowerCase(), new SignalMap(sig.getName(), sig.getName()));
        }
        return new Instantiation(instName, entity.getEntityName(), genMap, portMap);
    }

    private String insertNamesIntoComments(String entityName, String tbName, StringBuilder codeSB) {
        String code = codeSB.toString();
        code = code.replaceAll(Matcher.quoteReplacement(VHDTConstants.MARK_ENTITY_NAME.getName()), entityName);
        code = code.replaceAll(Matcher.quoteReplacement(VHDTConstants.MARK_TB_NAME.getName()), tbName);
        return code;
    }

    public String[] createNewEntity(FileObject template, TemplateChooserPanel tp) {
        StringBuilder code;
        String[] retVal = new String[]{template.getName(), ""};
        try {
            code = new StringBuilder(template.asText());
        }
        catch (IOException e) {
            this.stringBuilderError(e);
            return retVal;
        }
        ArrayList annotPositions = new ArrayList();
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)template));
            parser.getAnnotationPositions(annotPositions);
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return null;
        }
        catch (IOException e) {
            this.parserIOError(e);
            return null;
        }
        Collections.reverse(annotPositions);
        for (Position pos : annotPositions) {
            this.removeGlobal(pos, code);
        }
        String newEntity = code.toString();
        for (Map.Entry<String, String> ent : tp.getDollarMarks().entrySet()) {
            newEntity = newEntity.replaceAll("(?i)" + Matcher.quoteReplacement(ent.getKey()), tp.getNewName(ent.getValue()));
        }
        if (!tp.getEntityName().isEmpty()) {
            retVal[0] = tp.getEntityName();
        }
        retVal[1] = newEntity;
        return retVal;
    }

    public String addCases(Entity entity, FileObject file) {
        StringBuilder code;
        try {
            code = new StringBuilder(file.asText());
        }
        catch (IOException e) {
            this.stringBuilderError(e);
            return null;
        }
        entity.getTypes().clear();
        entity.getSignals().clear();
        ArrayList casePositions = new ArrayList();
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)file));
            parser.getCaseMarkPositions(casePositions);
            parser.getTypesAndSignals(entity.getTypes(), entity.getSignals());
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            this.parserError(e);
            return null;
        }
        catch (IOException e) {
            this.parserIOError(e);
            return null;
        }
        Collections.reverse(casePositions);
        for (Position pos : casePositions) {
            this.insertCase(pos, entity, code);
        }
        return code.toString();
    }

    private void insertCase(Position pos, Entity entity, StringBuilder code) {
        String mark = pos.getMark();
        if (mark.indexOf(61) == -1 || mark.indexOf(123) == -1 || mark.indexOf(125) == -1 || mark.indexOf(61) > mark.indexOf(123) || mark.indexOf(123) > mark.indexOf(125)) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_BadCaseMarkFormat");
            logger.log(Level.WARNING, msg);
            return;
        }
        String caseType = mark.substring(1, mark.indexOf(61));
        mark = mark.substring(mark.indexOf(61) + 1);
        if (caseType.equalsIgnoreCase(VHDTConstants.MARK_CASE.getName())) {
            String caseString = this.createCase(mark, entity, pos);
            code.replace((int)pos.getFrom(), (int)pos.getTo(), caseString);
        } else if (caseType.equalsIgnoreCase(VHDTConstants.MARK_CASE_BODY.getName())) {
            String caseBodyString = this.createCaseBody(mark, entity, pos);
            code.replace((int)pos.getFrom(), (int)pos.getTo(), caseBodyString);
        } else {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_BadCaseMarkFormat");
            logger.log(Level.WARNING, msg);
        }
    }

    private String createCase(String mark, Entity entity, Position pos) {
        StringBuilder caseString = new StringBuilder();
        String signalName = mark.substring(0, mark.indexOf(123));
        if (signalName.isEmpty()) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_BadCaseMarkFormat");
            logger.log(Level.WARNING, msg);
            return caseString.toString();
        }
        caseString.append("case ");
        caseString.append(signalName);
        caseString.append(" is\n");
        Signal sig = (Signal)entity.getSignals().get(signalName.toLowerCase());
        if (sig == null) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_UnknownSignal");
            logger.log(Level.WARNING, msg);
            caseString.append(pos.getGap());
            return caseString.append("end case;").toString();
        }
        Type type = (Type)entity.getTypes().get(sig.getType().toLowerCase());
        if (type == null || type.isArray()) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_UnknownType");
            logger.log(Level.WARNING, msg);
            caseString.append(pos.getGap());
            return caseString.append("end case;").toString();
        }
        String value = type.getValue();
        if (value.isEmpty()) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_BadCaseMarkFormat");
            logger.log(Level.WARNING, msg);
            caseString.append(pos.getGap());
            return caseString.append("end case;").toString();
        }
        value = value.substring(1, value.length() - 1);
        String[] values = value.split(",");
        ArrayList<String> vals = new ArrayList<String>(Arrays.asList(values));
        vals.add("others");
        mark = mark.substring(mark.indexOf(123) + 1, mark.indexOf(125));
        for (String val : vals) {
            val = val.trim();
            caseString.append(pos.getGap());
            caseString.append("    when ");
            caseString.append(val);
            caseString.append(" => ");
            caseString.append(mark);
            caseString.append("\n");
        }
        caseString.append(pos.getGap());
        caseString.append("end case;");
        return caseString.toString();
    }

    private String createCaseBody(String mark, Entity entity, Position pos) {
        StringBuilder caseString = new StringBuilder();
        String typeName = mark.substring(0, mark.indexOf(123));
        if (typeName.isEmpty()) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_BadCaseMarkFormat");
            logger.log(Level.WARNING, msg);
            return caseString.toString();
        }
        Type type = (Type)entity.getTypes().get(typeName.toLowerCase());
        if (type == null || type.isArray()) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_UnknownType");
            logger.log(Level.WARNING, msg);
            caseString.append(pos.getGap());
            return caseString.toString();
        }
        String value = type.getValue();
        if (value.isEmpty()) {
            String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_WARNING_BadCaseMarkFormat");
            logger.log(Level.WARNING, msg);
            caseString.append(pos.getGap());
            return caseString.toString();
        }
        value = value.substring(1, value.length() - 1);
        String[] values = value.split(",");
        ArrayList<String> vals = new ArrayList<String>(Arrays.asList(values));
        vals.add("others");
        mark = mark.substring(mark.indexOf(123) + 1, mark.indexOf(125));
        boolean firstBranch = true;
        for (String val : vals) {
            val = val.trim();
            if (!firstBranch) {
                caseString.append(pos.getGap());
            }
            caseString.append("when ");
            caseString.append(val);
            caseString.append(" => ");
            caseString.append(mark);
            caseString.append("\n");
            firstBranch = false;
        }
        caseString.deleteCharAt(caseString.length() - 1);
        return caseString.toString();
    }

    private String applyGap(String code, String gap) {
        return code.replace("\n", "\n" + gap);
    }

    private int longestLength(Collection<? extends Named> signals) {
        int longest = 0;
        for (Named named : signals) {
            if (named.getName().length() <= longest) continue;
            longest = named.getName().length();
        }
        return longest;
    }

    private int longestLength(Collection<? extends Named> generics, Collection<? extends Named> ports) {
        int longest = 0;
        for (Named named : generics) {
            if (named.getName().length() <= longest) continue;
            longest = named.getName().length();
        }
        for (Named named : ports) {
            if (named.getName().length() <= longest) continue;
            longest = named.getName().length();
        }
        return longest;
    }

    private void parserError(VHDLParserException e) {
        String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_SEVERE_ParserError");
        Exceptions.printStackTrace((Throwable)e);
        logger.log(Level.SEVERE, msg);
    }

    private void parserIOError(IOException e) {
        String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_SEVERE_ParserIOError");
        Exceptions.printStackTrace((Throwable)e);
        logger.log(Level.SEVERE, msg);
    }

    private void stringBuilderError(IOException e) {
        String msg = NbBundle.getMessage(VHDLCodeBuilder.class, (String)"LOG_SEVERE_StringBuilderError");
        Exceptions.printStackTrace((Throwable)e);
        logger.log(Level.SEVERE, msg);
    }
}

