/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.VHDLProject;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.factories.VHDLProjectChildFactory;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import java.awt.Image;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class VHDLProjectLogicalView
implements LogicalViewProvider {
    private final VHDLProject project;

    public VHDLProjectLogicalView(VHDLProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        try {
            FileObject root = this.project.getProjectDirectory();
            DataFolder rootDataObject = DataFolder.findFolder((FileObject)root);
            Node realRootFolderNode = rootDataObject.getNodeDelegate();
            return new ProjectNode(realRootFolderNode, Children.create((ChildFactory)new VHDLProjectChildFactory(this.project), (boolean)true), this.project);
        }
        catch (DataObjectNotFoundException donfe) {
            Exceptions.printStackTrace((Throwable)donfe);
            return new AbstractNode(Children.LEAF);
        }
    }

    public Node findPath(Node root, Object target) {
        return null;
    }

    private final class GenerateNewEntityAction
    extends AbstractAction {
        public GenerateNewEntityAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VHDLProjectService service = (VHDLProjectService)VHDLProjectLogicalView.this.project.getLookup().lookup(VHDLProjectService.class);
            if (service != null) {
                service.generateNewEntity();
            }
        }
    }

    private final class FindEntityAction
    extends AbstractAction {
        public FindEntityAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VHDLProjectService service = (VHDLProjectService)VHDLProjectLogicalView.this.project.getLookup().lookup(VHDLProjectService.class);
            if (service != null) {
                ProjectInformation info = ProjectUtils.getInformation((Project)VHDLProjectLogicalView.this.project);
                NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine("Entity name:", "Find entity in " + info.getDisplayName());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                    service.findAndOpenEntity(nd.getInputText());
                }
            }
        }
    }

    private final class CheckConsistencyAction
    extends AbstractAction {
        public CheckConsistencyAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VHDLProjectService service = (VHDLProjectService)VHDLProjectLogicalView.this.project.getLookup().lookup(VHDLProjectService.class);
            if (service != null) {
                service.checkConsistency();
            }
        }
    }

    private final class ForceRefreshProjectAction
    extends AbstractAction {
        public ForceRefreshProjectAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VHDLProjectService service = (VHDLProjectService)VHDLProjectLogicalView.this.project.getLookup().lookup(VHDLProjectService.class);
            if (service != null) {
                service.forceRefreshProject();
            }
        }
    }

    private final class RefreshProjectAction
    extends AbstractAction {
        public RefreshProjectAction(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VHDLProjectService service = (VHDLProjectService)VHDLProjectLogicalView.this.project.getLookup().lookup(VHDLProjectService.class);
            if (service != null) {
                service.refreshProject();
            }
        }
    }

    private final class ProjectNode
    extends FilterNode {
        final VHDLProject project;

        public ProjectNode(Node node, Children children, VHDLProject project) throws DataObjectNotFoundException {
            super(node, children, (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)project), node.getLookup()}));
            this.project = project;
        }

        public Action[] getActions(boolean arg0) {
            Action[] nodeActions = new Action[13];
            nodeActions[0] = CommonProjectActions.newFileAction();
            nodeActions[1] = CommonProjectActions.copyProjectAction();
            nodeActions[2] = CommonProjectActions.deleteProjectAction();
            nodeActions[4] = new RefreshProjectAction(NbBundle.getMessage(VHDLProjectLogicalView.class, (String)"LBL_RefreshProject"));
            nodeActions[5] = new ForceRefreshProjectAction(NbBundle.getMessage(VHDLProjectLogicalView.class, (String)"LBL_ForceRefreshProject"));
            nodeActions[6] = new CheckConsistencyAction(NbBundle.getMessage(VHDLProjectLogicalView.class, (String)"LBL_CheckConsistency"));
            nodeActions[7] = new GenerateNewEntityAction(NbBundle.getMessage(VHDLProjectLogicalView.class, (String)"LBL_GenerateNewEntity"));
            nodeActions[9] = new FindEntityAction(NbBundle.getMessage(VHDLProjectLogicalView.class, (String)"LBL_FindEntity"));
            nodeActions[11] = CommonProjectActions.setAsMainProjectAction();
            nodeActions[12] = CommonProjectActions.closeProjectAction();
            return nodeActions;
        }

        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)"cz/ctu/fit/mateju/vhdt/vhdlprojectsupport/ico16_vhdlproject.png");
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public String getDisplayName() {
            return this.project.getProjectDirectory().getPath();
        }
    }
}

