/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlprojectsupport;

import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.VHDLProjectLogicalView;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.data.ProjectStructure;
import cz.ctu.fit.mateju.vhdt.vhdlprojectsupport.services.VHDLProjectServiceImpl;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.ProjectState;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class VHDLProject
implements Project {
    private final FileObject projectDir;
    private final ProjectState state;
    private Lookup lkp;
    private final ProjectStructure projectStructure;

    public VHDLProject(FileObject projectDir, ProjectState state) {
        this.projectDir = projectDir;
        this.state = state;
        this.projectStructure = new ProjectStructure();
    }

    public FileObject getProjectDirectory() {
        return this.projectDir;
    }

    public Lookup getLookup() {
        if (this.lkp == null) {
            this.lkp = Lookups.fixed((Object[])new Object[]{this.state, new ActionProviderImpl(), this.loadProperties(), new VHDLDeleteOperation(), new VHDLCopyOperation(this), new Info(), new VHDLProjectLogicalView(this), this.projectStructure, new VHDLProjectServiceImpl(this)});
        }
        return this.lkp;
    }

    private Properties loadProperties() {
        FileObject fob = this.projectDir.getFileObject(VHDTConstants.PROJECT_PROPERTIES.getName());
        NotifyProperties properties = new NotifyProperties(this.state);
        if (fob != null) {
            try {
                properties.load(fob.getInputStream());
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return properties;
    }

    private final class Info
    implements ProjectInformation {
        private Info() {
        }

        public Icon getIcon() {
            return new ImageIcon(ImageUtilities.loadImage((String)"cz/ctu/fit/mateju/vhdt/vhdlprojectsupport/ico16_vhdlproject.png"));
        }

        public String getName() {
            return VHDLProject.this.getProjectDirectory().getPath();
        }

        public String getDisplayName() {
            return this.getName();
        }

        public void addPropertyChangeListener(PropertyChangeListener pcl) {
        }

        public void removePropertyChangeListener(PropertyChangeListener pcl) {
        }

        public Project getProject() {
            return VHDLProject.this;
        }
    }

    private static class NotifyProperties
    extends Properties {
        private final ProjectState state;

        NotifyProperties(ProjectState state) {
            this.state = state;
        }

        @Override
        public Object put(Object key, Object val) {
            Object result = super.put(key, val);
            if (result == null != (val == null) || result != null && val != null && !val.equals(result)) {
                this.state.markModified();
            }
            return result;
        }
    }

    private final class VHDLCopyOperation
    implements CopyOperationImplementation {
        private final VHDLProject project;
        private final FileObject projectDir;

        public VHDLCopyOperation(VHDLProject project) {
            this.project = project;
            this.projectDir = project.getProjectDirectory();
        }

        public List<FileObject> getMetadataFiles() {
            ArrayList<FileObject> dataFiles = new ArrayList<FileObject>();
            return dataFiles;
        }

        public List<FileObject> getDataFiles() {
            ArrayList<FileObject> dataFiles = new ArrayList<FileObject>();
            return dataFiles;
        }

        public void notifyCopying() throws IOException {
        }

        public void notifyCopied(Project arg0, File arg1, String arg2) throws IOException {
        }
    }

    private final class VHDLDeleteOperation
    implements DeleteOperationImplementation {
        private VHDLDeleteOperation() {
        }

        public void notifyDeleting() throws IOException {
        }

        public void notifyDeleted() throws IOException {
        }

        public List<FileObject> getMetadataFiles() {
            ArrayList<FileObject> dataFiles = new ArrayList<FileObject>();
            return dataFiles;
        }

        public List<FileObject> getDataFiles() {
            ArrayList<FileObject> dataFiles = new ArrayList<FileObject>();
            return dataFiles;
        }
    }

    private final class ActionProviderImpl
    implements ActionProvider {
        private String[] supported = new String[]{"delete", "copy"};

        private ActionProviderImpl() {
        }

        public String[] getSupportedActions() {
            return this.supported;
        }

        public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
            if (string.equalsIgnoreCase("delete")) {
                DefaultProjectOperations.performDefaultDeleteOperation((Project)VHDLProject.this);
            }
            if (string.equalsIgnoreCase("copy")) {
                DefaultProjectOperations.performDefaultCopyOperation((Project)VHDLProject.this);
            }
        }

        public boolean isActionEnabled(String command, Lookup lookup) throws IllegalArgumentException {
            if (command.equals("delete")) {
                return true;
            }
            if (command.equals("copy")) {
                return true;
            }
            throw new IllegalArgumentException(command);
        }
    }
}

