/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.TaskListener;

public class Task
implements Runnable {
    public static final Task EMPTY = new Task();
    private static final Logger LOG = Logger.getLogger(Task.class.getName());
    private static WeakHashMap<Class, Boolean> overrides;
    private static RequestProcessor RP;
    final Runnable run;
    private boolean finished;
    private HashSet<TaskListener> list;

    public Task(Runnable run) {
        this.run = run;
        if (run == null) {
            this.finished = true;
        }
    }

    protected Task() {
        this.run = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isFinished() {
        Task task = this;
        synchronized (task) {
            return this.finished;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFinished() {
        Task task = this;
        synchronized (task) {
            while (!this.finished) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFinished(long milliseconds) throws InterruptedException {
        Task task = this;
        synchronized (task) {
            if (this.overridesTimeoutedWaitFinished()) {
                if (this.finished) {
                    return true;
                }
                long expectedEnd = System.currentTimeMillis() + milliseconds;
                while (true) {
                    LOG.log(Level.FINE, "About to wait {0} ms", milliseconds);
                    this.wait(milliseconds);
                    if (this.finished) {
                        LOG.log(Level.FINER, "finished, return");
                        return true;
                    }
                    if (milliseconds == 0L) {
                        LOG.log(Level.FINER, "infinite wait, again");
                        continue;
                    }
                    long now = System.currentTimeMillis();
                    long remains = expectedEnd - now;
                    LOG.log(Level.FINER, "remains {0} ms", remains);
                    if (remains <= 0L) {
                        LOG.log(Level.FINER, "exit, timetout");
                        return false;
                    }
                    milliseconds = remains;
                }
            }
        }
        LOG.fine("Using compatibility waiting");
        class Run
        implements Runnable {
            Run() {
            }

            @Override
            public void run() {
                Task.this.waitFinished();
            }
        }
        RequestProcessor.Task task2 = RP.post(new Run());
        return task2.waitFinished(milliseconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyRunning() {
        Task task = this;
        synchronized (task) {
            RequestProcessor.logger().log(Level.FINE, "notifyRunning: {0}", this);
            this.finished = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyFinished() {
        Iterator it;
        Task task = this;
        synchronized (task) {
            this.finished = true;
            RequestProcessor.logger().log(Level.FINE, "notifyFinished: {0}", this);
            this.notifyAll();
            if (this.list == null) {
                return;
            }
            it = ((HashSet)this.list.clone()).iterator();
        }
        while (it.hasNext()) {
            TaskListener l = (TaskListener)it.next();
            l.taskFinished(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.notifyRunning();
            if (this.run != null) {
                this.run.run();
            }
        }
        finally {
            this.notifyFinished();
        }
    }

    public synchronized void addTaskListener(TaskListener l) {
        if (this.list == null) {
            this.list = new HashSet();
        }
        this.list.add(l);
        if (this.finished) {
            l.taskFinished(this);
        }
    }

    public synchronized void removeTaskListener(TaskListener l) {
        if (this.list == null) {
            return;
        }
        this.list.remove(l);
    }

    public String toString() {
        return "task " + this.run;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean overridesTimeoutedWaitFinished() {
        if (this.getClass() == Task.class) {
            return true;
        }
        if (this.getClass() == RequestProcessor.Task.class) {
            return true;
        }
        Class<Task> clazz = Task.class;
        synchronized (Task.class) {
            WeakHashMap<Class, Boolean> m;
            Boolean does;
            if (overrides == null) {
                overrides = new WeakHashMap();
                RP = new RequestProcessor("Timeout waitFinished compatibility processor", 255);
            }
            if ((does = (m = overrides).get(this.getClass())) != null) {
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return does;
            }
            try {
                Method method = this.getClass().getMethod("waitFinished", Long.TYPE);
                does = method.getDeclaringClass() != Task.class;
                m.put(this.getClass(), does);
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return does;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
                // ** MonitorExit[var3_1] (shouldn't be in output)
                return true;
            }
        }
    }

    String debug() {
        return this.run == null ? "null" : this.run.getClass().getName();
    }

    static {
        Task.EMPTY.finished = true;
    }
}

