/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.actions.clipboardhistory;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.modules.editor.impl.actions.clipboardhistory.ClipboardHistoryElement;
import org.openide.util.NbPreferences;
import org.openide.util.datatransfer.ClipboardEvent;
import org.openide.util.datatransfer.ClipboardListener;
import org.openide.util.datatransfer.ExClipboard;

public final class ClipboardHistory
implements ClipboardListener {
    private final ArrayList<ClipboardHistoryElement> data = new ArrayList();
    private static ClipboardHistory instance;
    private static int MAXSIZE;
    private static Preferences prefs;
    private static final String PREFS_NODE = "ClipboardHistory";
    private static final String PROP_ITEM_PREFIX = "item_";
    private static final boolean PERSISTENT_STATE;

    public static synchronized ClipboardHistory getInstance() {
        if (instance == null) {
            instance = new ClipboardHistory();
        }
        return instance;
    }

    private ClipboardHistory() {
        if (PERSISTENT_STATE) {
            this.load();
        }
    }

    private void addHistory(String text) {
        if (text == null) {
            return;
        }
        ClipboardHistoryElement newHistory = new ClipboardHistoryElement(text);
        if (PERSISTENT_STATE) {
            this.addAndPersist(newHistory);
        } else {
            this.addHistory(newHistory);
        }
    }

    private synchronized void addHistory(ClipboardHistoryElement newHistory) {
        if (!this.data.isEmpty() && newHistory.equals(this.data.get(0))) {
            return;
        }
        this.data.remove(newHistory);
        this.data.add(0, newHistory);
        if (this.data.size() > 2 * MAXSIZE) {
            this.data.remove(this.data.size() - 1);
        }
    }

    public synchronized List<ClipboardHistoryElement> getData() {
        if (this.data.size() > MAXSIZE) {
            return Collections.unmodifiableList(this.data.subList(0, MAXSIZE));
        }
        return Collections.unmodifiableList(this.data);
    }

    public void clipboardChanged(ClipboardEvent ev) {
        ExClipboard clipboard = ev.getClipboard();
        String clipboardContent = null;
        try {
            Transferable transferable = clipboard.getContents(null);
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                clipboardContent = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (IOException ioe) {
        }
        catch (UnsupportedFlavorException ufe) {
            // empty catch block
        }
        if (clipboardContent != null) {
            this.addHistory(clipboardContent);
        }
    }

    public synchronized int getPosition(ClipboardHistoryElement history) {
        return this.data.indexOf(history);
    }

    private void load() {
        for (int i = 0; i < MAXSIZE; ++i) {
            String item = prefs.get(PROP_ITEM_PREFIX + i, null);
            if (item == null) continue;
            this.data.add(i, new ClipboardHistoryElement(item));
        }
    }

    public synchronized void addAndPersist(ClipboardHistoryElement newHistoryElement) {
        int i;
        if (this.data.size() > 0 && newHistoryElement.equals(this.data.get(0))) {
            return;
        }
        for (i = 0; i < this.data.size(); ++i) {
            if (!newHistoryElement.equals(this.data.get(i))) continue;
            this.data.remove(i);
            break;
        }
        if (this.data.size() == MAXSIZE) {
            this.data.remove(MAXSIZE - 1);
        }
        this.data.add(0, newHistoryElement);
        i = 0;
        for (ClipboardHistoryElement elem : this.data) {
            prefs.put(PROP_ITEM_PREFIX + i, elem.getFullText());
            ++i;
        }
    }

    static {
        MAXSIZE = 9;
        PERSISTENT_STATE = Boolean.getBoolean("netbeans.clipboard.history.persistent");
        Integer maxsize = Integer.getInteger("netbeans.clipboard.history.maxsize");
        if (maxsize != null) {
            MAXSIZE = maxsize;
        }
        if (PERSISTENT_STATE) {
            prefs = NbPreferences.forModule(ClipboardHistory.class).node(PREFS_NODE);
        }
    }
}

