/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlsupport.parser;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Declaration;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Generic;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Port;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Position;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Signal;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.SignalMap;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Type;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.AbstractVHDLParser;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLLexerConstants;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParserException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class VHDLParser
extends AbstractVHDLParser {
    public VHDLParser(File file) throws IOException {
        super(file);
    }

    public Entity getEntity() throws IOException, VHDLParserException {
        this.reset();
        if (this.isToken(VHDLLexerConstants.GLOBAL)) {
            Entity.EntityType entityType = Entity.EntityType.UNKNOWN;
            if (this.getString().equalsIgnoreCase(VHDTConstants.ANNOT_TESTBENCH_TEMPLATE.getName())) {
                entityType = Entity.EntityType.TESTBENCH_TEMPLATE;
            } else if (this.getString().equalsIgnoreCase(VHDTConstants.ANNOT_CODE_TEMPLATE.getName())) {
                entityType = Entity.EntityType.CODE_TEMPLATE;
            }
            return new Entity("", entityType, new LinkedHashMap(), new LinkedHashMap(), "", new LinkedHashMap(), new LinkedHashMap(), new HashMap(), new LinkedHashMap());
        }
        String entityName = "";
        Entity.EntityType entityType = Entity.EntityType.UNKNOWN;
        LinkedHashMap<String, Generic> entityGenerics = new LinkedHashMap<String, Generic>();
        LinkedHashMap<String, Port> entityPorts = new LinkedHashMap<String, Port>();
        while (!this.isEOF()) {
            if (this.accept(VHDLLexerConstants.ENTITY)) {
                entityType = Entity.EntityType.ENTITY;
                break;
            }
            if (this.accept(VHDLLexerConstants.PACKAGE)) {
                entityType = Entity.EntityType.PACKAGE;
                break;
            }
            this.nextToken();
        }
        if (this.isToken(VHDLLexerConstants.IDENT)) {
            entityName = this.getString();
            this.accept(VHDLLexerConstants.IDENT);
            if (!this.accept(VHDLLexerConstants.IS)) {
                entityName = "";
                entityType = Entity.EntityType.UNKNOWN;
            } else if (entityType == Entity.EntityType.ENTITY && this.accept(VHDLLexerConstants.END)) {
                entityType = Entity.EntityType.TESTBENCH;
            } else {
                if (this.isToken(VHDLLexerConstants.GENERIC)) {
                    this.readGenerics(entityGenerics);
                }
                if (this.isToken(VHDLLexerConstants.PORT)) {
                    this.readPorts(entityPorts);
                }
            }
        }
        String architectureName = "";
        while (!this.isEOF() && !this.accept(VHDLLexerConstants.ARCHITECTURE)) {
            this.nextToken();
        }
        if (this.isToken(VHDLLexerConstants.IDENT)) {
            architectureName = this.getString();
            this.accept(VHDLLexerConstants.IDENT);
            if (!this.accept(VHDLLexerConstants.OF)) {
                architectureName = "";
            }
        }
        HashMap<String, Signal> signals = new HashMap<String, Signal>();
        HashMap<String, Type> types = new HashMap<String, Type>();
        HashMap<String, Declaration> componentDeclarations = new HashMap<String, Declaration>();
        HashMap<String, Instantiation> componentInstantiations = new HashMap<String, Instantiation>();
        StringBuilder name = new StringBuilder();
        StringBuilder type = new StringBuilder();
        while (!this.isEOF()) {
            if (this.isToken(VHDLLexerConstants.TYPE)) {
                this.readTypes(types);
                continue;
            }
            if (this.isToken(VHDLLexerConstants.SIGNAL)) {
                this.readSignals(signals);
                continue;
            }
            if (this.accept(VHDLLexerConstants.COMPONENT)) {
                if (!this.accept(VHDLLexerConstants.IDENT, name)) continue;
                LinkedHashMap<String, Generic> componentGenerics = new LinkedHashMap<String, Generic>();
                LinkedHashMap<String, Port> componentPorts = new LinkedHashMap<String, Port>();
                boolean isDeclaration = false;
                if (this.accept(VHDLLexerConstants.IS)) {
                    isDeclaration = true;
                }
                if (this.isToken(VHDLLexerConstants.GENERIC)) {
                    this.readGenerics(componentGenerics);
                    isDeclaration = true;
                }
                if (this.isToken(VHDLLexerConstants.PORT)) {
                    this.readPorts(componentPorts);
                    isDeclaration = true;
                }
                if (!isDeclaration) continue;
                componentDeclarations.put(name.toString().toLowerCase(), new Declaration(name.toString(), componentGenerics, componentPorts));
                continue;
            }
            if (this.accept(VHDLLexerConstants.IDENT, name)) {
                if (!this.accept(VHDLLexerConstants.COLON) || !this.accept(VHDLLexerConstants.IDENT, type)) continue;
                LinkedHashMap<String, SignalMap> genericMap = new LinkedHashMap<String, SignalMap>();
                LinkedHashMap<String, SignalMap> portMap = new LinkedHashMap<String, SignalMap>();
                boolean isInst = false;
                if (this.accept(VHDLLexerConstants.GENERIC) && this.accept(VHDLLexerConstants.MAP) && this.accept(VHDLLexerConstants.LPAR)) {
                    this.readMap(genericMap);
                    isInst = true;
                }
                if (this.accept(VHDLLexerConstants.PORT) && this.accept(VHDLLexerConstants.MAP) && this.accept(VHDLLexerConstants.LPAR)) {
                    this.readMap(portMap);
                    isInst = true;
                }
                if (!isInst) continue;
                componentInstantiations.put(name.toString().toLowerCase(), new Instantiation(name.toString(), type.toString(), genericMap, portMap));
                continue;
            }
            this.nextToken();
        }
        Entity entity = new Entity(entityName, entityType, entityGenerics, entityPorts, architectureName, types, signals, componentDeclarations, componentInstantiations);
        return entity;
    }

    private void readGenerics(Map<String, Generic> generics) throws IOException {
        if (this.accept(VHDLLexerConstants.GENERIC) && this.accept(VHDLLexerConstants.LPAR)) {
            HashSet<String> names = new HashSet<String>();
            StringBuilder name = new StringBuilder();
            StringBuilder type = new StringBuilder();
            StringBuilder value = new StringBuilder();
            while (!this.isEOF() && !this.accept(VHDLLexerConstants.RPAR)) {
                names.clear();
                while (this.accept(VHDLLexerConstants.IDENT, name)) {
                    names.add(name.toString());
                    this.accept(VHDLLexerConstants.COMMA);
                }
                if (this.accept(VHDLLexerConstants.COLON)) {
                    this.readSignalType(type);
                    if (this.accept(VHDLLexerConstants.ASSIGN)) {
                        this.readSignalType(value);
                    } else {
                        value.delete(0, value.length());
                    }
                    for (String nm : names) {
                        generics.put(nm.toLowerCase(), new Generic(nm, type.toString().trim(), value.toString().trim()));
                    }
                    continue;
                }
                if (this.isToken(VHDLLexerConstants.RPAR)) continue;
                this.nextToken();
            }
            this.accept(VHDLLexerConstants.SEMICOLON);
        }
    }

    private void readPorts(Map<String, Port> ports) throws IOException {
        if (this.accept(VHDLLexerConstants.PORT) && this.accept(VHDLLexerConstants.LPAR)) {
            HashSet<String> names = new HashSet<String>();
            StringBuilder name = new StringBuilder();
            StringBuilder mode = new StringBuilder();
            StringBuilder type = new StringBuilder();
            StringBuilder value = new StringBuilder();
            while (!this.isEOF() && !this.accept(VHDLLexerConstants.RPAR)) {
                names.clear();
                while (this.accept(VHDLLexerConstants.IDENT, name)) {
                    names.add(name.toString());
                    this.accept(VHDLLexerConstants.COMMA);
                }
                if (this.accept(VHDLLexerConstants.COLON) && (this.accept(VHDLLexerConstants.IN, mode) || this.accept(VHDLLexerConstants.OUT, mode) || this.accept(VHDLLexerConstants.INOUT, mode) || this.accept(VHDLLexerConstants.BUFFER, mode) || this.accept(VHDLLexerConstants.LINKAGE, mode))) {
                    this.readSignalType(type);
                    if (this.isToken(VHDLLexerConstants.ASSIGN)) {
                        this.readSignalType(value);
                    } else {
                        value.delete(0, value.length());
                    }
                    for (String nm : names) {
                        ports.put(nm.toLowerCase(), new Port(nm, mode.toString(), type.toString().trim(), value.toString().trim()));
                    }
                    continue;
                }
                if (this.isToken(VHDLLexerConstants.RPAR)) continue;
                this.nextToken();
            }
            this.accept(VHDLLexerConstants.SEMICOLON);
        }
    }

    private void readTypes(Map<String, Type> types) throws IOException {
        if (this.isToken(VHDLLexerConstants.TYPE)) {
            StringBuilder name = new StringBuilder();
            StringBuilder value = new StringBuilder();
            StringBuilder dataType = new StringBuilder();
            while (this.accept(VHDLLexerConstants.TYPE)) {
                boolean array = false;
                if (this.accept(VHDLLexerConstants.IDENT, name)) {
                    if (this.accept(VHDLLexerConstants.IS)) {
                        if (this.accept(VHDLLexerConstants.ARRAY)) {
                            array = true;
                        }
                        this.readSignalType(value);
                        if (this.accept(VHDLLexerConstants.OF)) {
                            this.readSignalType(dataType);
                        } else {
                            dataType.delete(0, value.length());
                        }
                    } else {
                        value.delete(0, value.length());
                    }
                    types.put(name.toString().toLowerCase(), new Type(name.toString(), array, value.toString().trim(), dataType.toString().trim()));
                }
                this.accept(VHDLLexerConstants.SEMICOLON);
            }
        }
    }

    private void readSignals(Map<String, Signal> signals) throws IOException {
        if (this.isToken(VHDLLexerConstants.SIGNAL)) {
            HashSet<String> names = new HashSet<String>();
            StringBuilder name = new StringBuilder();
            StringBuilder type = new StringBuilder();
            StringBuilder value = new StringBuilder();
            while (this.accept(VHDLLexerConstants.SIGNAL)) {
                names.clear();
                while (this.accept(VHDLLexerConstants.IDENT, name)) {
                    names.add(name.toString());
                    this.accept(VHDLLexerConstants.COMMA);
                }
                if (this.accept(VHDLLexerConstants.COLON)) {
                    this.readSignalType(type);
                    if (this.accept(VHDLLexerConstants.ASSIGN)) {
                        this.readSignalType(value);
                    } else {
                        value.delete(0, value.length());
                    }
                    for (String nm : names) {
                        signals.put(nm.toLowerCase(), (Signal)new Generic(nm, type.toString().trim(), value.toString().trim()));
                    }
                }
                this.accept(VHDLLexerConstants.SEMICOLON);
            }
        }
    }

    private void readSignalType(StringBuilder type) throws IOException {
        boolean ignore = this.ignoreWhitespaces();
        this.setIgnoreWhitespaces(false);
        int parCount = 0;
        type.delete(0, type.length());
        while (!(this.isEOF() || this.isToken(VHDLLexerConstants.COMMA) && parCount == 0 || this.isToken(VHDLLexerConstants.SEMICOLON) || this.isToken(VHDLLexerConstants.ASSIGN))) {
            if (this.isToken(VHDLLexerConstants.LPAR)) {
                ++parCount;
            }
            if (this.isToken(VHDLLexerConstants.RPAR)) {
                --parCount;
            }
            if (parCount < 0) break;
            type.append(this.getString());
            this.nextToken();
        }
        if (this.isToken(VHDLLexerConstants.COMMA)) {
            this.nextToken();
        }
        this.setIgnoreWhitespaces(ignore);
    }

    private void readMap(Map<String, SignalMap> map) throws IOException {
        StringBuilder a = new StringBuilder();
        StringBuilder b = new StringBuilder();
        while (!this.isEOF() && !this.accept(VHDLLexerConstants.RPAR)) {
            if (this.accept(VHDLLexerConstants.IDENT, a) && this.accept(VHDLLexerConstants.RASSIGN)) {
                this.readSignalType(b);
                SignalMap signalMap = new SignalMap(a.toString(), b.toString().trim());
                map.put(a.toString().toLowerCase(), signalMap);
                continue;
            }
            if (this.isToken(VHDLLexerConstants.RPAR)) continue;
            this.nextToken();
        }
    }

    private void readTo(VHDLLexerConstants endToken, StringBuilder rest) throws IOException {
        boolean ignore = this.ignoreWhitespaces();
        this.setIgnoreWhitespaces(false);
        while (!this.isEOF() && !this.accept(endToken)) {
            this.nextToken();
            rest.append(this.getString());
        }
        this.setIgnoreWhitespaces(ignore);
    }

    public Position getEntityPosition() throws IOException, VHDLParserException {
        this.reset();
        Position position = new Position(0L, 0L);
        while (!this.isEOF()) {
            if (this.accept(VHDLLexerConstants.ENTITY) && this.isToken(VHDLLexerConstants.IDENT)) {
                position.setFrom(this.getPosition().getFrom());
                break;
            }
            this.nextToken();
        }
        while (!this.isEOF()) {
            if (this.isToken(VHDLLexerConstants.END)) {
                position.setTo(this.getPosition().getTo());
                break;
            }
            this.nextToken();
        }
        return position;
    }

    public Position getArchitecturePosition() throws IOException, VHDLParserException {
        this.reset();
        Position position = new Position(0L, 0L);
        while (!this.isEOF()) {
            if (this.accept(VHDLLexerConstants.ARCHITECTURE) && this.accept(VHDLLexerConstants.IDENT) && this.accept(VHDLLexerConstants.OF) && this.accept(VHDLLexerConstants.IDENT) && this.isToken(VHDLLexerConstants.IS)) {
                position.setFrom(this.getPosition().getTo());
                break;
            }
            this.nextToken();
        }
        while (!this.isEOF() && !this.isToken(VHDLLexerConstants.BEGIN)) {
            this.nextToken();
        }
        while (!this.isEOF()) {
            if (this.isToken(VHDLLexerConstants.END)) {
                long endPos = this.getPosition().getFrom();
                this.nextToken();
                this.accept(VHDLLexerConstants.ARCHITECTURE);
                this.accept(VHDLLexerConstants.IDENT);
                if (this.accept(VHDLLexerConstants.SEMICOLON) && this.isEOF()) {
                    position.setTo(endPos);
                    break;
                }
            }
            this.nextToken();
        }
        return position;
    }

    public Position getDeclarationPosition(String decName) throws IOException, VHDLParserException {
        this.reset();
        this.setIgnoreWhitespaces(false);
        Position position = new Position(0L, 0L);
        StringBuilder declaration = new StringBuilder();
        StringBuilder gap = new StringBuilder();
        while (!this.isEOF()) {
            long from = this.getPosition().getFrom();
            this.accept(VHDLLexerConstants.WHITESPACE, gap);
            if (this.isToken(VHDLLexerConstants.COMPONENT)) {
                this.setIgnoreWhitespaces(true);
                this.accept(VHDLLexerConstants.COMPONENT);
                if (this.accept(VHDLLexerConstants.IDENT, declaration) && declaration.toString().equalsIgnoreCase(decName)) {
                    position.setFrom(from);
                    break;
                }
                this.setIgnoreWhitespaces(false);
            }
            if (gap.length() != 0) {
                gap.delete(0, gap.length());
            }
            this.nextToken();
        }
        position.setGap(gap.toString());
        while (!this.isEOF()) {
            if (this.accept(VHDLLexerConstants.END) && (this.accept(VHDLLexerConstants.COMPONENT) || this.accept(VHDLLexerConstants.IDENT))) {
                this.accept(VHDLLexerConstants.IDENT);
                if (this.isToken(VHDLLexerConstants.SEMICOLON)) {
                    position.setTo(this.getPosition().getTo());
                    break;
                }
            }
            this.nextToken();
        }
        return position;
    }

    public Position getDeclarationEndPosition(String decName) throws IOException, VHDLParserException {
        Position position = this.getDeclarationPosition(decName);
        if (position.getFrom() != 0L && position.getTo() != 0L) {
            position.setFrom(position.getTo());
        } else {
            position = this.getArchitecturePosition();
            position.setTo(position.getFrom());
        }
        return position;
    }

    public Position getInstantiationPosition(String instName, String decName) throws IOException, VHDLParserException {
        this.reset();
        this.setIgnoreWhitespaces(false);
        Position position = new Position(0L, 0L);
        while (!this.isEOF() && !this.accept(VHDLLexerConstants.ARCHITECTURE)) {
            this.nextToken();
        }
        StringBuilder dec = new StringBuilder();
        StringBuilder gap = new StringBuilder();
        while (!this.isEOF()) {
            long from = this.getPosition().getFrom();
            this.accept(VHDLLexerConstants.WHITESPACE, gap);
            if (this.isToken(VHDLLexerConstants.IDENT) && this.getString().equalsIgnoreCase(instName)) {
                this.setIgnoreWhitespaces(true);
                this.accept(VHDLLexerConstants.IDENT);
                if (this.accept(VHDLLexerConstants.COLON) && this.accept(VHDLLexerConstants.IDENT, dec) && dec.toString().equalsIgnoreCase(decName)) {
                    position.setFrom(from);
                    break;
                }
                this.setIgnoreWhitespaces(false);
            }
            if (gap.length() != 0) {
                gap.delete(0, gap.length());
            }
            this.nextToken();
        }
        position.setGap(gap.toString());
        while (!this.isEOF()) {
            if (this.accept(VHDLLexerConstants.RPAR) && this.isToken(VHDLLexerConstants.SEMICOLON)) {
                position.setTo(this.getPosition().getTo());
                break;
            }
            this.nextToken();
        }
        return position;
    }

    public void getTypesAndSignals(Map<String, Type> types, Map<String, Signal> signals) throws IOException, VHDLParserException {
        this.reset();
        while (!this.isEOF()) {
            if (this.isToken(VHDLLexerConstants.TYPE)) {
                this.readTypes(types);
                continue;
            }
            if (this.isToken(VHDLLexerConstants.SIGNAL)) {
                this.readSignals(signals);
                continue;
            }
            this.nextToken();
        }
    }

    public void getDollarMarks(Map<String, String> marks) throws IOException, VHDLParserException {
        this.reset();
        while (!this.isEOF()) {
            if (this.isToken(VHDLLexerConstants.DIDENT)) {
                String mark = this.getString();
                marks.put(mark.toLowerCase(), mark.substring(1, mark.length() - 1));
            }
            this.nextToken();
        }
    }

    public void getMarkPositions(List<Position> positions) throws IOException, VHDLParserException {
        this.reset();
        this.setIgnoreWhitespaces(false);
        StringBuilder gap = new StringBuilder();
        while (!this.isEOF()) {
            this.accept(VHDLLexerConstants.WHITESPACE, gap);
            if (this.isToken(VHDLLexerConstants.DIDENT) || this.isToken(VHDLLexerConstants.GLOBAL)) {
                positions.add(new Position(this.getPosition().getFrom(), this.getPosition().getTo(), gap.toString(), this.getString()));
            }
            if (gap.length() != 0) {
                gap.delete(0, gap.length());
            }
            this.nextToken();
        }
    }

    public void getAnnotationPositions(List<Position> positions) throws IOException, VHDLParserException {
        this.reset();
        while (!this.isEOF() && !this.isToken(VHDLLexerConstants.ENTITY)) {
            if (this.isToken(VHDLLexerConstants.GLOBAL)) {
                positions.add(new Position(this.getPosition().getFrom(), this.getPosition().getTo(), "", this.getString()));
            }
            this.nextToken();
        }
    }

    public void getCaseMarkPositions(List<Position> positions) throws IOException, VHDLParserException {
        this.reset();
        this.setIgnoreWhitespaces(false);
        StringBuilder gap = new StringBuilder();
        while (!this.isEOF()) {
            this.accept(VHDLLexerConstants.WHITESPACE, gap);
            if (this.isToken(VHDLLexerConstants.CASEMARK)) {
                positions.add(new Position(this.getPosition().getFrom(), this.getPosition().getTo(), gap.toString(), this.getString()));
            }
            if (gap.length() != 0) {
                gap.delete(0, gap.length());
            }
            this.nextToken();
        }
    }
}

