/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlsupport.parser;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Position;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.AbstractVHDLLexer;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLLanguageHierarchy;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLLexerConstants;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.openide.util.NbBundle;

class VHDLLexer
extends AbstractVHDLLexer {
    private final FileInputStream input;
    private final FileChannel channel;
    private final StringBuilder buffer;
    private final Position position;
    private boolean isOpened;

    VHDLLexer(File file) throws IOException {
        this.input = new FileInputStream(file);
        this.channel = this.input.getChannel();
        this.buffer = new StringBuilder();
        this.position = new Position(0L, 0L);
        this.isOpened = true;
    }

    public VHDLToken nextToken() throws IOException {
        this.buffer.delete(0, this.buffer.length());
        this.position.setFrom(this.channel.position());
        VHDLToken token = this.getNextToken();
        this.position.setTo(this.channel.position());
        if (token == null) {
            return null;
        }
        return token;
    }

    @Override
    public String getString() {
        return this.buffer.toString();
    }

    public Position getPosition() {
        return this.position;
    }

    public void reset() throws IOException {
        this.isEOF = false;
        this.channel.position(0L);
        this.buffer.delete(0, this.buffer.length());
        this.position.setFrom(0L);
        this.position.setTo(0L);
    }

    @Override
    protected int nextChar() throws IOException {
        int b = this.input.read();
        if (b == -1) {
            this.isEOF = true;
        }
        this.buffer.append((char)b);
        return b;
    }

    @Override
    protected void backup(int count) throws IOException {
        this.buffer.delete(this.buffer.length() - count, this.buffer.length());
        long pos = this.channel.position();
        if ((pos -= (long)count) < 0L) {
            throw new IOException(NbBundle.getMessage(VHDLLexer.class, (String)"ERROR_IndexOutOfBounds"));
        }
        this.channel.position(pos);
    }

    @Override
    protected VHDLToken token(VHDLLexerConstants id) {
        return VHDLLanguageHierarchy.getToken(id);
    }

    @Override
    protected VHDLLexerConstants evaluate() {
        return VHDLLanguageHierarchy.evaluateToken(this.getString());
    }

    public void closeStream() throws IOException {
        this.input.close();
        this.isOpened = false;
    }

    public boolean isOpened() {
        return this.isOpened;
    }
}

