/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlsupport.parser;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Position;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLLexer;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLLexerConstants;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParserException;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLToken;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public abstract class AbstractVHDLParser {
    protected static final Logger logger = Logger.getLogger(VHDLLexer.class.getSimpleName());
    private final VHDLLexer lexer;
    private boolean ignoreWhitespaces;
    private boolean ignoreComments;
    protected VHDLToken token;
    boolean firstToken;

    protected AbstractVHDLParser(File file) throws IOException {
        this.lexer = new VHDLLexer(file);
        this.ignoreWhitespaces = true;
        this.ignoreComments = true;
        this.firstToken = true;
        this.nextToken();
        this.firstToken = false;
    }

    public void closeStream() throws IOException {
        this.lexer.closeStream();
    }

    protected void reset() throws IOException, VHDLParserException {
        if (!this.isOpened()) {
            throw new VHDLParserException(NbBundle.getMessage(AbstractVHDLParser.class, (String)"ERROR_InputClosed"));
        }
        this.lexer.reset();
        this.ignoreWhitespaces = true;
        this.ignoreComments = true;
        this.firstToken = true;
        this.nextToken();
        this.firstToken = false;
    }

    protected final void nextToken() throws IOException {
        if (!this.isEOF() || this.firstToken) {
            this.token = this.lexer.nextToken();
            if (this.ignoreWhitespaces() && (this.isToken(VHDLLexerConstants.WHITESPACE) || this.isToken(VHDLLexerConstants.LF))) {
                this.nextToken();
            } else if (this.ignoreComments() && this.isToken(VHDLLexerConstants.COMMENT)) {
                this.nextToken();
            }
        }
    }

    protected String getString() {
        return this.lexer.getString();
    }

    protected Position getPosition() {
        return this.lexer.getPosition();
    }

    protected boolean accept(VHDLLexerConstants expected) throws IOException {
        if (this.isToken(expected)) {
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean accept(VHDLLexerConstants expected, StringBuilder text) throws IOException {
        if (this.isToken(expected)) {
            text.delete(0, text.length());
            text.append(this.getString());
            this.nextToken();
            return true;
        }
        return false;
    }

    protected boolean isToken(VHDLLexerConstants ordinal) {
        return !this.isEOF() && this.token.ordinal() == ordinal.ordinal();
    }

    protected boolean isOpened() {
        return this.lexer.isOpened();
    }

    protected boolean isEOF() {
        return this.token == null;
    }

    protected boolean ignoreWhitespaces() {
        return this.ignoreWhitespaces;
    }

    protected boolean ignoreComments() {
        return this.ignoreComments;
    }

    protected void setIgnoreWhitespaces(boolean ignoreWhitespaces) {
        this.ignoreWhitespaces = ignoreWhitespaces;
    }

    protected void setIgnoreComments(boolean ignoreComments) {
        this.ignoreComments = ignoreComments;
    }
}

