/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlsupport;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParser;
import cz.ctu.fit.mateju.vhdt.vhdlsupport.parser.VHDLParserException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class VHDLDataObject
extends MultiDataObject
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(VHDLDataObject.class.getSimpleName());
    private Entity structure;

    public VHDLDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        this.registerEditor("text/x-vhdl", false);
        this.init();
    }

    private void init() {
        this.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this));
    }

    public Object getFromProject(Class<?> clazz) {
        Project p = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile());
        Object result = p != null ? p.getLookup().lookup(clazz) : null;
        return result;
    }

    public synchronized Entity getStructure() {
        if (this.structure == null) {
            this.recreateStructure();
        }
        return this.structure;
    }

    public boolean hasChildren() {
        return !this.getStructure().getInstantiations().isEmpty();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        VHDLProjectService service;
        if (evt.getPropertyName().equals("modified") && evt.getNewValue().equals(false)) {
            this.structure = null;
            this.firePropertyChange("name", "a", "b");
            service = (VHDLProjectService)this.getFromProject(VHDLProjectService.class);
            if (service != null) {
                service.refreshProject();
            }
        }
        if (evt.getPropertyName().equals("valid") && evt.getNewValue().equals(false)) {
            this.structure = null;
            service = (VHDLProjectService)this.getFromProject(VHDLProjectService.class);
            if (service != null) {
                service.refreshProject();
            }
        }
    }

    public void recreateStructure() {
        try {
            VHDLParser parser = new VHDLParser(FileUtil.toFile((FileObject)this.getPrimaryFile()));
            this.structure = parser.getEntity();
            parser.closeStream();
        }
        catch (VHDLParserException e) {
            String msg = NbBundle.getMessage(VHDLParser.class, (String)"LOG_SEVERE_ParserError", (Object)this.getName());
            logger.log(Level.SEVERE, msg);
            logger.log(Level.SEVERE, e.getMessage());
        }
        catch (IOException e) {
            String msg = NbBundle.getMessage(VHDLParser.class, (String)"LOG_SEVERE_ParserIOError", (Object)this.getName());
            logger.log(Level.SEVERE, msg);
            logger.log(Level.SEVERE, e.getMessage());
        }
    }

    public void nullStructure() {
        this.structure = null;
    }

    protected int associateLookup() {
        return 1;
    }

    public static MultiViewEditorElement createEditor(Lookup lkp) {
        return new MultiViewEditorElement(lkp);
    }
}

