/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.options;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.core.output2.Controller;
import org.netbeans.core.output2.NbIOProvider;
import org.netbeans.core.output2.options.LinkStyleModel;
import org.netbeans.core.output2.options.OutputOptions;
import org.netbeans.core.output2.options.OutputSettingsOptionsPanelController;
import org.netbeans.core.output2.options.PreviewIOProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.ColorComboBox;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColorPrint;
import org.openide.windows.IOContainer;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;

public final class OutputSettingsPanel
extends JPanel {
    private OutputOptions outputOptions;
    private InputOutput previewInputOutput = null;
    private final OutputSettingsOptionsPanelController controller;
    private LinkStyleModel linkStyleModel = new LinkStyleModel();
    private JButton btnRestore;
    private JButton btnSelectFont;
    private JComboBox cmbBackgroundColor;
    private JComboBox cmbErrorColor;
    private JComboBox cmbImportantLinkColor;
    private JComboBox cmbLinkColor;
    private JComboBox cmbLinkStyle;
    private JComboBox cmbStandardColor;
    private JTextField fldFontFamily;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JLabel lblBackgroundColor;
    private JLabel lblErrorColor;
    private JLabel lblFontFamily;
    private JLabel lblFontSize;
    private JLabel lblLinkColor;
    private JLabel lblLinkStyle;
    private JLabel lblStandardColor;
    private JLabel lblTitle;
    private JPanel previewPanel;
    private JSpinner spnFontSize;

    OutputSettingsPanel(OutputSettingsOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblFontFamily = new JLabel();
        this.lblStandardColor = new JLabel();
        this.lblErrorColor = new JLabel();
        this.lblBackgroundColor = new JLabel();
        this.lblLinkColor = new JLabel();
        this.cmbLinkColor = new ColorComboBox();
        this.cmbBackgroundColor = new ColorComboBox();
        this.cmbErrorColor = new ColorComboBox();
        this.cmbStandardColor = new ColorComboBox();
        this.lblFontSize = new JLabel();
        this.spnFontSize = new JSpinner();
        this.btnSelectFont = new JButton();
        this.cmbLinkStyle = new JComboBox();
        this.lblLinkStyle = new JLabel();
        this.fldFontFamily = new JTextField();
        this.cmbImportantLinkColor = new ColorComboBox();
        this.jLabel1 = new JLabel();
        this.previewPanel = new JPanel();
        this.btnRestore = new JButton();
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblTitle.text"));
        this.lblFontFamily.setLabelFor(this.btnSelectFont);
        Mnemonics.setLocalizedText((JLabel)this.lblFontFamily, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblFontFamily.text"));
        this.lblStandardColor.setLabelFor(this.cmbStandardColor);
        Mnemonics.setLocalizedText((JLabel)this.lblStandardColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblStandardColor.text"));
        this.lblErrorColor.setLabelFor(this.cmbErrorColor);
        Mnemonics.setLocalizedText((JLabel)this.lblErrorColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblErrorColor.text"));
        this.lblBackgroundColor.setLabelFor(this.cmbBackgroundColor);
        Mnemonics.setLocalizedText((JLabel)this.lblBackgroundColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblBackgroundColor.text"));
        this.lblLinkColor.setLabelFor(this.cmbLinkColor);
        Mnemonics.setLocalizedText((JLabel)this.lblLinkColor, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblLinkColor.text"));
        this.cmbLinkColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbLinkColor.toolTipText"));
        this.cmbLinkColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.cmbLinkColorActionPerformed(evt);
            }
        });
        this.cmbBackgroundColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbBackgroundColor.toolTipText"));
        this.cmbBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.cmbBackgroundColorActionPerformed(evt);
            }
        });
        this.cmbErrorColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbErrorColor.toolTipText"));
        this.cmbErrorColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.cmbErrorColorActionPerformed(evt);
            }
        });
        this.cmbStandardColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbStandardColor.toolTipText"));
        this.cmbStandardColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.cmbStandardColorActionPerformed(evt);
            }
        });
        this.lblFontSize.setLabelFor(this.spnFontSize);
        Mnemonics.setLocalizedText((JLabel)this.lblFontSize, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblFontSize.text"));
        this.spnFontSize.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.spnFontSize.toolTipText"));
        this.spnFontSize.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OutputSettingsPanel.this.spnFontSizeStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectFont, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnSelectFont.text"));
        this.btnSelectFont.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnSelectFont.toolTipText"));
        this.btnSelectFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.btnSelectFontActionPerformed(evt);
            }
        });
        this.cmbLinkStyle.setModel(this.linkStyleModel);
        this.cmbLinkStyle.setSelectedIndex(0);
        this.cmbLinkStyle.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbLinkStyle.toolTipText"));
        this.cmbLinkStyle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.cmbLinkStyleActionPerformed(evt);
            }
        });
        this.lblLinkStyle.setLabelFor(this.cmbLinkStyle);
        Mnemonics.setLocalizedText((JLabel)this.lblLinkStyle, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.lblLinkStyle.text"));
        this.fldFontFamily.setEditable(false);
        this.fldFontFamily.setText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.fldFontFamily.text"));
        this.cmbImportantLinkColor.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.cmbImportantLinkColor.toolTipText"));
        this.cmbImportantLinkColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.cmbImportantLinkColorActionPerformed(evt);
            }
        });
        this.jLabel1.setLabelFor(this.cmbImportantLinkColor);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.jLabel1.text"));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblLinkColor).addComponent(this.lblFontFamily).addComponent(this.lblBackgroundColor).addComponent(this.lblFontSize).addComponent(this.jLabel1).addComponent(this.lblLinkStyle)).addGap(79, 79, 79).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbLinkStyle, 0, -1, Short.MAX_VALUE).addComponent(this.cmbLinkColor, 0, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.fldFontFamily).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectFont)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.spnFontSize, -2, 71, -2).addGap(0, 46, Short.MAX_VALUE)).addComponent(this.cmbImportantLinkColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbBackgroundColor, 0, -1, Short.MAX_VALUE))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblErrorColor).addComponent(this.lblStandardColor)).addGap(104, 104, 104).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cmbErrorColor, 0, -1, Short.MAX_VALUE).addComponent(this.cmbStandardColor, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFontFamily).addComponent(this.btnSelectFont).addComponent(this.fldFontFamily, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFontSize).addComponent(this.spnFontSize, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblBackgroundColor).addComponent(this.cmbBackgroundColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbStandardColor, -2, -1, -2).addComponent(this.lblStandardColor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbErrorColor, -2, -1, -2).addComponent(this.lblErrorColor)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblLinkColor).addComponent(this.cmbLinkColor, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbImportantLinkColor, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cmbLinkStyle, -2, -1, -2).addComponent(this.lblLinkStyle)).addContainerGap(-1, Short.MAX_VALUE)));
        this.previewPanel.setBorder(BorderFactory.createBevelBorder(1));
        this.previewPanel.setLayout(new BoxLayout(this.previewPanel, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.btnRestore, (String)NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnRestore.text"));
        this.btnRestore.setToolTipText(NbBundle.getMessage(OutputSettingsPanel.class, (String)"OutputSettingsPanel.btnRestore.toolTipText"));
        this.btnRestore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutputSettingsPanel.this.btnRestoreActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.previewPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.btnRestore))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblTitle).addComponent(this.btnRestore)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewPanel, -1, 101, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnSelectFontActionPerformed(ActionEvent evt) {
        PropertyEditor pe = PropertyEditorManager.findEditor(Font.class);
        if (pe != null) {
            pe.setValue(this.outputOptions.getFont());
            DialogDescriptor dd = new DialogDescriptor((Object)pe.getCustomEditor(), NbBundle.getMessage(Controller.class, (String)"LBL_Font_Chooser_Title"));
            String defaultFont = NbBundle.getMessage(Controller.class, (String)"BTN_Defaul_Font");
            dd.setOptions(new Object[]{DialogDescriptor.OK_OPTION, defaultFont, DialogDescriptor.CANCEL_OPTION});
            DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
            if (dd.getValue() == DialogDescriptor.OK_OPTION) {
                Font f = (Font)pe.getValue();
                this.outputOptions.setFont(f);
            } else if (dd.getValue() == defaultFont) {
                this.outputOptions.setFont(null);
            }
            this.updateFontField();
        }
    }

    private void cmbStandardColorActionPerformed(ActionEvent evt) {
        Color std = ((ColorComboBox)this.cmbStandardColor).getSelectedColor();
        if (std != null) {
            this.outputOptions.setColorStandard(std);
        }
    }

    private void spnFontSizeStateChanged(ChangeEvent evt) {
        int fontSize = (Integer)this.spnFontSize.getValue();
        this.outputOptions.setFont(this.outputOptions.getFont().deriveFont((float)fontSize));
        this.updateFontField();
    }

    private void cmbBackgroundColorActionPerformed(ActionEvent evt) {
        Color bg = ((ColorComboBox)this.cmbBackgroundColor).getSelectedColor();
        if (bg != null) {
            this.outputOptions.setColorBackground(bg);
        }
    }

    private void cmbErrorColorActionPerformed(ActionEvent evt) {
        Color err = ((ColorComboBox)this.cmbErrorColor).getSelectedColor();
        if (err != null) {
            this.outputOptions.setColorError(err);
        }
    }

    private void cmbLinkColorActionPerformed(ActionEvent evt) {
        Color link = ((ColorComboBox)this.cmbLinkColor).getSelectedColor();
        if (link != null) {
            this.outputOptions.setColorLink(link);
        }
    }

    private void cmbImportantLinkColorActionPerformed(ActionEvent evt) {
        Color iLink = ((ColorComboBox)this.cmbImportantLinkColor).getSelectedColor();
        if (iLink != null) {
            this.outputOptions.setColorLinkImportant(iLink);
        }
    }

    private void btnRestoreActionPerformed(ActionEvent evt) {
        this.outputOptions.resetToDefault();
        this.updateControlsByModel();
    }

    private void cmbLinkStyleActionPerformed(ActionEvent evt) {
        this.outputOptions.setLinkStyle(this.linkStyleModel.getLinkStyle());
    }

    void load() {
        if (this.previewInputOutput == null) {
            this.initPreview();
        }
        this.updateControlsByModel();
    }

    private void selectColor(JComboBox combo, Color color) {
        ((ColorComboBox)combo).setSelectedColor(color);
    }

    private void updateFontField() {
        Font f = this.outputOptions.getFont();
        this.fldFontFamily.setText(f.getFamily() + " " + f.getSize());
    }

    void store() {
        Controller.getDefault().updateOptions(this.outputOptions);
        OutputOptions.getDefault().assign(this.outputOptions);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                OutputOptions.getDefault().saveTo(NbPreferences.forModule(Controller.class));
            }
        });
    }

    void cancel() {
        if (this.previewInputOutput != null) {
            this.previewInputOutput.closeInputOutput();
        }
    }

    boolean valid() {
        return true;
    }

    private void initPreview() {
        this.previewInputOutput = this.initPreviewInputOutput();
        this.outputOptions = (OutputOptions)((Lookup.Provider)this.previewInputOutput).getLookup().lookup(OutputOptions.class);
        this.previewInputOutput.getOut().println("Standard Output");
        this.previewInputOutput.getErr().println("Error Output");
        OutputListenerImpl ol = new OutputListenerImpl();
        try {
            IOColorPrint.print((InputOutput)this.previewInputOutput, (CharSequence)"Standard Link", (OutputListener)ol, (boolean)false, null);
            this.previewInputOutput.getOut().println();
            IOColorPrint.print((InputOutput)this.previewInputOutput, (CharSequence)"Important Link", (OutputListener)ol, (boolean)true, null);
            this.previewInputOutput.getOut().print(" ");
        }
        catch (IOException ex) {
            ex.printStackTrace((PrintWriter)this.previewInputOutput.getErr());
        }
        this.previewInputOutput.getOut().close();
        this.previewInputOutput.getErr().close();
        this.outputOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OutputSettingsPanel.this.controller.changed();
                OutputSettingsPanel.this.updateControlsByModel();
            }
        });
    }

    private InputOutput initPreviewInputOutput() throws NullPointerException {
        IOContainer ioContainer = IOContainer.create((IOContainer.Provider)new PreviewIOProvider(this.previewPanel));
        InputOutput io = NbIOProvider.getDefault().getIO("Preview", false, new Action[0], ioContainer);
        return io;
    }

    private void updateControlsByModel() {
        this.updateFontField();
        this.spnFontSize.setValue(this.outputOptions.getFont().getSize());
        this.selectColor(this.cmbStandardColor, this.outputOptions.getColorStandard());
        this.selectColor(this.cmbErrorColor, this.outputOptions.getColorError());
        this.selectColor(this.cmbBackgroundColor, this.outputOptions.getColorBackground());
        this.selectColor(this.cmbLinkColor, this.outputOptions.getColorLink());
        this.selectColor(this.cmbImportantLinkColor, this.outputOptions.getColorLinkImportant());
        this.cmbLinkStyle.setSelectedItem(this.linkStyleModel.itemFor(this.outputOptions.getLinkStyle()));
        this.cmbLinkStyle.repaint();
    }

    private static class OutputListenerImpl
    implements OutputListener {
        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineAction(OutputEvent ev) {
        }

        public void outputLineCleared(OutputEvent ev) {
        }
    }
}

