/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2.options;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.netbeans.core.output2.Controller;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOColors;

public class OutputOptions {
    private static OutputOptions DEFAULT = null;
    private boolean initialized = false;
    private static final Logger LOG = Logger.getLogger(OutputOptions.class.getName());
    private static final String PREFIX = "output.settings.";
    public static final String PROP_FONT = "font";
    private static final String PROP_FONT_FAMILY = "font.family";
    private static final String PROP_FONT_SIZE = "font.size";
    private static final String PROP_FONT_STYLE = "font.style";
    public static final String PROP_COLOR_STANDARD = "color.standard";
    public static final String PROP_COLOR_ERROR = "color.error";
    public static final String PROP_COLOR_LINK = "color.link";
    public static final String PROP_COLOR_LINK_IMPORTANT = "color.link.important";
    public static final String PROP_COLOR_BACKGROUND = "color.backgorund";
    public static final String PROP_STYLE_LINK = "style.link";
    private static final String PROP_INITIALIZED = "initialized";
    private static final int MIN_FONT_SIZE = 3;
    private static Font defaultFont = null;
    private Font font = null;
    private Color colorStandard;
    private Color colorError;
    private Color colorLink;
    private Color colorLinkImportant;
    private Color colorBackground;
    private LinkStyle linkStyle = LinkStyle.UNDERLINE;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    private OutputOptions(boolean initFromDisk) {
        this.resetToDefault();
        if (!initFromDisk) {
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                OutputOptions.this.loadFrom(NbPreferences.forModule(Controller.class));
            }
        });
    }

    final void resetToDefault() {
        this.setDefaultFont();
        this.setDefaultColors();
        this.setLinkStyle(LinkStyle.UNDERLINE);
    }

    public void loadFrom(Preferences preferences) {
        assert (!EventQueue.isDispatchThread());
        final OutputOptions diskData = new OutputOptions(false);
        String fontFamily = preferences.get("output.settings.font.family", OutputOptions.getDefaultFont().getFamily());
        int fontSize = preferences.getInt("output.settings.font.size", OutputOptions.getDefaultFont().getSize());
        int fontStyle = preferences.getInt("output.settings.font.style", OutputOptions.getDefaultFont().getStyle());
        diskData.setFont(new Font(fontFamily, fontStyle, fontSize));
        int rgbStandard = preferences.getInt("output.settings.color.standard", OutputOptions.getDefaultColorStandard().getRGB());
        diskData.setColorStandard(new Color(rgbStandard));
        int rgbError = preferences.getInt("output.settings.color.error", OutputOptions.getDefaultColorError().getRGB());
        diskData.setColorError(new Color(rgbError));
        int rgbBackground = preferences.getInt("output.settings.color.backgorund", OutputOptions.getDefaultColorBackground().getRGB());
        diskData.setColorBackground(new Color(rgbBackground));
        int rgbLink = preferences.getInt("output.settings.color.link", OutputOptions.getDefaultColorLink().getRGB());
        diskData.setColorLink(new Color(rgbLink));
        int rgbLinkImportant = preferences.getInt("output.settings.color.link.important", OutputOptions.getDefaultColorLinkImportant().getRGB());
        String linkStyleStr = preferences.get("output.settings.style.link", "UNDERLINE");
        try {
            diskData.setLinkStyle(LinkStyle.valueOf(linkStyleStr));
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "Invalid link style {0}", linkStyleStr);
        }
        diskData.setColorLinkImportant(new Color(rgbLinkImportant));
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                OutputOptions.this.assign(diskData);
                OutputOptions outputOptions = OutputOptions.this;
                synchronized (outputOptions) {
                    OutputOptions.this.initialized = true;
                }
                OutputOptions.this.pcs.firePropertyChange(OutputOptions.PROP_INITIALIZED, false, true);
            }
        });
    }

    public void saveTo(Preferences preferences) {
        assert (!EventQueue.isDispatchThread());
        preferences.putInt("output.settings.color.standard", this.getColorStandard().getRGB());
        preferences.putInt("output.settings.color.error", this.getColorError().getRGB());
        preferences.putInt("output.settings.color.backgorund", this.getColorBackground().getRGB());
        preferences.putInt("output.settings.color.link", this.getColorLink().getRGB());
        preferences.putInt("output.settings.color.link.important", this.getColorLinkImportant().getRGB());
        preferences.putInt("output.settings.font.size", this.getFont().getSize());
        preferences.putInt("output.settings.font.style", this.getFont().getStyle());
        preferences.put("output.settings.font.family", this.getFont().getFamily());
        preferences.put("output.settings.style.link", this.getLinkStyle().name());
        try {
            preferences.flush();
        }
        catch (BackingStoreException ex) {
            LOG.log(Level.INFO, null, ex);
        }
    }

    private void setDefaultColors() {
        this.setColorStandard(OutputOptions.getDefaultColorStandard());
        this.setColorError(OutputOptions.getDefaultColorError());
        this.setColorLink(OutputOptions.getDefaultColorLink());
        this.setColorLinkImportant(OutputOptions.getDefaultColorLinkImportant());
        this.setColorBackground(OutputOptions.getDefaultColorBackground());
    }

    private void setDefaultFont() {
        this.setFont(OutputOptions.getDefaultFont());
    }

    public static Font getDefaultFont() {
        if (defaultFont == null) {
            Font f;
            int size = UIManager.getInt("uiFontSize");
            if (size < 3) {
                size = UIManager.getInt("customFontSize");
            }
            if (size < 3 && (f = (Font)UIManager.get("controlFont")) != null) {
                size = f.getSize();
            }
            if (size < 3) {
                size = 11;
            }
            defaultFont = new Font("Monospaced", 0, size);
        }
        return defaultFont;
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColorStandard() {
        return this.colorStandard;
    }

    public Color getColorError() {
        return this.colorError;
    }

    public Color getColorLink() {
        return this.colorLink;
    }

    public Color getColorLinkImportant() {
        return this.colorLinkImportant;
    }

    public Color getColorBackground() {
        return this.colorBackground;
    }

    public LinkStyle getLinkStyle() {
        return this.linkStyle;
    }

    public void setFont(Font font) {
        Font fontToSet;
        Font font2 = fontToSet = font == null ? OutputOptions.getDefaultFont() : font;
        if (!fontToSet.equals(this.font)) {
            Font oldFont = this.font;
            this.font = fontToSet;
            this.pcs.firePropertyChange(PROP_FONT, oldFont, fontToSet);
        }
    }

    public void setColorStandard(Color colorStandard) {
        Parameters.notNull((CharSequence)"colorStandard", (Object)colorStandard);
        if (!colorStandard.equals(this.colorStandard)) {
            Color oldColorStandard = this.colorStandard;
            this.colorStandard = colorStandard;
            this.pcs.firePropertyChange(PROP_COLOR_STANDARD, oldColorStandard, colorStandard);
        }
    }

    public void setColorError(Color colorError) {
        Parameters.notNull((CharSequence)"colorError", (Object)colorError);
        if (!colorError.equals(this.colorError)) {
            Color oldColorError = this.colorError;
            this.colorError = colorError;
            this.pcs.firePropertyChange(PROP_COLOR_ERROR, oldColorError, colorError);
        }
    }

    public void setColorLink(Color colorLink) {
        Parameters.notNull((CharSequence)"colorLink", (Object)colorLink);
        if (!colorLink.equals(this.colorLink)) {
            Color oldColorLink = this.colorLink;
            this.colorLink = colorLink;
            this.pcs.firePropertyChange(PROP_COLOR_LINK, oldColorLink, colorLink);
        }
    }

    public void setColorLinkImportant(Color colorLinkImportant) {
        Parameters.notNull((CharSequence)"colorLinkImportant", (Object)colorLinkImportant);
        if (!colorLinkImportant.equals(this.colorLinkImportant)) {
            Color oldColorLinkImportant = this.colorLinkImportant;
            this.colorLinkImportant = colorLinkImportant;
            this.pcs.firePropertyChange(PROP_COLOR_LINK_IMPORTANT, oldColorLinkImportant, colorLinkImportant);
        }
    }

    public void setColorBackground(Color colorBackground) {
        Parameters.notNull((CharSequence)"colorBackground", (Object)colorBackground);
        if (!colorBackground.equals(this.colorBackground)) {
            Color oldColorBackground = this.colorBackground;
            this.colorBackground = colorBackground;
            this.pcs.firePropertyChange(PROP_COLOR_BACKGROUND, oldColorBackground, colorBackground);
        }
    }

    public void setLinkStyle(LinkStyle linkStyle) {
        Parameters.notNull((CharSequence)"linkStyle", (Object)((Object)linkStyle));
        if (!linkStyle.equals((Object)this.linkStyle)) {
            LinkStyle oldLinkStyle = this.linkStyle;
            this.linkStyle = linkStyle;
            this.pcs.firePropertyChange(PROP_STYLE_LINK, (Object)oldLinkStyle, (Object)linkStyle);
        }
    }

    public static synchronized OutputOptions getDefault() {
        if (DEFAULT == null) {
            DEFAULT = new OutputOptions(true);
        }
        return DEFAULT;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public OutputOptions makeCopy() {
        final OutputOptions copy = new OutputOptions(false);
        copy.font = this.font;
        copy.colorStandard = this.colorStandard;
        copy.colorError = this.colorError;
        copy.colorBackground = this.colorBackground;
        copy.colorLink = this.colorLink;
        copy.colorLinkImportant = this.colorLinkImportant;
        copy.initialized = this.initialized;
        copy.linkStyle = this.linkStyle;
        if (!this.initialized) {
            PropertyChangeListener l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals(OutputOptions.PROP_INITIALIZED)) {
                        copy.assign(OutputOptions.this);
                        copy.initialized = true;
                        copy.pcs.firePropertyChange(OutputOptions.PROP_INITIALIZED, false, true);
                        OutputOptions.this.removePropertyChangeListener(this);
                    }
                }
            };
            this.addPropertyChangeListener(l);
        }
        return copy;
    }

    public void assign(OutputOptions outputOptions) {
        this.setFont(outputOptions.getFont());
        this.setColorStandard(outputOptions.getColorStandard());
        this.setColorError(outputOptions.getColorError());
        this.setColorLink(outputOptions.getColorLink());
        this.setColorLinkImportant(outputOptions.getColorLinkImportant());
        this.setColorBackground(outputOptions.getColorBackground());
        this.setLinkStyle(outputOptions.getLinkStyle());
    }

    static Color getDefaultColorStandard() {
        Color out = UIManager.getColor("nb.output.foreground");
        if (out == null && (out = UIManager.getColor("textText")) == null) {
            out = Color.BLACK;
        }
        return out;
    }

    static Color getDefaultColorBackground() {
        Color back = UIManager.getColor("nb.output.backgorund");
        if (back == null && (back = UIManager.getColor("text")) == null) {
            back = Color.WHITE;
        }
        return back;
    }

    static Color getDefaultColorError() {
        Color err = UIManager.getColor("nb.output.err.foreground");
        if (err == null) {
            err = LFCustoms.shiftColor((Color)Color.red);
        }
        return err;
    }

    static Color getDefaultColorLink() {
        Color hyperlink = UIManager.getColor("nb.output.link.foreground");
        if (hyperlink == null) {
            hyperlink = LFCustoms.shiftColor((Color)Color.blue);
        }
        return hyperlink;
    }

    static Color getDefaultColorLinkImportant() {
        Color hyperlinkImp = UIManager.getColor("nb.output.link.foreground.important");
        if (hyperlinkImp == null) {
            return OutputOptions.getDefaultColorLink();
        }
        return hyperlinkImp;
    }

    public Color getColorForType(IOColors.OutputType type) {
        switch (type) {
            case OUTPUT: {
                return this.getColorStandard();
            }
            case ERROR: {
                return this.getColorError();
            }
            case HYPERLINK: {
                return this.getColorLink();
            }
            case HYPERLINK_IMPORTANT: {
                return this.getColorLinkImportant();
            }
        }
        return this.getColorStandard();
    }

    public static enum LinkStyle {
        NONE,
        UNDERLINE;

    }
}

