/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.core.actions.project;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.spi.project.ProjectFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ImportProjectAction
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ImportProjectAction.class.getName());

    @Override
    public void actionPerformed(ActionEvent e) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FileChooserBuilder fcb = new FileChooserBuilder("ImportFrom");
                fcb.setDirectoriesOnly(true);
                fcb.setTitle("Open Project");
                fcb.setApproveText("Open");
                fcb.setFileHiding(true);
                fcb.setAccessibleDescription("Marks selected directory as VHDT Project and opens it");
                ProjectFactory pf = (ProjectFactory)Lookup.getDefault().lookup(ProjectFactory.class);
                ProjectManager pm = ProjectManager.getDefault();
                pm.clearNonProjectCache();
                OpenProjects op = OpenProjects.getDefault();
                JFileChooser jfc = fcb.createFileChooser();
                int value = jfc.showOpenDialog(WindowManager.getDefault().getMainWindow());
                if (value == 0) {
                    File toImport = jfc.getSelectedFile();
                    toImport = FileUtil.normalizeFile((File)toImport);
                    FileObject projectRoot = FileUtil.toFileObject((File)toImport);
                    try {
                        if (!pf.isProject(projectRoot)) {
                            projectRoot.createData(VHDTConstants.PROJECT_PROPERTIES.getName());
                            projectRoot.refresh();
                        }
                        Project project = pm.findProject(projectRoot);
                        Project[] array = new Project[]{project};
                        op.open(array, false);
                        Properties props = (Properties)project.getLookup().lookup(Properties.class);
                        File f = FileUtil.toFile((FileObject)projectRoot.getFileObject(VHDTConstants.PROJECT_PROPERTIES.getName()));
                        props.setProperty("project_name", project.getProjectDirectory().getPath());
                        props.store(new FileOutputStream(f), "VHDT Project Properties");
                        ProjectInformation info = ProjectUtils.getInformation((Project)project);
                        StatusDisplayer.getDefault().setStatusText("Project " + info.getDisplayName() + " imported.");
                        logger.info(NbBundle.getMessage(ImportProjectAction.class, (String)"LOG_INFO_ProjectImported"));
                    }
                    catch (Exception ee) {
                        StatusDisplayer.getDefault().setStatusText("Error while importing project.");
                        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Error while importing project. Please try again.", 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        logger.warning(NbBundle.getMessage(ImportProjectAction.class, (String)"LOG_SEVERE_ErrorWhileImportingProject"));
                        logger.warning(ee.getMessage());
                        Exceptions.printStackTrace((Throwable)ee);
                    }
                }
            }
        });
    }
}

