/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.core.actions.project;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services.VHDLProjectService;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Utilities;

public final class FindEntityAction
implements ActionListener {
    private static final Logger logger = Logger.getLogger(FindEntityAction.class.getName());

    @Override
    public void actionPerformed(ActionEvent e) {
        VHDLProjectService service = null;
        Project project = (Project)Utilities.actionsGlobalContext().lookup(Project.class);
        if (project != null) {
            service = (VHDLProjectService)project.getLookup().lookup(VHDLProjectService.class);
        } else {
            FileObject object = (FileObject)Utilities.actionsGlobalContext().lookup(FileObject.class);
            if (object != null && (project = FileOwnerQuery.getOwner((FileObject)object)) != null) {
                service = (VHDLProjectService)project.getLookup().lookup(VHDLProjectService.class);
            }
        }
        if (service != null) {
            ProjectInformation info = ProjectUtils.getInformation((Project)project);
            NotifyDescriptor.InputLine nd = new NotifyDescriptor.InputLine("Entity name:", "Find entity in " + info.getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                service.findAndOpenEntity(nd.getInputText());
            }
        } else {
            StatusDisplayer.getDefault().setStatusText("No project to find in.");
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"No project to find in. Choose/Open VHDL project.");
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            logger.info("No project to find in. Choose/Open VHDL project.");
        }
    }
}

