/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.core;

import com.jtattoo.plaf.aluminium.AluminiumLookAndFeel;
import com.jtattoo.plaf.graphite.GraphiteLookAndFeel;
import com.jtattoo.plaf.smart.SmartLookAndFeel;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.ModuleInstall;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class Installer
extends ModuleInstall {
    public void restored() {
        this.setLaF();
        this.addTemplatesToFavorites();
    }

    private void setLaF() {
        AluminiumLookAndFeel laf = null;
        String lafString = UIManager.getSystemLookAndFeelClassName();
        LAF preferred = LAF.valueOf(NbPreferences.forModule(Installer.class).get("LaF", "SYSTEM"));
        switch (preferred) {
            case METAL: {
                lafString = UIManager.getCrossPlatformLookAndFeelClassName();
                break;
            }
            case SYSTEM: {
                lafString = UIManager.getSystemLookAndFeelClassName();
                break;
            }
            case ALUMINIUM: {
                AluminiumLookAndFeel.setTheme((String)"Default");
                laf = new AluminiumLookAndFeel();
                break;
            }
            case GRAPHITE: {
                GraphiteLookAndFeel.setTheme((String)"Default");
                laf = new GraphiteLookAndFeel();
                break;
            }
            case GRAPHITE_BLUE: {
                GraphiteLookAndFeel.setTheme((String)"Blue");
                laf = new GraphiteLookAndFeel();
                break;
            }
            case SMART: {
                SmartLookAndFeel.setTheme((String)"Default");
                laf = new SmartLookAndFeel();
                break;
            }
            case SMART_GOLD: {
                SmartLookAndFeel.setTheme((String)"Gold");
                laf = new SmartLookAndFeel();
                break;
            }
            default: {
                SmartLookAndFeel.setTheme((String)"Default");
                laf = new SmartLookAndFeel();
            }
        }
        try {
            if (laf != null) {
                UIManager.setLookAndFeel((LookAndFeel)laf);
            } else {
                UIManager.setLookAndFeel(lafString);
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, NbBundle.getMessage(Installer.class, (String)"LOG_ERROR_LoadingLaFFailed"));
        }
    }

    private void addTemplatesToFavorites() {
        FileObject[] files;
        FileObject favoritesFolder = FileUtil.getConfigFile((String)"Favorites");
        File templates = InstalledFileLocator.getDefault().locate("TEMPLATES", null, false);
        templates = FileUtil.normalizeFile((File)templates);
        FileObject templatesShadow = null;
        for (FileObject file : files = favoritesFolder.getChildren()) {
            if (!file.getNameExt().equals("TEMPLATES.shadow")) continue;
            templatesShadow = file;
            break;
        }
        try {
            if (templatesShadow != null) {
                templatesShadow.delete();
            }
            templatesShadow = favoritesFolder.createData("TEMPLATES.shadow");
            templatesShadow.setAttribute("originalFile", (Object)Utilities.toURI((File)templates).toURL());
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public static enum LAF {
        METAL,
        SYSTEM,
        ALUMINIUM,
        GRAPHITE,
        GRAPHITE_BLUE,
        SMART,
        SMART_GOLD;

    }
}

