/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.core;

import cz.ctu.fit.mateju.vhdt.core.actions.project.ImportProjectAction;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.VHDTConstants;
import java.awt.EventQueue;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.sendopts.CommandException;
import org.netbeans.spi.project.ProjectFactory;
import org.netbeans.spi.sendopts.Env;
import org.netbeans.spi.sendopts.Option;
import org.netbeans.spi.sendopts.OptionProcessor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class CommandLineProcessor
extends OptionProcessor {
    private static final Logger logger = Logger.getLogger(CommandLineProcessor.class.getName());
    private static Option action = Option.withoutArgument((char)'d', (String)"dir");

    public Set<Option> getOptions() {
        return Collections.singleton(action);
    }

    protected void process(final Env env, Map<Option, String[]> values) throws CommandException {
        System.out.println("Running from command line...");
        System.out.println("Current directory = " + env.getCurrentDirectory());
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                OpenProjects op = OpenProjects.getDefault();
                op.close(op.getOpenProjects());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CommandLineProcessor.this.openCurrentDirAsAProject(env.getCurrentDirectory());
                    }
                });
            }
        });
    }

    private void openCurrentDirAsAProject(File file) {
        ProjectFactory pf = (ProjectFactory)Lookup.getDefault().lookup(ProjectFactory.class);
        ProjectManager pm = ProjectManager.getDefault();
        pm.clearNonProjectCache();
        final OpenProjects op = OpenProjects.getDefault();
        if (file != null) {
            File toImport = FileUtil.normalizeFile((File)file);
            FileObject projectRoot = FileUtil.toFileObject((File)toImport);
            try {
                if (!pf.isProject(projectRoot)) {
                    projectRoot.createData(VHDTConstants.PROJECT_PROPERTIES.getName());
                    projectRoot.refresh();
                }
                Project project = pm.findProject(projectRoot);
                final Project[] array = new Project[]{project};
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        op.open(array, false);
                    }
                });
                Properties props = (Properties)project.getLookup().lookup(Properties.class);
                File f = FileUtil.toFile((FileObject)projectRoot.getFileObject(VHDTConstants.PROJECT_PROPERTIES.getName()));
                props.setProperty("project_name", project.getProjectDirectory().getPath());
                props.store(new FileOutputStream(f), "VHDT Project Properties");
                ProjectInformation info = ProjectUtils.getInformation((Project)project);
                StatusDisplayer.getDefault().setStatusText("Project " + info.getDisplayName() + " imported.");
                logger.info(NbBundle.getMessage(ImportProjectAction.class, (String)"LOG_INFO_ProjectImported"));
            }
            catch (Exception ee) {
                StatusDisplayer.getDefault().setStatusText("Error while importing project.");
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"Error while importing project. Please try again.", 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                logger.warning(NbBundle.getMessage(ImportProjectAction.class, (String)"LOG_SEVERE_ErrorWhileImportingProject"));
                logger.warning(ee.getMessage());
                Exceptions.printStackTrace((Throwable)ee);
            }
        }
    }
}

