/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.view;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.Bidi;
import org.netbeans.modules.editor.lib2.view.ViewUtils;

final class TextLayoutUtils {
    private TextLayoutUtils() {
    }

    public static float getHeight(TextLayout textLayout) {
        float height = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return (float)Math.ceil(height);
    }

    public static float getWidth(TextLayout textLayout, String textLayoutText, Font font) {
        float width;
        int tlLen = textLayoutText.length();
        if (!font.isItalic() || tlLen == 0 || Character.isWhitespace(textLayoutText.charAt(tlLen - 1)) || Bidi.requiresBidi(textLayoutText.toCharArray(), 0, textLayoutText.length())) {
            width = textLayout.getAdvance();
        } else {
            Rectangle pixelBounds = textLayout.getPixelBounds(null, 0.0f, 0.0f);
            width = (float)pixelBounds.getMaxX();
        }
        width = (float)Math.ceil(width);
        return width;
    }

    public static Shape getRealAlloc(TextLayout textLayout, Rectangle2D textLayoutRect, TextHitInfo startHit, TextHitInfo endHit) {
        textLayoutRect = new Rectangle2D.Double(textLayoutRect.getX(), textLayoutRect.getY(), textLayoutRect.getWidth() + 2.0, textLayoutRect.getHeight());
        Rectangle2D.Double zeroBasedRect = ViewUtils.shape2Bounds(textLayoutRect);
        zeroBasedRect.x = 0.0;
        zeroBasedRect.y = 0.0;
        Shape ret = textLayout.getVisualHighlightShape(startHit, endHit, zeroBasedRect);
        AffineTransform transform = AffineTransform.getTranslateInstance(textLayoutRect.getX(), textLayoutRect.getY());
        ret = transform.createTransformedShape(ret);
        return ret;
    }

    public static String toStringShort(TextLayout textLayout) {
        return "[" + textLayout.getCharacterCount() + "]W=" + textLayout.getAdvance();
    }

    public static String toString(TextLayout textLayout) {
        return TextLayoutUtils.toStringShort(textLayout) + "; " + textLayout.toString();
    }
}

