/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.problems;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class BrokenReferencesModel
extends AbstractListModel
implements PropertyChangeListener,
ChangeListener {
    private static final Logger LOG = Logger.getLogger(BrokenReferencesModel.class.getName());
    private final Context ctx;
    private final boolean global;
    private final Object lock = new Object();
    private final Map<ProjectProblemsProvider, PropertyChangeListener> providers;
    private final List<ProblemReference> problems;

    BrokenReferencesModel(@NonNull Context ctx, boolean global) {
        assert (ctx != null);
        this.ctx = ctx;
        this.global = global;
        this.problems = new ArrayList<ProblemReference>();
        this.providers = new WeakHashMap<ProjectProblemsProvider, PropertyChangeListener>();
        this.refresh();
        ctx.addChangeListener(this);
    }

    BrokenReferencesModel(@NonNull Project project) {
        this(new Context(), false);
        this.ctx.offer(project);
    }

    @Override
    public Object getElementAt(int index) {
        return this.getOneReference(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.problems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh() {
        int size;
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<ProjectProblemsProvider, PropertyChangeListener>> it = this.providers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ProjectProblemsProvider, PropertyChangeListener> e = it.next();
                e.getKey().removePropertyChangeListener(e.getValue());
                it.remove();
            }
            LinkedHashSet<ProblemReference> all = new LinkedHashSet<ProblemReference>();
            for (Project bprj : this.ctx.getBrokenProjects()) {
                ProjectProblemsProvider ppp = (ProjectProblemsProvider)bprj.getLookup().lookup(ProjectProblemsProvider.class);
                if (ppp == null) continue;
                PropertyChangeListener l = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ppp);
                ppp.addPropertyChangeListener(l);
                this.providers.put(ppp, l);
                for (ProjectProblemsProvider.ProjectProblem problem : ppp.getProblems()) {
                    all.add(new ProblemReference(problem, bprj, this.global));
                }
            }
            BrokenReferencesModel.updateReferencesList(this.problems, all);
            size = this.getSize();
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                BrokenReferencesModel.this.fireContentsChanged(BrokenReferencesModel.this, 0, size);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProblemReference getOneReference(int index) {
        Object object = this.lock;
        synchronized (object) {
            assert (index >= 0 && index < this.problems.size());
            return this.problems.get(index);
        }
    }

    private static void updateReferencesList(List<ProblemReference> oldBroken, Set<ProblemReference> newBroken) {
        LOG.log(Level.FINE, "References updated from {0} to {1}", new Object[]{oldBroken, newBroken});
        for (ProblemReference or : oldBroken) {
            or.resolved = !newBroken.contains(or);
        }
        for (ProblemReference or : newBroken) {
            if (oldBroken.contains(or)) continue;
            oldBroken.add(or);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("problems".equals(evt.getPropertyName())) {
            this.refresh();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refresh();
    }

    static final class Context {
        private final List<Project> toResolve = Collections.synchronizedList(new LinkedList());
        private final ChangeSupport support = new ChangeSupport((Object)this);

        public void offer(@NonNull Project broken) {
            assert (broken != null);
            if (broken.getLookup().lookup(ProjectProblemsProvider.class) != null) {
                this.toResolve.add(broken);
                this.support.fireChange();
            }
        }

        public boolean isEmpty() {
            return this.toResolve.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Project[] getBrokenProjects() {
            List<Project> list = this.toResolve;
            synchronized (list) {
                return this.toResolve.toArray(new Project[this.toResolve.size()]);
            }
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            assert (listener != null);
            this.support.addChangeListener(listener);
        }

        public void removeChangeListener(@NonNull ChangeListener listener) {
            assert (listener != null);
            this.support.removeChangeListener(listener);
        }
    }

    static final class ProblemReference {
        private final boolean global;
        private final Project project;
        final ProjectProblemsProvider.ProjectProblem problem;
        volatile boolean resolved;

        ProblemReference(@NonNull ProjectProblemsProvider.ProjectProblem problem, @NonNull Project project, boolean global) {
            assert (problem != null);
            this.problem = problem;
            this.project = project;
            this.global = global;
        }

        String getDisplayName() {
            String message;
            String displayName = this.problem.getDisplayName();
            if (this.global) {
                String projectName = ProjectUtils.getInformation((Project)this.project).getDisplayName();
                message = NbBundle.getMessage(BrokenReferencesModel.class, (String)"FMT_ProblemInProject", (Object)projectName, (Object)displayName);
            } else {
                message = displayName;
            }
            return message;
        }

        @NonNull
        public String toString() {
            return String.format("Problem: %s %s", this.problem, this.resolved ? "resolved" : "unresolved");
        }

        public int hashCode() {
            int hash = 17;
            hash = 31 * hash + this.problem.hashCode();
            hash = 31 * hash + this.project.hashCode();
            return hash;
        }

        public boolean equals(Object other) {
            if (!(other instanceof ProblemReference)) {
                return false;
            }
            ProblemReference otherRef = (ProblemReference)other;
            return this.problem.equals((Object)otherRef.problem) && this.project.equals(otherRef.project);
        }
    }
}

