/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.Toolkit;
import java.io.CharConversionException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.modules.project.ui.actions.ShortcutManager;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.awt.Actions;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class ProjectAction
extends LookupSensitiveAction
implements ContextAwareAction {
    private String command;
    private ProjectActionPerformer performer;
    private final String namePattern;
    private final String popupPattern;

    public ProjectAction(String command, String namePattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, namePattern, icon, lookup);
    }

    public ProjectAction(String command, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        this(command, null, namePattern, popupPattern, icon, lookup);
    }

    public ProjectAction(ProjectActionPerformer performer, String namePattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, namePattern, icon, lookup);
    }

    private ProjectAction(ProjectActionPerformer performer, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        this(null, performer, namePattern, popupPattern, icon, lookup);
    }

    private ProjectAction(String command, ProjectActionPerformer performer, String namePattern, String popupPattern, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = command;
        if (command != null) {
            ShortcutManager.INSTANCE.registerAction(command, this);
        }
        this.performer = performer;
        this.namePattern = namePattern;
        this.popupPattern = popupPattern;
        String presenterName = ActionsUtil.formatName(this.getNamePattern(), 0, "");
        this.setDisplayName(presenterName);
        this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
    }

    @Override
    public final void putValue(String key, Object value) {
        super.putValue(key, value);
        if ("AcceleratorKey".equals(key)) {
            ShortcutManager.INSTANCE.registerShortcut(this.command, value);
        }
    }

    @Override
    protected void actionPerformed(Lookup context) {
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, this.command);
        if (this.command != null && projects.length > 0) {
            ProjectAction.runSequentially(new LinkedList<Project>(Arrays.asList(projects)), this, this.command);
        } else if (this.performer != null && projects.length == 1) {
            this.performer.perform(projects[0]);
        }
    }

    static void runSequentially(final Queue<Project> queue, final LookupSensitiveAction a, final String command) {
        Project p = queue.remove();
        final ActionProvider ap = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
        if (ap == null) {
            return;
        }
        if (!Arrays.asList(ap.getSupportedActions()).contains(command)) {
            Toolkit.getDefaultToolkit().beep();
            a.resultChanged(null);
            return;
        }
        LogRecord r = new LogRecord(Level.FINE, "PROJECT_ACTION");
        r.setResourceBundle(NbBundle.getBundle(ProjectAction.class));
        r.setParameters(new Object[]{a.getClass().getName(), p.getClass().getName(), a.getValue("Name")});
        r.setLoggerName(UILOG.getName());
        UILOG.log(r);
        Mutex.EVENT.writeAccess(new Runnable(){

            @Override
            public void run() {
                final AtomicBoolean started = new AtomicBoolean();
                ap.invokeAction(command, Lookups.singleton((Object)new ActionProgress(){

                    protected void started() {
                        started.set(true);
                    }

                    public void finished(boolean success) {
                        if (success && !queue.isEmpty()) {
                            ProjectAction.runSequentially(queue, a, command);
                        } else {
                            a.resultChanged(null);
                        }
                    }
                }));
                if (started.get()) {
                    a.setEnabled(false);
                } else if (!queue.isEmpty()) {
                    ProjectAction.runSequentially(queue, a, command);
                }
            }
        });
    }

    @Override
    protected void refresh(final Lookup context, boolean immediate) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                String popupName;
                Project[] projects = ActionsUtil.getProjectsFromLookup(context, ProjectAction.this.command);
                final boolean enable = ProjectAction.this.command != null ? projects.length > 0 : (ProjectAction.this.performer != null && projects.length == 1 ? ProjectAction.this.performer.enable(projects[0]) : false);
                final String presenterName = ActionsUtil.formatProjectSensitiveName(ProjectAction.this.namePattern, projects);
                if (ProjectAction.this.popupPattern != null) {
                    ProjectConfigurationProvider mainProvider;
                    ProjectConfigurationProvider actualProvider;
                    Project main;
                    String n = ActionsUtil.formatProjectSensitiveName(ProjectAction.this.popupPattern, projects);
                    if (!(ProjectAction.this.command == null || ProjectAction.this.command.equals("delete") || ProjectAction.this.command.equals("rename") || ProjectAction.this.command.equals("move") || ProjectAction.this.command.equals("copy") || projects.length != 1 || (main = OpenProjectList.getDefault().getMainProject()) == null || main == projects[0] || (actualProvider = (ProjectConfigurationProvider)projects[0].getLookup().lookup(ProjectConfigurationProvider.class)) == null || (mainProvider = (ProjectConfigurationProvider)main.getLookup().lookup(ProjectConfigurationProvider.class)) == null)) {
                        String labelActual;
                        ProjectConfiguration actualConfig = actualProvider.getActiveConfiguration();
                        ProjectConfiguration mainConfig = mainProvider.getActiveConfiguration();
                        if (actualConfig != null && mainConfig != null && !(labelActual = actualConfig.getDisplayName()).equals(mainConfig.getDisplayName())) {
                            try {
                                if (!n.startsWith("<html>")) {
                                    n = "<html>" + XMLUtil.toElementContent((String)n);
                                }
                                n = n + " <i><font color='!controlShadow'>@" + XMLUtil.toElementContent((String)labelActual);
                            }
                            catch (CharConversionException x) {
                                // empty catch block
                            }
                        }
                    }
                    popupName = n;
                } else {
                    popupName = null;
                }
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        ProjectAction.this.setEnabled(enable);
                        ProjectAction.this.putValue("menuText", presenterName);
                        ProjectAction.this.putValue("popupText", popupName);
                        ProjectAction.this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
                    }
                });
            }
        };
        if (immediate) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    protected final String getCommand() {
        return this.command;
    }

    protected final String getNamePattern() {
        return this.namePattern;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        ProjectAction a = new ProjectAction(this.command, this.performer, this.namePattern, this.popupPattern, (Icon)this.getValue("SmallIcon"), actionContext);
        a.putValue("hideWhenDisabled", this.getValue("hideWhenDisabled"));
        return a;
    }
}

