/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.NewFileWizard;
import org.netbeans.modules.project.ui.NoProjectNew;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.ProjectUtilities;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class NewFile
extends ProjectAction
implements PropertyChangeListener,
Presenter.Popup {
    private static final RequestProcessor RP = new RequestProcessor(NewFile.class);
    private static final RequestProcessor INSTANTIATE_RP = new RequestProcessor(NewFile.class.getName() + ".INSTANTIATE_RP", 5);
    private static final Logger LOG = Logger.getLogger(NewFile.class.getName());
    private JMenu subMenu;
    private static final String TEMPLATE_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.Template";
    private static final String IN_PROJECT_PROPERTY = "org.netbeans.modules.project.ui.actions.NewFile.InProject";

    public NewFile() {
        this((Lookup)null);
    }

    public NewFile(Lookup context) {
        super((String)null, Bundle.LBL_NewFileAction_Name(), null, context);
        this.putValue("iconBase", "org/netbeans/modules/project/ui/resources/newFile.png");
        this.putValue("ShortDescription", Bundle.LBL_NewFileAction_Tooltip());
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
        this.refresh(this.getLookup(), true);
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                NewFile.this.setEnabled(OpenProjectList.getDefault().getOpenProjects().length > 0);
                NewFile.this.setDisplayName(Bundle.LBL_NewFileAction_Name());
            }
        });
    }

    @Override
    public JMenuItem getPopupPresenter() {
        JMenuItem menu = new JMenuItem(this);
        menu.setIcon(null);
        Mnemonics.setLocalizedText((AbstractButton)menu, (String)((String)this.getValue("Name")));
        return menu;
    }

    @Override
    protected void actionPerformed(Lookup context) {
        this.doPerform(context, null, true);
    }

    private void doPerform(Lookup context, final DataObject template, boolean inProject) {
        if (context == null) {
            context = this.getLookup();
        }
        if (!inProject) {
            NoProjectNew.showDialog(template, this.preselectedFolder(context));
            return;
        }
        if (OpenProjectList.getDefault().getOpenProjects().length == 0) {
            return;
        }
        final NewFileWizard wd = new NewFileWizard(this.preselectedProject(context));
        DataFolder preselectedFolder = this.preselectedFolder(context);
        if (preselectedFolder != null) {
            wd.setTargetFolder(preselectedFolder);
        }
        INSTANTIATE_RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Set resultSet;
                    Set set = resultSet = template == null ? wd.instantiate() : wd.instantiate(template);
                    if (resultSet == null || resultSet.isEmpty()) {
                        return;
                    }
                    for (Object obj : resultSet) {
                        DataObject newDO = null;
                        if (obj instanceof DataObject) {
                            newDO = (DataObject)obj;
                        } else if (obj instanceof FileObject) {
                            try {
                                newDO = DataObject.find((FileObject)((FileObject)obj));
                            }
                            catch (DataObjectNotFoundException x) {
                                assert (false) : obj;
                            }
                        } else assert (false) : obj;
                        if (newDO == null) continue;
                        ProjectUtilities.openAndSelectNewObject(newDO);
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify(1, (Throwable)e);
                }
                FileObject foTemplate = Templates.getTemplate((WizardDescriptor)wd);
                OpenProjectList.getDefault().updateTemplatesLRU(foTemplate);
            }
        });
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new NewFile(actionContext);
    }

    public JMenuItem getSubmenuPopupPresenter() {
        if (this.subMenu == null) {
            this.subMenu = new JMenu(Bundle.LBL_NewFileAction_PopupName());
        }
        return this.subMenu;
    }

    protected void fillSubMenu() {
        Project[] projects = ActionsUtil.getProjectsFromLookup(this.getLookup(), null);
        if (projects != null && projects.length > 0) {
            this.fillSubMenu(this.subMenu, projects[0]);
        } else {
            this.fillNonProjectSubMenu(this.subMenu);
        }
    }

    private Project preselectedProject(Lookup context) {
        Project preselectedProject = null;
        Project[] projects = ActionsUtil.getProjectsFromLookup(context, null);
        if (projects.length > 0) {
            preselectedProject = projects[0];
        }
        if (preselectedProject == null && (preselectedProject = OpenProjectList.getDefault().getMainProject()) == null && OpenProjectList.getDefault().getOpenProjects().length > 0) {
            preselectedProject = OpenProjectList.getDefault().getOpenProjects()[0];
        }
        if (preselectedProject == null) assert (false) : "Action should be disabled";
        return preselectedProject;
    }

    private DataFolder preselectedFolder(Lookup context) {
        DataObject dobj;
        DataFolder preselectedFolder = null;
        preselectedFolder = (DataFolder)context.lookup(DataFolder.class);
        if (preselectedFolder == null && (dobj = (DataObject)context.lookup(DataObject.class)) != null) {
            preselectedFolder = dobj.getFolder();
        }
        LOG.log(Level.FINE, "#210919: found preselected folder {0} for {1}", new Object[]{preselectedFolder, context});
        return preselectedFolder;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.refresh(Lookup.EMPTY, false);
    }

    private void fillSubMenu(final JMenu menuItem, final Project project) {
        menuItem.removeAll();
        JMenuItem wait = new JMenuItem(Bundle.NewFile_please_wait());
        wait.setEnabled(false);
        menuItem.add(wait);
        RP.post(new Runnable(){

            @Override
            public void run() {
                final List<OpenProjectList.TemplateItem> items = OpenProjectList.prepareTemplates(project, NewFile.this.getLookup());
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        menuItem.removeAll();
                        PopupListener menuListener = new PopupListener();
                        for (OpenProjectList.TemplateItem i : items) {
                            JMenuItem item = new JMenuItem(Bundle.LBL_NewFileAction_Template_PopupName(i.displayName), i.icon);
                            item.addActionListener(menuListener);
                            item.putClientProperty(NewFile.TEMPLATE_PROPERTY, i.template);
                            menuItem.add(item);
                        }
                        if (!items.isEmpty()) {
                            menuItem.add(new JPopupMenu.Separator());
                        }
                        JMenuItem fileItem = new JMenuItem(Bundle.LBL_NewFileAction_File_PopupName(), (Icon)NewFile.this.getValue("SmallIcon"));
                        fileItem.addActionListener(menuListener);
                        fileItem.putClientProperty(NewFile.TEMPLATE_PROPERTY, null);
                        menuItem.add(fileItem);
                        menuItem.getPopupMenu().pack();
                    }
                });
            }
        });
    }

    private void fillNonProjectSubMenu(JMenu menuItem) {
        FileObject pf;
        menuItem.removeAll();
        PopupListener menuListener = new PopupListener();
        DataFolder preselectedFolder = this.preselectedFolder(this.getLookup());
        boolean canWrite = preselectedFolder == null ? false : (pf = preselectedFolder.getPrimaryFile()) != null && pf.canWrite();
        DataObject[] templates = NoProjectNew.getTemplates();
        for (int i = 0; i < templates.length; ++i) {
            Node n = templates[i].getNodeDelegate();
            JMenuItem item = new JMenuItem(Bundle.LBL_NewFileAction_Template_PopupName(n.getDisplayName()), new ImageIcon(n.getIcon(1)));
            item.addActionListener(menuListener);
            item.putClientProperty(TEMPLATE_PROPERTY, templates[i]);
            item.putClientProperty(IN_PROJECT_PROPERTY, Boolean.FALSE);
            item.setEnabled(canWrite);
            menuItem.add(item);
        }
    }

    private class PopupListener
    implements ActionListener {
        private PopupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem source = (JMenuItem)e.getSource();
            Boolean inProject = (Boolean)source.getClientProperty(NewFile.IN_PROJECT_PROPERTY);
            DataObject template = (DataObject)source.getClientProperty(NewFile.TEMPLATE_PROPERTY);
            if (inProject != null && inProject == Boolean.FALSE) {
                NewFile.this.doPerform(null, template, false);
            } else {
                NewFile.this.doPerform(null, template, true);
            }
        }
    }

    public static final class WithSubMenu
    extends NewFile {
        public WithSubMenu() {
        }

        private WithSubMenu(Lookup actionContext) {
            super(actionContext);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            return new DynaMenu(Bundle.LBL_NewFileAction_PopupName());
        }

        @Override
        public Action createContextAwareInstance(Lookup actionContext) {
            return new WithSubMenu(actionContext);
        }

        private final class DynaMenu
        extends JMenu
        implements DynamicMenuContent {
            public DynaMenu(String a) {
                super(a);
            }

            public JComponent[] getMenuPresenters() {
                JMenuItem jc = WithSubMenu.this.getSubmenuPopupPresenter();
                WithSubMenu.this.fillSubMenu();
                return new JComponent[]{jc};
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                JMenuItem jc = WithSubMenu.this.getSubmenuPopupPresenter();
                WithSubMenu.this.fillSubMenu();
                return new JComponent[]{jc};
            }
        }
    }
}

