/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.swing.undo.UndoableEdit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.EditorPackageAccessor;
import org.netbeans.modules.editor.lib2.document.DocumentSpiPackageAccessor;
import org.netbeans.modules.editor.lib2.document.ModRootElement;
import org.netbeans.spi.editor.document.OnSaveTask;

public final class BeforeSaveTasks {
    private static final Logger LOG = Logger.getLogger(BeforeSaveTasks.class.getName());
    private final BaseDocument doc;

    public static synchronized BeforeSaveTasks get(BaseDocument doc) {
        BeforeSaveTasks beforeSaveTasks = (BeforeSaveTasks)doc.getProperty(BeforeSaveTasks.class);
        if (beforeSaveTasks == null) {
            beforeSaveTasks = new BeforeSaveTasks(doc);
            doc.putProperty(BeforeSaveTasks.class, beforeSaveTasks);
        }
        return beforeSaveTasks;
    }

    private BeforeSaveTasks(BaseDocument doc) {
        this.doc = doc;
        Runnable beforeSaveRunnable = (Runnable)doc.getProperty("beforeSaveRunnable");
        if (beforeSaveRunnable != null) {
            throw new IllegalStateException("\"beforeSaveRunnable\" property of document " + doc + " is already occupied by " + beforeSaveRunnable);
        }
        beforeSaveRunnable = new Runnable(){

            @Override
            public void run() {
                BeforeSaveTasks.this.runTasks();
            }
        };
        doc.putProperty("beforeSaveRunnable", beforeSaveRunnable);
    }

    void runTasks() {
        String mimeType = DocumentUtilities.getMimeType((Document)this.doc);
        Collection factories = MimeLookup.getLookup((String)mimeType).lookupAll(OnSaveTask.Factory.class);
        OnSaveTask.Context context = DocumentSpiPackageAccessor.get().createContext((Document)this.doc);
        ArrayList<OnSaveTask> tasks = new ArrayList<OnSaveTask>(factories.size());
        for (OnSaveTask.Factory factory : factories) {
            OnSaveTask task = factory.createTask(context);
            if (task == null) continue;
            tasks.add(task);
        }
        if (tasks.size() > 0) {
            new TaskRunnable(this.doc, tasks, context).run();
        }
    }

    private static final class TaskRunnable
    implements Runnable {
        final BaseDocument doc;
        final List<OnSaveTask> tasks;
        final OnSaveTask.Context context;
        int lockedTaskIndex;

        public TaskRunnable(BaseDocument doc, List<OnSaveTask> tasks, OnSaveTask.Context context) {
            this.doc = doc;
            this.tasks = tasks;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.lockedTaskIndex < this.tasks.size()) {
                OnSaveTask task = this.tasks.get(this.lockedTaskIndex++);
                task.runLocked((Runnable)this);
            } else {
                try {
                    this.doc.runAtomicAsUser(new Runnable(){

                        @Override
                        public void run() {
                            UndoableEdit atomicEdit = EditorPackageAccessor.get().BaseDocument_markAtomicEditsNonSignificant(TaskRunnable.this.doc);
                            DocumentSpiPackageAccessor.get().setUndoEdit(TaskRunnable.this.context, atomicEdit);
                            try {
                                for (int i = 0; i < TaskRunnable.this.tasks.size(); ++i) {
                                    OnSaveTask task = TaskRunnable.this.tasks.get(i);
                                    DocumentSpiPackageAccessor.get().setTaskStarted(TaskRunnable.this.context, true);
                                    task.performTask();
                                }
                                ModRootElement modRootElement = ModRootElement.get((Document)TaskRunnable.this.doc);
                                if (modRootElement != null) {
                                    modRootElement.resetMods(atomicEdit);
                                }
                            }
                            catch (Exception e) {
                                LOG.log(Level.WARNING, "Exception thrown in before-save tasks", e);
                            }
                        }
                    });
                }
                finally {
                    EditorPackageAccessor.get().BaseDocument_clearAtomicEdits(this.doc);
                }
            }
        }
    }
}

