/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.windows.TopComponent;

public final class UI {
    private static Stack<Long> ourTimes = new Stack();
    public static final int TINY_SIZE = 2;
    public static final int SMALL_SIZE = 3;
    public static final int MEDIUM_SIZE = 5;
    public static final int LARGE_SIZE = 8;
    public static final int HUGE_SIZE = 13;
    private static final double MILLIS = 1000.0;
    public static final String UH = System.getProperty("user.home");
    public static final String LS = System.getProperty("line.separator");
    public static final String FS = System.getProperty("file.separator");
    private static final Border CORNER_BORDER = new CornerBorder();
    private static final boolean ENABLE_OUT = System.getProperty("org.netbeans.modules.out") != null;
    private static final boolean ENABLE_LOG = System.getProperty("org.netbeans.modules.log") != null;
    private static final boolean ENABLE_TIM = System.getProperty("org.netbeans.modules.tim") != null;

    private UI() {
    }

    public static boolean isAlt(int modifiers) {
        return UI.isModifier(modifiers, 8);
    }

    public static boolean isShift(int modifiers) {
        return UI.isModifier(modifiers, 1);
    }

    public static boolean isCtrl(int modifiers) {
        return UI.isModifier(modifiers, 2) || UI.isModifier(modifiers, 4);
    }

    private static boolean isModifier(int modifiers, int mask) {
        return (modifiers & mask) != 0;
    }

    public static MyComboBox createComboBox(Object[] items) {
        return new MyComboBox(items);
    }

    public static JLabel createLabel(String message) {
        JLabel label = new JLabel();
        Mnemonics.setLocalizedText((JLabel)label, (String)message);
        return label;
    }

    public static JRadioButton createRadioButton(String text, String toolTip) {
        JRadioButton button = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)button, (String)text);
        button.setText(UI.cutMnemonicAndAmpersand(text));
        button.setToolTipText(toolTip);
        return button;
    }

    public static JButton createButton(Action action) {
        return (JButton)UI.createAbstractButton(new JButton(), action);
    }

    public static JCheckBox createCheckBox(Action action) {
        return (JCheckBox)UI.createAbstractButton(new JCheckBox(), action);
    }

    public static JToggleButton createToggleButton(Action action) {
        return (JToggleButton)UI.createAbstractButton(new JToggleButton(), action);
    }

    public static void setItems(JComboBox comboBox, Object[] items) {
        Object selected = comboBox.getSelectedItem();
        comboBox.removeAllItems();
        for (int i = 0; i < items.length; ++i) {
            comboBox.insertItemAt(items[i], i);
        }
        if (items.length > 0) {
            comboBox.setSelectedIndex(0);
        }
        if (selected != null) {
            comboBox.setSelectedItem(selected);
        }
    }

    public static JPanel createSeparator(String message) {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.insets = new Insets(8, 0, 8, 0);
        panel.add((Component)UI.createLabel(message), c);
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(8, 8, 8, 0);
        panel.add((Component)new JSeparator(), c);
        return panel;
    }

    private static AbstractButton createAbstractButton(AbstractButton button, Action action) {
        button.setAction(action);
        UI.mnemonicAndToolTip(button, (String)action.getValue("ShortDescription"));
        return button;
    }

    private static void mnemonicAndToolTip(AbstractButton button, String toolTip) {
        String text = button.getText();
        if (text == null) {
            Mnemonics.setLocalizedText((AbstractButton)button, (String)toolTip);
            button.setText(null);
        } else {
            Mnemonics.setLocalizedText((AbstractButton)button, (String)text);
            button.setText(UI.cutMnemonicAndAmpersand(text));
        }
        button.setToolTipText(UI.cutMnemonicAndAmpersand(toolTip));
    }

    private static String cutMnemonicAndAmpersand(String value) {
        if (value == null) {
            return null;
        }
        int k = value.lastIndexOf(" // ");
        if (k != -1) {
            value = value.substring(0, k);
        }
        if ((k = value.indexOf("&")) == -1) {
            return value;
        }
        return value.substring(0, k) + value.substring(k + 1);
    }

    public static JTextArea createTextArea(int columns, String message) {
        JTextArea text = new JTextArea(message);
        text.setBackground(null);
        text.setEditable(false);
        text.setColumns(columns);
        text.setLineWrap(true);
        text.setWrapStyleWord(true);
        return text;
    }

    public static void a11y(Component component, String a11y) {
        UI.a11y(component, a11y, a11y);
    }

    public static void a11y(Component component, String name, String description) {
        if (name != null) {
            component.getAccessibleContext().setAccessibleName(name);
        }
        if (description != null) {
            component.getAccessibleContext().setAccessibleDescription(description);
        }
    }

    public static String i18n(Class clazz, String key) {
        if (key == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)key);
    }

    public static String i18n(Class clazz, String key, String param) {
        if (key == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)key, (Object)param);
    }

    public static String i18n(Class clazz, String key, String param1, String param2) {
        if (key == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)key, (Object)param1, (Object)param2);
    }

    public static String i18n(Class clazz, String key, String param1, String param2, String param3) {
        if (key == null) {
            return null;
        }
        return NbBundle.getMessage((Class)clazz, (String)key, (Object)param1, (Object)param2, (Object)param3);
    }

    public static boolean printWarning(String message) {
        NotifyDescriptor.Confirmation confirm = new NotifyDescriptor.Confirmation((Object)message, 0, 2);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)confirm);
        return confirm.getValue() == NotifyDescriptor.YES_OPTION;
    }

    public static boolean printConfirmation(String message) {
        return NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)message, 0)));
    }

    public static void printInformation(String message) {
        UI.print(message, 1);
    }

    public static void printError(String message) {
        UI.print(message, 0);
    }

    public static void printError(Exception exception) {
        UI.print(exception.getMessage(), 0);
    }

    private static void print(String message, int type) {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, type));
    }

    public static ImageIcon icon(Class clazz, String name) {
        if (name == null) {
            return null;
        }
        return new ImageIcon(clazz.getResource("image/" + name + ".gif"));
    }

    public static Node getSelectedNode() {
        Node[] nodes = UI.getSelectedNodes();
        if (nodes == null) {
            return null;
        }
        return nodes[0];
    }

    public static Node[] getSelectedNodes() {
        TopComponent top = UI.getActiveTopComponent();
        if (top == null) {
            return null;
        }
        Node[] nodes = top.getActivatedNodes();
        if (nodes == null || nodes.length == 0) {
            return null;
        }
        return nodes;
    }

    public static TopComponent getActiveTopComponent() {
        return TopComponent.getRegistry().getActivated();
    }

    public static void setWidth(JComponent component, int width) {
        UI.setSize(component, new Dimension(width, component.getPreferredSize().height));
    }

    public static void setHeight(JComponent component, int height) {
        UI.setSize(component, new Dimension(component.getPreferredSize().width, height));
    }

    public static void setSize(JComponent component, Dimension dimension) {
        component.setMinimumSize(dimension);
        component.setPreferredSize(dimension);
    }

    public static void setSize(JComponent component, int width, int height) {
        UI.setSize(component, new Dimension(width, height));
    }

    public static int getInt(Object value) {
        try {
            return Integer.parseInt(value.toString());
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static double getDouble(Object value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (NumberFormatException e) {
            return -1.0;
        }
    }

    public static int round(double value) {
        return (int)Math.ceil(value);
    }

    public static String replace(String source, String searchFor, String replaceWith) {
        if (source == null) {
            return null;
        }
        if (searchFor == null || searchFor.length() == 0) {
            return null;
        }
        int k = 0;
        int found = source.indexOf(searchFor, k);
        StringBuilder builder = new StringBuilder();
        while (found != -1) {
            builder.append(source.substring(k, found));
            builder.append(replaceWith);
            k = found + searchFor.length();
            found = source.indexOf(searchFor, k);
        }
        if (k > 0) {
            builder.append(source.substring(k));
            return builder.toString();
        }
        return source;
    }

    public static DataObject getDataObject(Object object) {
        if (!(object instanceof Node)) {
            return null;
        }
        return (DataObject)((Node)object).getLookup().lookup(DataObject.class);
    }

    public static JComponent getResizableX(JPanel panel) {
        return UI.getResizable(panel, 2);
    }

    public static JComponent getResizableXY(JPanel panel) {
        return UI.getResizable(panel, 1);
    }

    private static JComponent getResizable(JPanel panel, int fill) {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = fill;
        c.insets = new Insets(0, 8, 0, 8);
        c.anchor = 18;
        mainPanel.add((Component)panel, c);
        return mainPanel;
    }

    public static String removeHtml(String value) {
        if (value == null) {
            return null;
        }
        value = UI.replace(value, "<b>", "'");
        value = UI.replace(value, "</b>", "'");
        value = UI.replace(value, "&nbsp;", " ");
        return value;
    }

    public static String getHtml(String value) {
        return "<html>" + value + "</html>";
    }

    public static <T> List<T> getInstances(Class<T> clazz) {
        Collection collection = Lookup.getDefault().lookupAll(clazz);
        ArrayList<T> list = new ArrayList<T>();
        for (Object object : collection) {
            list.add(clazz.cast(object));
        }
        return list;
    }

    public static void copyToClipboard(String value) {
        UI.getClipboard().setContents(new StringSelection(value), null);
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(ExClipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    public static boolean isDigit(char c) {
        return "0123456789".indexOf(c) != -1;
    }

    public static void show(Container container, String indent) {
        Component[] children;
        UI.out((container.isShowing() ? "[[ " : "") + indent + container.getClass().getName());
        for (Component child : children = container.getComponents()) {
            if (!(child instanceof Container)) continue;
            UI.show((Container)child, "    " + indent);
        }
    }

    public static void startTimeln() {
        UI.tim();
        UI.startTime();
    }

    public static void startTime() {
        ourTimes.push(System.currentTimeMillis());
    }

    public static void endTime(Object object) {
        long currentTime = System.currentTimeMillis();
        UI.tim(object + ": " + (double)(currentTime - ourTimes.pop()) / 1000.0 + " sec.");
    }

    public static void tim() {
        if (ENABLE_TIM) {
            System.out.println();
        }
    }

    public static void tim(Object object) {
        if (ENABLE_TIM) {
            System.out.println("*** " + object);
        }
    }

    public static void log() {
        if (ENABLE_LOG) {
            System.out.println();
        }
    }

    public static void log(Object object) {
        if (ENABLE_LOG) {
            System.out.println("*** " + object);
        }
    }

    public static void dump() {
        UI.dump(null);
    }

    public static void dump(Object object) {
        UI.out();
        UI.out();
        if (object != null) {
            UI.out(object);
        }
        new Exception("!!!").printStackTrace();
    }

    public static void out() {
        if (ENABLE_OUT) {
            System.out.println();
        }
    }

    public static void out(Object object) {
        if (ENABLE_OUT) {
            System.out.println("*** " + object);
        }
    }

    public static abstract class ButtonAction
    extends AbstractAction {
        public ButtonAction(String text, String toolTip) {
            this(text, null, toolTip);
        }

        public ButtonAction(Icon icon, String toolTip) {
            this(null, icon, toolTip);
        }

        public ButtonAction(String text) {
            this(text, null, text);
        }

        private ButtonAction(String text, Icon icon, String toolTip) {
            super(text, icon);
            this.putValue("ShortDescription", toolTip);
        }
    }

    private static final class CornerBorder
    extends EmptyBorder {
        private static final Icon CORNER = new ImageIcon(new byte[]{71, 73, 70, 56, 57, 97, 12, 0, 12, 0, -9, 0, 0, -125, -125, -125, -45, -45, -56, -3, -3, -3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 33, -7, 4, 1, 0, 0, -1, 0, 44, 0, 0, 0, 0, 12, 0, 12, 0, 64, 8, 52, 0, -1, 9, 28, 72, -16, -97, -128, -127, 2, 0, 0, 48, -88, -48, 96, 65, -127, 9, 23, 30, 124, 8, -79, 33, -63, -120, 12, 37, 54, -60, -120, -111, 98, 69, -113, 29, 11, 114, 92, -120, 112, -93, -59, -116, 40, 19, -114, -44, -72, 48, 32, 0, 59});

        public CornerBorder() {
            super(0, 3, 3, 3);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            CORNER.paintIcon(c, g, w - CORNER.getIconWidth(), h - CORNER.getIconHeight());
        }
    }

    public static abstract class Dialog
    extends WindowAdapter {
        private boolean myIsModal = true;
        private java.awt.Dialog myDialog;

        protected void opened() {
        }

        protected void closed() {
        }

        protected void resized() {
        }

        protected void updated() {
        }

        protected abstract DialogDescriptor createDescriptor();

        public void show() {
            this.show(true, true);
        }

        public void show(boolean isResizable) {
            this.show(true, isResizable);
        }

        public void showAndWait() {
            this.show(false, true);
        }

        protected final void setModal(boolean isModal) {
            this.myIsModal = isModal;
        }

        private void show(boolean inSwingThread, boolean isResizable) {
            if (this.myDialog == null) {
                this.myDialog = DialogDisplayer.getDefault().createDialog(this.createDescriptor());
                this.myDialog.addWindowListener(this);
                this.myDialog.setResizable(isResizable);
                this.myDialog.setModal(this.myIsModal);
                if (isResizable) {
                    this.setCorner();
                }
                this.myDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentResized(ComponentEvent event) {
                        Dialog.this.resized();
                    }
                });
            } else {
                this.opened();
            }
            this.updated();
            if (inSwingThread) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Dialog.this.myDialog.setVisible(true);
                    }
                });
            } else {
                this.myDialog.setVisible(true);
            }
        }

        public Component getUIComponent() {
            return this.myDialog;
        }

        @Override
        public void windowOpened(WindowEvent event) {
            this.opened();
        }

        @Override
        public void windowClosed(WindowEvent event) {
            this.closed();
        }

        protected final String i18n(String key) {
            return UI.i18n(this.getClass(), key);
        }

        protected final String i18n(String key, String param) {
            return UI.i18n(this.getClass(), key, param);
        }

        private void setCorner() {
            if (this.myDialog instanceof JDialog) {
                ((JDialog)this.myDialog).getRootPane().setBorder(CORNER_BORDER);
            }
        }
    }

    public static abstract class IconAction
    extends AbstractAction {
        private Node myLastNode;

        protected IconAction(String name, String toolTip, Icon icon) {
            super(name, icon);
            this.putValue("ShortDescription", toolTip);
        }

        protected final Node getLastNode() {
            Node node = UI.getSelectedNode();
            if (node == null) {
                node = this.myLastNode;
            } else {
                this.myLastNode = node;
            }
            return node;
        }
    }

    public static class MyComboBox
    extends JComboBox {
        private int myIndex;
        private String myPrefix;

        public MyComboBox(Object[] items) {
            super(items);
            this.init();
        }

        @Override
        public boolean selectWithKeyChar(char key) {
            this.processKey(key);
            this.setSelectedIndex(this.myIndex);
            return true;
        }

        public void init() {
            this.myIndex = 0;
            this.myPrefix = "";
        }

        private void processKey(char key) {
            if (key == '\b') {
                this.init();
                return;
            }
            this.myPrefix = this.myPrefix + key;
            this.myPrefix = this.myPrefix.toLowerCase();
            for (int i = this.myIndex; i < this.getItemCount(); ++i) {
                String item = this.getItemAt(i).toString().toLowerCase();
                if (!item.startsWith(this.myPrefix)) continue;
                this.myIndex = i;
                return;
            }
        }
    }
}

