/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.core.startup.StartLog;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.lookup.Lookups;

final class WarmUpSupport
implements Runnable {
    private static final RequestProcessor.Task TASK;
    private static final Logger err;

    WarmUpSupport() {
    }

    static Task warmUp(long delay) {
        TASK.schedule((int)delay);
        return TASK;
    }

    static void waitFinished() {
        TASK.waitFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        err.fine("Warmup starting...");
        StartLog.logStart("Warmup");
        try {
            Collection warmObjects = Lookups.forPath((String)"WarmUp").lookupResult(Runnable.class).allItems();
            err.log(Level.FINE, "Found {0} warm up task(s)", warmObjects.size());
            for (Lookup.Item warmer : warmObjects) {
                try {
                    Runnable r = (Runnable)warmer.getInstance();
                    r.run();
                    StartLog.logProgress("Warmup task executed " + warmer.getId());
                }
                catch (Exception ex) {
                    Logger.getLogger(WarmUpSupport.class.getName()).log(Level.WARNING, null, ex);
                }
            }
            err.fine("Warmup done.");
        }
        finally {
            StartLog.logEnd("Warmup");
            StartLog.impl.flush();
        }
    }

    static {
        RequestProcessor RP = new RequestProcessor("Warm Up");
        TASK = RP.create((Runnable)new WarmUpSupport(), true);
        err = Logger.getLogger("org.netbeans.core.WarmUpSupport");
    }
}

