/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Named;

public class Signal
implements Named {
    private final String name;
    private final String type;
    private final String value;

    public Signal(String name, String type, String value) {
        this.name = name;
        this.type = type;
        this.value = value;
    }

    public Signal(String name, String type) {
        this(name, type, "");
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    protected String getComparableType() {
        return this.type.replaceAll("\\s", "");
    }

    public String getValue() {
        return this.value;
    }

    public boolean equalsName(Signal signal) {
        return this.name.equalsIgnoreCase(signal.getName());
    }

    public boolean equalsType(Signal signal) {
        return this.getComparableType().equalsIgnoreCase(signal.getComparableType());
    }

    public String toString() {
        return this.name;
    }

    public String toPrintableString(int longestLength) {
        longestLength -= this.name.length();
        StringBuilder add = new StringBuilder();
        while (longestLength > 0) {
            add.append(" ");
            --longestLength;
        }
        return "signal " + this.name + add.toString() + " : " + this.type + ";";
    }

    public int hashCode() {
        return this.name.hashCode() * 13;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Signal)) {
            return false;
        }
        Signal thatEntity = (Signal)that;
        return this.hashCode() == thatEntity.hashCode();
    }
}

