/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.SignalMap;
import java.util.Map;

public class Instantiation {
    private final String instantiationName;
    private final String componentName;
    private final Map<String, SignalMap> genericMap;
    private final Map<String, SignalMap> portMap;

    public Instantiation(String instantiationName, String componentName, Map<String, SignalMap> genericMap, Map<String, SignalMap> portMap) {
        this.instantiationName = instantiationName;
        this.componentName = componentName;
        this.genericMap = genericMap;
        this.portMap = portMap;
    }

    public String getInstantiationName() {
        return this.instantiationName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public Map<String, SignalMap> getGenericMap() {
        return this.genericMap;
    }

    public Map<String, SignalMap> getPortMap() {
        return this.portMap;
    }

    public String toString() {
        return this.instantiationName + " : " + this.componentName;
    }

    public String toPrintableString(int longestLength, boolean genericsInline, boolean portsInline) {
        String inst = this.getInstantiationName() + " : " + this.getComponentName();
        if (!this.genericMap.isEmpty()) {
            inst = inst + "\ngeneric map(" + Instantiation.printableMap(this.getGenericMap(), longestLength, genericsInline) + ")";
        }
        if (!this.portMap.isEmpty()) {
            inst = inst + "\nport map(" + Instantiation.printableMap(this.getPortMap(), longestLength, portsInline) + ")";
        }
        inst = inst + ";";
        return inst;
    }

    public static String printableMap(Map<String, SignalMap> map, int longestLength, boolean inline) {
        StringBuilder mapStr = new StringBuilder();
        if (inline) {
            for (SignalMap sMap : map.values()) {
                mapStr.append(sMap.toPrintableString());
                mapStr.append(", ");
            }
            if (mapStr.length() > 0) {
                mapStr.delete(mapStr.length() - 2, mapStr.length());
            }
        } else {
            for (SignalMap sMap : map.values()) {
                mapStr.append("\n        ");
                mapStr.append(sMap.toPrintableString(longestLength));
                mapStr.append(",");
            }
            if (mapStr.length() > 0) {
                mapStr.deleteCharAt(mapStr.length() - 1);
                mapStr.append("\n");
            }
        }
        return mapStr.toString();
    }

    public int hashCode() {
        return this.instantiationName.hashCode() * 13;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Instantiation)) {
            return false;
        }
        Instantiation thatEntity = (Instantiation)that;
        return this.hashCode() == thatEntity.hashCode();
    }
}

