/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Declaration;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Generic;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Instantiation;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Port;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Signal;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Type;
import java.util.Map;

public class Entity
implements Comparable<Entity> {
    private final String entityName;
    private final EntityType entityType;
    private final Map<String, Generic> generics;
    private final Map<String, Port> ports;
    private final String architectureName;
    private final Map<String, Type> types;
    private final Map<String, Signal> signals;
    private final Map<String, Declaration> declarations;
    private final Map<String, Instantiation> instantiations;

    public Entity(String entityName, EntityType entityType, Map<String, Generic> generics, Map<String, Port> ports, String architectureName, Map<String, Type> types, Map<String, Signal> signals, Map<String, Declaration> declarations, Map<String, Instantiation> instantiations) {
        this.entityName = entityName;
        this.entityType = entityType;
        this.generics = generics;
        this.ports = ports;
        this.architectureName = architectureName;
        this.types = types;
        this.signals = signals;
        this.declarations = declarations;
        this.instantiations = instantiations;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public Map<String, Port> getPorts() {
        return this.ports;
    }

    public Map<String, Generic> getGenerics() {
        return this.generics;
    }

    public String getArchitectureName() {
        return this.architectureName;
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public Map<String, Signal> getSignals() {
        return this.signals;
    }

    public Map<String, Declaration> getDeclarations() {
        return this.declarations;
    }

    public Map<String, Instantiation> getInstantiations() {
        return this.instantiations;
    }

    public String toString() {
        return "VHDL Entity: " + this.entityName + "\n - generics: " + this.generics.toString() + "\n - ports: " + this.ports.toString() + "\n Architecture: " + this.architectureName + "\n    * types: " + this.types.toString() + "\n    * signals: " + this.signals.toString() + "\n    * declarations: " + this.declarations.toString() + "\n    * instantiations: " + this.instantiations.toString();
    }

    public int hashCode() {
        return this.entityName.hashCode() * 13;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof Entity)) {
            return false;
        }
        Entity thatEntity = (Entity)that;
        return this.hashCode() == thatEntity.hashCode();
    }

    @Override
    public int compareTo(Entity eThat) {
        return this.getEntityName().compareToIgnoreCase(eThat.getEntityName());
    }

    public static enum EntityType {
        ENTITY,
        PACKAGE,
        TESTBENCH,
        TESTBENCH_TEMPLATE,
        CODE_TEMPLATE,
        UNKNOWN;

    }
}

