/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Entity;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Signal;
import java.util.List;
import org.openide.filesystems.FileObject;

public class ESInconsistency
extends Inconsistency {
    private final Entity component;
    private final FileObject componentEntityFOB;
    private final List<Signal> signalsToAdd;
    private final boolean declarationInconsistent;
    private final boolean instantiationInconsistent;

    public ESInconsistency(Entity entity, FileObject entityFOB, Entity component, FileObject componentEntityFOB, List<Signal> signalsToAdd, boolean declarationInconsistent, boolean instantiationInconsistent) {
        super(Inconsistency.InconsistencyRelationship.ES, Inconsistency.InconsistencyType.MISSING, entity, entityFOB);
        this.component = component;
        this.componentEntityFOB = componentEntityFOB;
        this.signalsToAdd = signalsToAdd;
        this.declarationInconsistent = declarationInconsistent;
        this.instantiationInconsistent = instantiationInconsistent;
    }

    public Entity getComponent() {
        return this.component;
    }

    public FileObject getComponentEntityFOB() {
        return this.componentEntityFOB;
    }

    public List<Signal> getSignalsToAdd() {
        return this.signalsToAdd;
    }

    @Override
    public String getDescription() {
        String msg = "Inconsistency in entity " + this.entity.getEntityName().toUpperCase() + ", component " + this.component.getEntityName().toUpperCase() + " - MISSING SIGNALS IN ENTITY ARCHITECTURE" + "\n signals to add: " + this.signalsToAdd.toString();
        return msg;
    }

    @Override
    public String getTableDescription() {
        return "MISSING SIGNALS declared in component " + this.component.getEntityName();
    }

    public boolean isDeclarationInconsistent() {
        return this.declarationInconsistent;
    }

    public boolean isInstantiationInconsistent() {
        return this.instantiationInconsistent;
    }
}

