/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.FixPack;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.Inconsistency;
import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import java.util.List;
import java.util.logging.Logger;
import org.openide.util.Lookup;

public abstract class InconsistencyService {
    protected static final Logger logger = Logger.getLogger(InconsistencyService.class.getName());

    public static InconsistencyService getDefault() {
        InconsistencyService result = (InconsistencyService)Lookup.getDefault().lookup(InconsistencyService.class);
        if (result == null) {
            result = new InconsistencyServiceDefaultImpl();
        }
        return result;
    }

    public abstract void fixAndStoreInconsistencies(List<InconsistentEntity> var1);

    public abstract FixPack fixInconsistency(Inconsistency var1);

    private static final class InconsistencyServiceDefaultImpl
    extends InconsistencyService {
        private InconsistencyServiceDefaultImpl() {
        }

        @Override
        public void fixAndStoreInconsistencies(List<InconsistentEntity> inconsistentEntities) {
            logger.info("Using default dummy InconsistencyService");
        }

        @Override
        public FixPack fixInconsistency(Inconsistency inconsistency) {
            logger.info("Using default dummy InconsistencyService");
            return new FixPack("", null);
        }
    }
}

