/*
 * Decompiled with CFR 0.152.
 */
package cz.ctu.fit.mateju.vhdt.vhdlserviceapi.services;

import cz.ctu.fit.mateju.vhdt.vhdlserviceapi.structures.InconsistentEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.openide.util.Lookup;

public abstract class ConsistencyCheckerService {
    protected static final Logger logger = Logger.getLogger(ConsistencyCheckerService.class.getName());

    public static ConsistencyCheckerService getDefault() {
        ConsistencyCheckerService result = (ConsistencyCheckerService)Lookup.getDefault().lookup(ConsistencyCheckerService.class);
        if (result == null) {
            result = new ConsistencyCheckerServiceDefaultImpl();
        }
        return result;
    }

    public abstract List<InconsistentEntity> checkConsistencyUp(Project var1, String var2);

    public abstract List<InconsistentEntity> checkConsistencyDown(Project var1, String var2);

    public abstract List<InconsistentEntity> checkConsistency(Project var1);

    private static final class ConsistencyCheckerServiceDefaultImpl
    extends ConsistencyCheckerService {
        private ConsistencyCheckerServiceDefaultImpl() {
        }

        @Override
        public List<InconsistentEntity> checkConsistencyUp(Project project, String entityName) {
            logger.info("Using default dummy ConsistencyCheckerService");
            return new ArrayList<InconsistentEntity>();
        }

        @Override
        public List<InconsistentEntity> checkConsistencyDown(Project project, String entityName) {
            logger.info("Using default dummy ConsistencyCheckerService");
            return new ArrayList<InconsistentEntity>();
        }

        @Override
        public List<InconsistentEntity> checkConsistency(Project project) {
            logger.info("Using default dummy ConsistencyCheckerService");
            return new ArrayList<InconsistentEntity>();
        }
    }
}

