/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.io.IOStatic;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.others.DocumentModifiedEvent;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe.SGenMainFrame;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class TextAreaPanel
extends JScrollPane {
    private JPanel panel = new JPanel(new GridLayout(1, 1));
    private JTextArea textArea;
    private File loadedFile;
    private boolean modified;

    public TextAreaPanel(SGenMainFrame mainFrame, String text) {
        super(20, 30);
        this.textArea = new JTextArea(text);
        this.textArea.setTabSize(4);
        this.textArea.setFont(IOStatic.getSelectedFont(mainFrame));
        this.textArea.setForeground(IOStatic.getSelectedFontColor(mainFrame));
        this.textArea.setBackground(IOStatic.getSelectedBackgroundColor(mainFrame));
        this.textArea.setMargin(new Insets(2, 2, 2, 2));
        this.panel.add(this.textArea);
        this.setViewportView(this.panel);
        this.setWheelScrollingEnabled(true);
        this.loadedFile = null;
        this.modified = false;
        this.textArea.getDocument().addDocumentListener(new DocumentModifiedEvent(this));
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public void textAppend(String text) {
        this.textArea.append(text);
    }

    public void copyText() {
        int position = this.textArea.getCaretPosition();
        this.textArea.selectAll();
        this.textArea.copy();
        this.textArea.setCaretPosition(position);
    }

    public void setFile(File f) {
        this.loadedFile = f;
    }

    public File getFile() {
        return this.loadedFile;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void scrollUp() {
        this.textArea.setCaretPosition(0);
    }

    public void scrollDown() {
        this.textArea.setCaretPosition(this.textArea.getText().length() - 1);
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public void setTextFont(Font f) {
        this.textArea.setFont(f);
    }

    public void setForegroundColor(Color color) {
        this.textArea.setForeground(color);
    }

    public void setBackgroundColor(Color color) {
        this.textArea.setBackground(color);
    }

    public void setEnabled(boolean enabled) {
        this.textArea.setEnabled(enabled);
    }
}

