/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.io.IOStatic;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.CopyToClipboardAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.GenerateTestbenchAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.LoadFileAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.OpenEditWindowAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.OpenGlobalDialogAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.SaveFileAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe.LeftPanelButton;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe.SGenMainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;

public class MainFrameLeftPanel
extends JPanel {
    private SGenMainFrame mainFrame;
    private LeftPanelButton quickGenerationButton;
    private LeftPanelButton dynamicGenerationButton;
    private LeftPanelButton generateTestbenchButton;
    private JPanel structure;
    private LeftPanelButton newStructureTemplateButton;
    private LeftPanelButton openStructureTemplateButton;
    private LeftPanelButton openVHDLButton;
    private JPanel testbench;
    private LeftPanelButton newTestbenchTemplateButton;
    private LeftPanelButton openTestbenchTemplateButton;
    private LeftPanelButton save;
    private LeftPanelButton copyToClipboard;

    public MainFrameLeftPanel(SGenMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.initPanel();
    }

    private void initPanel() {
        this.setLayout(new BorderLayout());
        JPanel p = new JPanel(new FlowLayout());
        int v = 0;
        this.structure = new JPanel();
        this.structure.setLayout(new BoxLayout(this.structure, 3));
        this.structure.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "VHDL Structure"));
        this.newStructureTemplateButton = new LeftPanelButton("New Template", "Create new Structure Template");
        this.structure.add(this.newStructureTemplateButton);
        this.structure.add(Box.createRigidArea(new Dimension(0, v)));
        this.openStructureTemplateButton = new LeftPanelButton("Open Template", "Open existing Structure Template");
        this.structure.add(this.openStructureTemplateButton);
        this.structure.add(Box.createRigidArea(new Dimension(0, v)));
        this.quickGenerationButton = new LeftPanelButton("Quick Generation", "Generate VHDL Structure");
        this.structure.add(this.quickGenerationButton);
        this.structure.add(Box.createRigidArea(new Dimension(0, v)));
        this.dynamicGenerationButton = new LeftPanelButton("Dynamic Generation", "Edit and Generate VHDL Structure");
        this.structure.add(this.dynamicGenerationButton);
        this.structure.add(Box.createRigidArea(new Dimension(0, v)));
        this.openVHDLButton = new LeftPanelButton("Open VHDL", "Open existing VHDL Structure");
        this.structure.add(this.openVHDLButton);
        this.structure.add(Box.createRigidArea(new Dimension(0, v)));
        p.add(this.structure);
        this.testbench = new JPanel();
        this.testbench.setLayout(new BoxLayout(this.testbench, 3));
        this.testbench.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "VHDL Testbench"));
        this.newTestbenchTemplateButton = new LeftPanelButton("New Template", "Create new Testbench Template");
        this.testbench.add(this.newTestbenchTemplateButton);
        this.testbench.add(Box.createRigidArea(new Dimension(0, v)));
        this.openTestbenchTemplateButton = new LeftPanelButton("Open Template", "Open existing Testbench Template");
        this.testbench.add(this.openTestbenchTemplateButton);
        this.testbench.add(Box.createRigidArea(new Dimension(0, v)));
        this.generateTestbenchButton = new LeftPanelButton("Generate Testbench", "Generate Testbench from VHDL Structure and Testbench Template");
        this.testbench.add(this.generateTestbenchButton);
        this.testbench.add(Box.createRigidArea(new Dimension(0, v)));
        p.add(this.testbench);
        JPanel clipboard = new JPanel();
        clipboard.setLayout(new BoxLayout(clipboard, 3));
        clipboard.add(Box.createRigidArea(new Dimension(0, 50)));
        this.save = new LeftPanelButton("Save", "Save current code");
        this.copyToClipboard = new LeftPanelButton("Copy to clipboard", "Copy code from text area into system clipboard");
        clipboard.add(this.save);
        clipboard.add(this.copyToClipboard);
        clipboard.add(Box.createRigidArea(new Dimension(0, 20)));
        p.add(clipboard);
        this.add((Component)p, "Center");
        this.setVisibleGroup(4);
        this.quickGenerationButton.addActionListener(new OpenGlobalDialogAction(this.mainFrame));
        this.dynamicGenerationButton.addActionListener(new OpenEditWindowAction(this.mainFrame));
        this.generateTestbenchButton.addActionListener(new GenerateTestbenchAction(this.mainFrame));
        this.newStructureTemplateButton.addActionListener(new LoadFileAction(this.mainFrame, 0, IOStatic.NEW_STRUCTURE_TEMPLATE));
        this.openStructureTemplateButton.addActionListener(new LoadFileAction(this.mainFrame, 0, 0));
        this.openVHDLButton.addActionListener(new LoadFileAction(this.mainFrame, 1, 2));
        this.newTestbenchTemplateButton.addActionListener(new LoadFileAction(this.mainFrame, 0, IOStatic.NEW_TESTBENCH_TEMPLATE));
        this.openTestbenchTemplateButton.addActionListener(new LoadFileAction(this.mainFrame, 0, 1));
        this.save.addActionListener(new SaveFileAction(this.mainFrame, 4));
        this.copyToClipboard.addActionListener(new CopyToClipboardAction(this.mainFrame));
    }

    public void setVisibleGroup(int group) {
        switch (group) {
            case 4: {
                this.quickGenerationButton.setEnabled(false);
                this.dynamicGenerationButton.setEnabled(false);
                this.generateTestbenchButton.setEnabled(false);
                this.newStructureTemplateButton.setEnabled(true);
                this.openStructureTemplateButton.setEnabled(true);
                this.openVHDLButton.setEnabled(true);
                this.newTestbenchTemplateButton.setEnabled(true);
                this.openTestbenchTemplateButton.setEnabled(true);
                this.save.setEnabled(false);
                this.save.setText("Save");
                this.copyToClipboard.setEnabled(false);
                break;
            }
            case 0: {
                this.quickGenerationButton.setEnabled(true);
                this.dynamicGenerationButton.setEnabled(true);
                this.generateTestbenchButton.setEnabled(true);
                if (this.mainFrame.getLoadedFile().getName().endsWith(".sgs")) {
                    this.generateTestbenchButton.setEnabled(false);
                }
                if (this.mainFrame.getLoadedFile().getName().endsWith(".sgt")) {
                    this.quickGenerationButton.setEnabled(false);
                    this.dynamicGenerationButton.setEnabled(false);
                }
                this.newStructureTemplateButton.setEnabled(true);
                this.openStructureTemplateButton.setEnabled(true);
                this.openVHDLButton.setEnabled(true);
                this.newTestbenchTemplateButton.setEnabled(true);
                this.openTestbenchTemplateButton.setEnabled(true);
                this.save.setEnabled(true);
                this.save.setText("Save Template");
                this.copyToClipboard.setEnabled(true);
                break;
            }
            case 1: {
                this.quickGenerationButton.setEnabled(false);
                this.dynamicGenerationButton.setEnabled(false);
                this.generateTestbenchButton.setEnabled(true);
                this.newStructureTemplateButton.setEnabled(true);
                this.openStructureTemplateButton.setEnabled(true);
                this.openVHDLButton.setEnabled(true);
                this.newTestbenchTemplateButton.setEnabled(true);
                this.openTestbenchTemplateButton.setEnabled(true);
                this.save.setEnabled(true);
                this.save.setText("Save VHDL");
                this.copyToClipboard.setEnabled(true);
                break;
            }
            case 2: {
                this.quickGenerationButton.setEnabled(false);
                this.dynamicGenerationButton.setEnabled(false);
                this.generateTestbenchButton.setEnabled(false);
                this.newStructureTemplateButton.setEnabled(true);
                this.openStructureTemplateButton.setEnabled(true);
                this.openVHDLButton.setEnabled(true);
                this.newTestbenchTemplateButton.setEnabled(true);
                this.openTestbenchTemplateButton.setEnabled(true);
                this.save.setEnabled(true);
                this.save.setText("Save VHDL");
                this.copyToClipboard.setVisible(true);
                break;
            }
            default: {
                this.quickGenerationButton.setEnabled(true);
                this.dynamicGenerationButton.setEnabled(true);
                this.generateTestbenchButton.setEnabled(true);
                this.newStructureTemplateButton.setEnabled(true);
                this.openStructureTemplateButton.setEnabled(true);
                this.openVHDLButton.setEnabled(true);
                this.newTestbenchTemplateButton.setEnabled(true);
                this.openTestbenchTemplateButton.setEnabled(true);
                this.save.setEnabled(true);
                this.save.setText("Save");
                this.copyToClipboard.setEnabled(true);
            }
        }
    }
}

