/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.presentationtier.filechooser;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.io.IOStatic;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe.SGenMainFrame;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public abstract class SGenFileChooser
extends JFileChooser {
    protected SGenMainFrame mainFrame;
    protected byte fileType;

    public SGenFileChooser(SGenMainFrame mainFrame, byte fileType) {
        super("SGen File Chooser");
        this.setMultiSelectionEnabled(false);
        this.mainFrame = mainFrame;
        this.fileType = fileType;
    }

    protected void setFilter() {
        FileNameExtensionFilter f;
        switch (this.fileType) {
            case 2: {
                f = IOStatic.VHD_FILTER;
                break;
            }
            case 0: {
                f = IOStatic.SGS_FILTER;
                break;
            }
            case 1: {
                f = IOStatic.SGT_FILTER;
                break;
            }
            default: {
                f = null;
            }
        }
        if (f != null) {
            this.setFileFilter(f);
        } else {
            this.addChoosableFileFilter(IOStatic.VHD_FILTER);
            this.addChoosableFileFilter(IOStatic.SGS_FILTER);
            this.addChoosableFileFilter(IOStatic.SGT_FILTER);
            this.setFileFilter(IOStatic.VHD_FILTER);
        }
    }

    protected void setDir() {
        String dir;
        switch (this.fileType) {
            case 0: {
                dir = IOStatic.STRUCTURE_TEMPLATES;
                break;
            }
            case 1: {
                dir = IOStatic.TESTBENCH_TEMPLATES;
                break;
            }
            default: {
                dir = IOStatic.getLastVisited(this.mainFrame);
            }
        }
        this.setCurrentDirectory(new File(dir));
    }

    protected void prepareFileType() {
        String type;
        switch (this.fileType) {
            case 0: {
                type = ".sgs";
                break;
            }
            case 1: {
                type = ".sgt";
                break;
            }
            case 2: {
                type = ".vhd";
                break;
            }
            default: {
                type = null;
            }
        }
        if (type != null) {
            this.setSelectedFile(new File(type));
        }
    }
}

