/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.core.EditingCore;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Rowable;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.Changeable;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.GlobalLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.PortLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.SignalLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.TypeLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.AddLineAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.CancelAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.buttons.GenerateStructureAction;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.listeners.others.ComponentFocus;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class EditWindow
extends JDialog
implements Changeable {
    private EditingCore ec;
    private JTabbedPane mainEditFrame;
    private JPanel generalPanel;
    private JPanel globalsPanel;
    private JPanel genericsPanel;
    private JPanel portsPanel;
    private JPanel typesPanel;
    private JPanel signalsPanel;
    private JPanel constantsPanel;
    private JLabel entityNameLabel;
    private JTextField entityNameTextField;
    private JLabel architectureNameLabel;
    private JTextField architectureNameTextField;
    private JLabel genericsNumberLabel;
    private JLabel portsNumberLabel;
    private JLabel typesNumberLabel;
    private JLabel signalsNumberLabel;
    private JLabel constantsNumberLabel;
    private JPanel buttonsPanel;
    private JButton generateStructureButton;
    private JButton cancelButton;
    private JButton generate;
    private JButton addB;
    private Rowable entity;
    private Rowable architecture;

    public EditWindow(JFrame owner, EditingCore ec, Rowable entity, Rowable architecture) {
        super(owner, "Edit window", true);
        this.ec = ec;
        this.entity = entity;
        this.architecture = architecture;
        this.initEditWindow();
    }

    private void initEditWindow() {
        int width = 540;
        int heigth = 330;
        this.setDefaultCloseOperation(2);
        this.setBounds(180, 80, width, heigth);
        this.setMaximumSize(new Dimension(width, heigth));
        this.setPreferredSize(new Dimension(width, heigth));
        this.setMinimumSize(new Dimension(width, heigth));
        this.mainEditFrame = new JTabbedPane();
        this.generalPanel = new JPanel();
        this.generalPanel.setLayout(new BorderLayout());
        this.entityNameLabel = new JLabel("Entity name: ");
        this.entityNameTextField = new JTextField(this.entity.getName());
        if (!this.entity.getGlobalPart().equals("")) {
            this.entityNameTextField.setEditable(false);
        }
        JPanel names = new JPanel();
        names.setBorder(BorderFactory.createTitledBorder("basic info"));
        names.setLayout(new GridLayout(3, 2, 0, 10));
        names.add(this.entityNameLabel);
        names.add(this.entityNameTextField);
        this.architectureNameLabel = new JLabel("Architecture name: ");
        this.architectureNameTextField = new JTextField(this.architecture.getName());
        if (!this.architecture.getGlobalPart().equals("")) {
            this.architectureNameTextField.setEditable(false);
        }
        names.add(this.architectureNameLabel);
        names.add(this.architectureNameTextField);
        this.globalsPanel = new JPanel();
        this.globalsPanel.setLayout(new BoxLayout(this.globalsPanel, 3));
        JScrollPane scroll = new JScrollPane(this.globalsPanel, 20, 31);
        scroll.setBorder(BorderFactory.createTitledBorder("globals"));
        JPanel basicInfo = new JPanel();
        basicInfo.setLayout(new BorderLayout());
        basicInfo.add((Component)names, "First");
        basicInfo.add((Component)scroll, "Center");
        this.generalPanel.add((Component)basicInfo, "Center");
        this.genericsNumberLabel = new JLabel();
        this.portsNumberLabel = new JLabel();
        this.typesNumberLabel = new JLabel();
        this.signalsNumberLabel = new JLabel();
        this.constantsNumberLabel = new JLabel();
        JPanel numbers = new JPanel();
        numbers.setBorder(BorderFactory.createTitledBorder("stats"));
        numbers.setLayout(new GridLayout(6, 1, 0, 0));
        numbers.add(this.genericsNumberLabel);
        numbers.add(this.portsNumberLabel);
        numbers.add(this.typesNumberLabel);
        numbers.add(this.signalsNumberLabel);
        numbers.add(this.constantsNumberLabel);
        this.buttonsPanel = new JPanel(new FlowLayout());
        this.generateStructureButton = new JButton("Generate Structure");
        this.generateStructureButton.setToolTipText("Generate VHDL Structure");
        this.buttonsPanel.add(this.generateStructureButton);
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.buttonsPanel.add(this.cancelButton);
        JPanel p = new JPanel(new BorderLayout());
        p.add((Component)numbers, "Center");
        p.add((Component)this.buttonsPanel, "Last");
        this.generalPanel.add((Component)p, "East");
        this.mainEditFrame.addTab("General", this.generalPanel);
        this.genericsPanel = new JPanel();
        this.genericsPanel.setLayout(new BoxLayout(this.genericsPanel, 3));
        this.addB = new JButton("Add generic");
        this.addB.setMargin(new Insets(1, 1, 1, 1));
        this.addB.setToolTipText("Add new generic to this entity");
        this.addB.addActionListener(new AddLineAction(this.ec));
        this.generate = new JButton("Generate");
        this.generate.setMargin(new Insets(1, 1, 1, 1));
        this.generate.setToolTipText("Generate VHDL Structure");
        this.generate.addActionListener(new GenerateStructureAction(this.ec, this, false));
        JPanel addBG = new JPanel(new GridLayout(0, 6, 4, 0));
        for (int i = 0; i < 4; ++i) {
            addBG.add(new JPanel());
        }
        addBG.add(this.addB);
        addBG.add(this.generate);
        scroll = new JScrollPane(this.genericsPanel, 20, 31);
        JPanel genericsTab = new JPanel(new BorderLayout());
        genericsTab.add((Component)scroll, "Center");
        genericsTab.add((Component)addBG, "Last");
        this.mainEditFrame.addTab("Generics", genericsTab);
        this.portsPanel = new JPanel();
        this.portsPanel.setLayout(new BoxLayout(this.portsPanel, 3));
        this.addB = new JButton("Add port");
        this.addB.setMargin(new Insets(1, 1, 1, 1));
        this.addB.setToolTipText("Add new port to this entity");
        this.addB.addActionListener(new AddLineAction(this.ec));
        this.generate = new JButton("Generate");
        this.generate.setMargin(new Insets(1, 1, 1, 1));
        this.generate.setToolTipText("Generate VHDL Structure");
        this.generate.addActionListener(new GenerateStructureAction(this.ec, this, false));
        JPanel addBP = new JPanel(new GridLayout(0, 6, 4, 0));
        for (int i = 0; i < 4; ++i) {
            addBP.add(new JPanel());
        }
        addBP.add(this.addB);
        addBP.add(this.generate);
        scroll = new JScrollPane(this.portsPanel, 20, 31);
        JPanel portsTab = new JPanel(new BorderLayout());
        portsTab.add((Component)scroll, "Center");
        portsTab.add((Component)addBP, "Last");
        this.mainEditFrame.addTab("Ports", portsTab);
        this.typesPanel = new JPanel();
        this.typesPanel.setLayout(new BoxLayout(this.typesPanel, 3));
        this.addB = new JButton("Add type");
        this.addB.setMargin(new Insets(1, 1, 1, 1));
        this.addB.setToolTipText("Add new type to this entity");
        this.addB.addActionListener(new AddLineAction(this.ec));
        this.generate = new JButton("Generate");
        this.generate.setMargin(new Insets(1, 1, 1, 1));
        this.generate.setToolTipText("Generate VHDL Structure");
        this.generate.addActionListener(new GenerateStructureAction(this.ec, this, false));
        JPanel addBT = new JPanel(new GridLayout(0, 6, 4, 0));
        for (int i = 0; i < 4; ++i) {
            addBT.add(new JPanel());
        }
        addBT.add(this.addB);
        addBT.add(this.generate);
        scroll = new JScrollPane(this.typesPanel, 20, 31);
        JPanel typesTab = new JPanel(new BorderLayout());
        typesTab.add((Component)scroll, "Center");
        typesTab.add((Component)addBT, "Last");
        this.mainEditFrame.addTab("Types", typesTab);
        this.signalsPanel = new JPanel();
        this.signalsPanel.setLayout(new BoxLayout(this.signalsPanel, 3));
        this.addB = new JButton("Add signal");
        this.addB.setMargin(new Insets(1, 1, 1, 1));
        this.addB.setToolTipText("Add new signal to this entity");
        this.addB.addActionListener(new AddLineAction(this.ec));
        this.generate = new JButton("Generate");
        this.generate.setMargin(new Insets(1, 1, 1, 1));
        this.generate.setToolTipText("Generate VHDL Structure");
        this.generate.addActionListener(new GenerateStructureAction(this.ec, this, false));
        JPanel addBS = new JPanel(new GridLayout(0, 6, 4, 0));
        for (int i = 0; i < 4; ++i) {
            addBS.add(new JPanel());
        }
        addBS.add(this.addB);
        addBS.add(this.generate);
        scroll = new JScrollPane(this.signalsPanel, 20, 31);
        JPanel signalsTab = new JPanel(new BorderLayout());
        signalsTab.add((Component)scroll, "Center");
        signalsTab.add((Component)addBS, "Last");
        this.mainEditFrame.addTab("Signals", signalsTab);
        this.constantsPanel = new JPanel();
        this.constantsPanel.setLayout(new BoxLayout(this.constantsPanel, 3));
        this.addB = new JButton("Add constant");
        this.addB.setMargin(new Insets(1, 1, 1, 1));
        this.addB.setToolTipText("Add new constant to this entity");
        this.addB.addActionListener(new AddLineAction(this.ec));
        this.generate = new JButton("Generate");
        this.generate.setMargin(new Insets(1, 1, 1, 1));
        this.generate.setToolTipText("Generate VHDL Structure");
        this.generate.addActionListener(new GenerateStructureAction(this.ec, this, false));
        JPanel addBC = new JPanel(new GridLayout(0, 6, 4, 0));
        for (int i = 0; i < 4; ++i) {
            addBC.add(new JPanel());
        }
        addBC.add(this.addB);
        addBC.add(this.generate);
        scroll = new JScrollPane(this.constantsPanel, 20, 31);
        JPanel constantsTab = new JPanel(new BorderLayout());
        constantsTab.add((Component)scroll, "Center");
        constantsTab.add((Component)addBC, "Last");
        this.mainEditFrame.addTab("Constants", constantsTab);
        this.getContentPane().add((Component)this.mainEditFrame, "Center");
        this.setResizable(true);
        this.pack();
        this.generateStructureButton.addActionListener(new GenerateStructureAction(this.ec, this, false));
        this.cancelButton.addActionListener(new CancelAction(this));
        if (this.entityNameTextField.isEditable()) {
            this.entityNameTextField.addFocusListener(new ComponentFocus(this));
        }
        if (this.architectureNameTextField.isEditable()) {
            this.architectureNameTextField.addFocusListener(new ComponentFocus(this));
        }
    }

    public void setNames() {
        this.entityNameTextField.setText(this.entity.getName());
        this.architectureNameTextField.setText(this.architecture.getName());
    }

    public void setCounts(int a, int b, int c, int d, int e) {
        this.genericsNumberLabel.setText("Number of generics   : " + a);
        this.portsNumberLabel.setText("Number of ports   : " + b);
        this.typesNumberLabel.setText("Number of types   : " + c);
        this.signalsNumberLabel.setText("Number of signals : " + d);
        this.constantsNumberLabel.setText("Number of constants : " + e);
    }

    public void addLine(PortLine pl) {
        this.portsPanel.add(pl);
    }

    public void addLine(TypeLine tl) {
        this.typesPanel.add(tl);
    }

    public void addLine(SignalLine sl) {
        if (sl.getName().equals("")) {
            this.genericsPanel.add(sl);
        }
        if (sl.getName().equals("signal")) {
            this.signalsPanel.add(sl);
        }
        if (sl.getName().equals("constant")) {
            this.constantsPanel.add(sl);
        }
    }

    public void addLine(GlobalLine gl) {
        this.globalsPanel.add(gl);
    }

    public void erase() {
        this.genericsPanel.removeAll();
        this.portsPanel.removeAll();
        this.signalsPanel.removeAll();
        this.typesPanel.removeAll();
        this.constantsPanel.removeAll();
    }

    public void saveTextFieldChanges() {
        this.entity.setName(this.entityNameTextField.getText());
        this.architecture.setName(this.architectureNameTextField.getText());
    }

    public void saveComboBoxChanges() {
    }
}

