/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.applicationtier.core;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzer;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzerException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.core.CodeBuilder;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.core.CodeBuilderException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.core.EditingCoreException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.AnchoredName;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Constant;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Port;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Rowable;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Signal;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Table;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Type;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.EditWindow;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.GlobalLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.Line;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.PortLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.SignalLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.TypeLine;
import cz.cvut.fel.mateju.vhdlsgen.presentationtier.mainframe.SGenMainFrame;
import java.util.Vector;
import javax.swing.JOptionPane;

public class EditingCore {
    private SGenMainFrame mainFrame;
    private EditWindow ew;
    private StringBuffer code;
    private Table[] tables;
    private int newGenericNumber;
    private int newPortNumber;
    private int newTypeNumber;
    private int newSignalNumber;
    private int newConstantNumber;

    public EditingCore(SGenMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.code = new StringBuffer(mainFrame.getTextFromArea());
        this.tables = new Table[6];
    }

    private void analyzeCode(Choose choose) {
        try {
            CodeAnalyzer ca = new CodeAnalyzer(this.code.toString());
            switch (choose) {
                case GLOBALS_TYPES_SIGNALS: {
                    this.tables[0] = ca.fillGlobals(false);
                    ca.resetStream();
                    Table[] tsc = ca.fillTSCTable();
                    this.tables[3] = tsc[0];
                    this.tables[4] = tsc[1];
                    break;
                }
                case PORTS_GENERICS: {
                    this.tables[0] = ca.fillGlobals(true);
                    ca.resetStream();
                    this.tables[1] = ca.fillGenericTable();
                    ca.resetStream();
                    this.tables[2] = ca.fillPortTable();
                    break;
                }
                case ALL: {
                    this.tables = ca.fillTables();
                }
            }
            ca.closeStream();
        }
        catch (CodeAnalyzerException e) {
            this.mainFrame.setErrStatus(e.getMessage());
        }
    }

    public void partAnalyze() {
        this.analyzeCode(Choose.GLOBALS_TYPES_SIGNALS);
    }

    public void configureEditWindow() throws EditingCoreException {
        this.analyzeCode(Choose.ALL);
        this.ew = new EditWindow(this.mainFrame, this, (Rowable)this.tables[0].firstElement(), (Rowable)this.tables[0].elementAt(1));
        this.ew.setCounts(this.tables[1].size(), this.tables[2].size(), this.tables[3].size(), this.tables[4].size(), this.tables[5].size());
        if (!this.tables[0].isEmpty()) {
            this.fillGlobals();
        }
        if (!this.tables[1].isEmpty()) {
            this.fillGenerics();
        }
        if (!this.tables[2].isEmpty()) {
            this.fillPorts();
        }
        if (!this.tables[3].isEmpty()) {
            this.fillTypes();
        }
        if (!this.tables[4].isEmpty()) {
            this.fillSignals();
        }
        if (!this.tables[5].isEmpty()) {
            this.fillConstants();
        }
        if (this.ew == null) {
            throw new EditingCoreException("Edit window could not be opened");
        }
        this.ew.setVisible(true);
    }

    public void addLine(String s) throws EditingCoreException {
        if (this.ew == null) {
            throw new EditingCoreException("Edit window was not created");
        }
        String[] name = new String[]{"", "", ""};
        if (s.equals("Add generic")) {
            ++this.newGenericNumber;
            name[0] = "new_generic" + this.newGenericNumber;
            this.tables[1].add(new Signal(name, "integer", "0"));
        } else if (s.equals("Add port")) {
            ++this.newPortNumber;
            name[0] = "new_port" + this.newPortNumber;
            this.tables[2].add(new Port(name, "in", "std_logic"));
        } else if (s.equals("Add signal")) {
            ++this.newSignalNumber;
            name[0] = "new_signal" + this.newPortNumber;
            this.tables[4].add(new Signal(name, "std_logic"));
        } else if (s.equals("Add type")) {
            ++this.newTypeNumber;
            name[0] = "new_type" + this.newPortNumber;
            Vector<AnchoredName> types = new Vector<AnchoredName>();
            String[] tName = new String[]{"", "", ""};
            types.add(new AnchoredName(tName));
            this.tables[3].add(new Type(name, types));
        } else if (s.equals("Add constant")) {
            ++this.newConstantNumber;
            name[0] = "new_constant" + this.newConstantNumber;
            this.tables[5].add(new Signal(name, "integer", "0"));
        } else {
            this.mainFrame.setErrStatus("Row could not be added");
        }
        this.reconfigureEditWindow();
    }

    public void deleteLine(Line l) throws EditingCoreException {
        if (this.ew == null) {
            throw new EditingCoreException("Edit window was not created");
        }
        String cName = l.getClass().getName();
        String anchor = l.getAnchor();
        int[] index = new int[]{-1, -1};
        String pack = "cz.cvut.fel.mateju.vhdlsgen.presentationtier.editwindow.";
        if (cName.equals(pack + "PortLine")) {
            index[0] = 2;
            index[1] = this.tables[2].findAnchor(anchor);
        } else if (cName.equals(pack + "SignalLine")) {
            SignalLine sl = (SignalLine)l;
            if (sl.getName().equals("")) {
                index[0] = 1;
                index[1] = this.tables[1].findAnchor(anchor);
            }
            if (sl.getName().equals("signal")) {
                index[0] = 4;
                index[1] = this.tables[4].findAnchor(anchor);
            }
            if (sl.getName().equals("constant")) {
                index[0] = 5;
                index[1] = this.tables[5].findAnchor(anchor);
            }
        } else if (cName.equals(pack + "TypeLine")) {
            index[0] = 3;
            index[1] = this.tables[3].findAnchor(anchor);
        }
        if (index[1] == -1) {
            this.mainFrame.setErrStatus("Row was not found");
        } else {
            this.tables[index[0]].remove(index[1]);
        }
        this.reconfigureEditWindow();
    }

    public void renameGlobalDependent(String global, String name) {
        for (int i = 0; i < 2; ++i) {
            Rowable r = (Rowable)this.tables[0].elementAt(i);
            if (!global.equals(r.getGlobalPart())) continue;
            r.setName(name);
        }
        for (Rowable r : this.tables[1]) {
            if (!global.equals(r.getGlobalPart())) continue;
            r.setName(name);
        }
        for (Rowable r : this.tables[2]) {
            if (!global.equals(r.getGlobalPart())) continue;
            r.setName(name);
        }
        for (Rowable r : this.tables[3]) {
            if (global.equals(r.getGlobalPart())) {
                r.setName(name);
            }
            Type t = (Type)r;
            for (AnchoredName an : t.getValues()) {
                if (!global.equals(an.getGlobalPart())) continue;
                an.setName(name);
            }
        }
        for (Rowable r : this.tables[4]) {
            if (!global.equals(r.getGlobalPart())) continue;
            r.setName(name);
        }
        for (Rowable r : this.tables[5]) {
            if (!global.equals(r.getGlobalPart())) continue;
            r.setName(name);
        }
        this.reconfigureEditWindow();
    }

    public void renameSignalType(String oldName, String newName) {
        for (Rowable r : this.tables[4]) {
            Signal tr = (Signal)r;
            if (!oldName.equals(tr.getType())) continue;
            tr.setType(newName);
        }
        this.reconfigureEditWindow();
    }

    public void renameConstantType(String oldName, String newName) {
        for (Rowable r : this.tables[5]) {
            Constant tr = (Constant)r;
            if (!oldName.equals(tr.getType())) continue;
            tr.setType(newName);
        }
        this.reconfigureEditWindow();
    }

    public void completeCode(boolean simpleGeneration) {
        CodeBuilder codeBuilder = CodeBuilder.createCodeBuilder();
        this.code = codeBuilder.removeHeader(this.code);
        if (!simpleGeneration) {
            try {
                Rowable r;
                this.code = codeBuilder.replaceEA(this.code, this.tables[0]);
                codeBuilder.insertTables(this.code, this.tables);
                try {
                    this.code = codeBuilder.unpackCase(this.code, this.tables[3], this.tables[4]);
                }
                catch (CodeBuilderException cbe) {
                    this.mainFrame.setErrStatus(cbe.getMessage());
                }
                while ((r = this.tables[1].nextModified()) != null) {
                    if (!r.getGlobalPart().equals("")) continue;
                    this.code = codeBuilder.replaceAnchor(this.code, r.getAnchor(), r.getName());
                }
                while ((r = this.tables[2].nextModified()) != null) {
                    if (!r.getGlobalPart().equals("")) continue;
                    this.code = codeBuilder.replaceAnchor(this.code, r.getAnchor(), r.getName());
                }
                while ((r = this.tables[3].nextModified()) != null) {
                    if (!r.getGlobalPart().equals("")) continue;
                    this.code = codeBuilder.replaceAnchor(this.code, r.getAnchor(), r.getName());
                }
                while ((r = this.tables[4].nextModified()) != null) {
                    if (!r.getGlobalPart().equals("")) continue;
                    this.code = codeBuilder.replaceAnchor(this.code, r.getAnchor(), r.getName());
                }
                while ((r = this.tables[5].nextModified()) != null) {
                    if (!r.getGlobalPart().equals("")) continue;
                    this.code = codeBuilder.replaceAnchor(this.code, r.getAnchor(), r.getName());
                }
                for (Rowable row : this.tables[0]) {
                    this.code = codeBuilder.replaceDident(this.code, row.getAnchor(), row.getName());
                }
                this.code = codeBuilder.removeDollar(this.code);
            }
            catch (CodeAnalyzerException cae) {
                this.mainFrame.setErrStatus(cae.getMessage());
            }
        } else {
            for (Rowable r : this.tables[0]) {
                if (!r.isModified()) continue;
                for (Rowable o : this.tables[3]) {
                    Type t = (Type)o;
                    if (t.getValues() == null) continue;
                    for (AnchoredName an : t.getValues()) {
                        if (!an.getGlobalPart().equals(r.getAnchor())) continue;
                        an.setName(r.getName());
                    }
                }
            }
            try {
                this.code = codeBuilder.unpackCase(this.code, this.tables[3], this.tables[4]);
            }
            catch (CodeBuilderException cbe) {
                this.mainFrame.setErrStatus(cbe.getMessage());
            }
            catch (CodeAnalyzerException cae) {
                this.mainFrame.setErrStatus(cae.getMessage());
            }
            for (Rowable row : this.tables[0]) {
                this.code = codeBuilder.replaceDident(this.code, row.getAnchor(), row.getName());
            }
            this.code = codeBuilder.removeDollar(this.code);
        }
        this.mainFrame.selectTab(1);
        if (this.mainFrame.isModified()) {
            int n = JOptionPane.showConfirmDialog(this.mainFrame, "Overwrite current code?", "Current code has not been saved", 0);
            if (n == 0) {
                this.mainFrame.setTextInArea(this.code.toString());
                this.mainFrame.setStatus("VHDL Structure successfully created");
            }
        } else {
            this.mainFrame.setTextInArea(this.code.toString());
            this.mainFrame.setStatus("VHDL Structure successfully created");
        }
        this.mainFrame.scrollUp();
    }

    public void createTestbench(StringBuffer testbenchTemplate) {
        this.analyzeCode(Choose.PORTS_GENERICS);
        CodeBuilder codeBuilder = CodeBuilder.createCodeBuilder();
        StringBuffer testbench = codeBuilder.createTestbench(testbenchTemplate, ((Rowable)this.tables[0].firstElement()).getName(), this.tables[2], this.tables[1]);
        this.mainFrame.selectTab(2);
        if (this.mainFrame.isModified()) {
            int n = JOptionPane.showConfirmDialog(this.mainFrame, "Overwrite current code?", "Current code has not been saved", 0);
            if (n == 0) {
                this.mainFrame.setTextInArea(testbench.toString());
                this.mainFrame.setStatus("VHDL Testbench successfully created");
            }
        } else {
            this.mainFrame.setTextInArea(testbench.toString());
            this.mainFrame.setStatus("VHDL Testbench successfully created");
        }
        this.mainFrame.scrollUp();
    }

    private void reconfigureEditWindow() {
        this.ew.erase();
        this.ew.setNames();
        this.ew.setCounts(this.tables[1].size(), this.tables[2].size(), this.tables[3].size(), this.tables[4].size(), this.tables[5].size());
        if (!this.tables[1].isEmpty()) {
            this.fillGenerics();
        }
        if (!this.tables[2].isEmpty()) {
            this.fillPorts();
        }
        if (!this.tables[3].isEmpty()) {
            this.fillTypes();
        }
        if (!this.tables[4].isEmpty()) {
            this.fillSignals();
        }
        if (!this.tables[5].isEmpty()) {
            this.fillConstants();
        }
        this.ew.repaint();
    }

    public SGenMainFrame getMainFrame() {
        return this.mainFrame;
    }

    public Table getGlobalTable() {
        return this.tables[0];
    }

    private void fillGlobals() {
        for (int i = 2; i < this.tables[0].size(); ++i) {
            AnchoredName an = (AnchoredName)this.tables[0].elementAt(i);
            this.ew.addLine(new GlobalLine(this, an, true));
        }
    }

    private void fillGenerics() {
        for (int i = 0; i < this.tables[1].size(); ++i) {
            Signal s = (Signal)this.tables[1].elementAt(i);
            SignalLine genericLine = new SignalLine(this, s, "");
            this.ew.addLine(genericLine);
        }
    }

    private void fillPorts() {
        for (int i = 0; i < this.tables[2].size(); ++i) {
            Port p = (Port)this.tables[2].elementAt(i);
            PortLine portLine = new PortLine(this, p);
            this.ew.addLine(portLine);
        }
    }

    private void fillSignals() {
        for (int i = 0; i < this.tables[4].size(); ++i) {
            Signal s = (Signal)this.tables[4].elementAt(i);
            SignalLine signalLine = new SignalLine(this, s, "signal");
            this.ew.addLine(signalLine);
        }
    }

    private void fillTypes() {
        for (int i = 0; i < this.tables[3].size(); ++i) {
            Type t = (Type)this.tables[3].elementAt(i);
            TypeLine typeLine = new TypeLine(this, t);
            this.ew.addLine(typeLine);
        }
    }

    private void fillConstants() {
        for (int i = 0; i < this.tables[5].size(); ++i) {
            Signal s = (Signal)this.tables[5].elementAt(i);
            SignalLine constantLine = new SignalLine(this, s, "constant");
            this.ew.addLine(constantLine);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Choose {
        GLOBALS_TYPES_SIGNALS,
        PORTS_GENERICS,
        ALL;

    }
}

