/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.applicationtier.core;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzer;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzerException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.LexicalSymbol;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.core.CodeBuilderException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.AnchoredName;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Port;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Rowable;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Table;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.TableRow;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Type;
import java.util.Vector;

public final class CodeBuilder {
    private static CodeBuilder codeBuilder;

    private CodeBuilder() {
    }

    public static CodeBuilder createCodeBuilder() {
        if (codeBuilder == null) {
            codeBuilder = new CodeBuilder();
        }
        return codeBuilder;
    }

    public StringBuffer removeHeader(StringBuffer code) {
        int i = -1;
        int n = -1;
        while ((i = code.indexOf("@")) != -1) {
            n = code.substring(0, i).lastIndexOf("\n");
            n = n == -1 ? 0 : ++n;
            code.delete(n, code.indexOf("\n", i) + 1);
        }
        return code;
    }

    public StringBuffer replaceEA(StringBuffer code, Table globals) throws CodeAnalyzerException {
        CodeAnalyzer ca = new CodeAnalyzer(code.toString());
        ca.skipBehind(LexicalSymbol.ENTITY);
        Rowable ent = (Rowable)globals.remove(0);
        boolean isGlobalDipendent = false;
        int index = ca.getOffset();
        if (!ent.getGlobalPart().equals("")) {
            isGlobalDipendent = true;
            LexicalSymbol ls = ca.nextLexicalSymbol();
            if (ls == LexicalSymbol.IDENT) {
                index = ca.getOffset();
            }
        }
        int indexFrom = !isGlobalDipendent ? index - ent.getAnchor().length() : index - ent.getAnchor().length() - 2;
        code.replace(indexFrom, index, ent.getName());
        if (!isGlobalDipendent) {
            ca.recalculateOffset(ent.getName().length() - ent.getAnchor().length());
        } else {
            ca.recalculateOffset(ent.getName().length() - ent.getAnchor().length() - 2);
        }
        ca.skipBehind(LexicalSymbol.ARCHITECTURE);
        Rowable arch = (Rowable)globals.remove(0);
        isGlobalDipendent = false;
        index = ca.getOffset();
        if (!arch.getGlobalPart().equals("")) {
            isGlobalDipendent = true;
            LexicalSymbol ls = ca.nextLexicalSymbol();
            if (ls == LexicalSymbol.IDENT) {
                index = ca.getOffset();
            }
        }
        indexFrom = !isGlobalDipendent ? index - arch.getAnchor().length() : index - arch.getAnchor().length() - 2;
        code.replace(indexFrom, index, arch.getName());
        if (!isGlobalDipendent) {
            ca.recalculateOffset(arch.getName().length() - arch.getAnchor().length());
        } else {
            ca.recalculateOffset(arch.getName().length() - arch.getAnchor().length() - 2);
        }
        ca.skipBehind(LexicalSymbol.OF);
        index = ca.getOffset();
        code.replace(index - ent.getAnchor().length(), index, ent.getName());
        ca.closeStream();
        return code;
    }

    public StringBuffer insertTables(StringBuffer code, Table[] tables) throws CodeAnalyzerException {
        CodeAnalyzer ca = new CodeAnalyzer(code.toString());
        ca.skipTo(LexicalSymbol.IS);
        int begin = ca.getOffset();
        ca.skipTo(LexicalSymbol.END);
        int end = ca.getOffset() - 3;
        int originalLength = code.substring(begin, end).length();
        String lines = "";
        if (!tables[1].isEmpty()) {
            lines = "\ngeneric\t(\n";
            lines = lines + tables[1].toString("\t\t");
            lines = this.removeLastSemicolon(lines);
            lines = lines + "\t\t);";
        }
        lines = lines + "\nport\t(\n";
        lines = lines + tables[2].toString("\t\t");
        lines = this.removeLastSemicolon(lines);
        lines = lines + "\t\t);\n";
        code.replace(begin, end, lines);
        ca.recalculateOffset(lines.length() - originalLength);
        ca.skipTo(LexicalSymbol.IS);
        begin = ca.getOffset();
        ca.skipTo(LexicalSymbol.BEGIN);
        end = ca.getOffset() - 5;
        lines = "\n";
        if (!tables[3].isEmpty()) {
            lines = lines + "\n" + tables[3].toString("");
        }
        if (!tables[4].isEmpty()) {
            lines = lines + "\n" + tables[4].toString("");
        }
        if (!tables[5].isEmpty()) {
            lines = lines + "\n" + tables[5].toString("");
        }
        lines = lines + "\n";
        code.replace(begin, end, lines);
        ca.closeStream();
        return code;
    }

    public StringBuffer replaceAnchor(StringBuffer code, String anchor, String newName) throws CodeAnalyzerException {
        CodeAnalyzer ca = new CodeAnalyzer(code.toString());
        int width = anchor.length();
        ca.skipBehind(LexicalSymbol.BEGIN);
        int i = ca.offsetOf(anchor);
        while (i != -1) {
            code.replace(i - width, i, newName);
            ca.recalculateOffset(newName.length() - anchor.length());
            i = ca.offsetOf(anchor);
        }
        ca.closeStream();
        return code;
    }

    public StringBuffer replaceDident(StringBuffer code, String anchor, String newName) {
        String mark = "$" + anchor + "$";
        int i = code.indexOf(mark);
        while (i != -1) {
            code.replace(i, i + mark.length(), newName);
            i = code.indexOf(mark);
        }
        return code;
    }

    public StringBuffer removeDollar(StringBuffer code) {
        String mark = "$";
        int i = code.indexOf(mark);
        while (i != -1) {
            code.deleteCharAt(i);
            i = code.indexOf(mark);
        }
        return code;
    }

    public StringBuffer unpackCase(StringBuffer code, Table typeTable, Table signalTable) throws CodeBuilderException, CodeAnalyzerException {
        int k;
        CodeAnalyzer ca;
        String[] data;
        int j;
        String mark = "#case#";
        String text = "";
        int i = -1;
        while (true) {
            text = "";
            i = code.indexOf(mark);
            if (i == -1) break;
            j = code.indexOf("#", i + 6);
            if (j == -1) {
                throw new CodeBuilderException("Found case without signal name");
            }
            data = this.gainData(code.substring(i + 6, j));
            ca = new CodeAnalyzer(data[0]);
            AnchoredName signalName = new AnchoredName(ca.buildName());
            k = signalTable.findAnchor(signalName.getAnchor());
            if (k == -1) {
                code.replace(i, j + 1, text);
                continue;
            }
            TableRow tr = (TableRow)signalTable.elementAt(k);
            if (!tr.getGlobalPart().equals(signalName.getGlobalPart()) || !tr.getAnchor().equals(signalName.getAnchor())) {
                code.replace(i, j + 1, text);
                continue;
            }
            String signalType = tr.getType();
            ca = new CodeAnalyzer(signalType);
            AnchoredName typeName = new AnchoredName(ca.buildName());
            k = typeTable.findAnchor(typeName.getAnchor());
            if (k == -1) {
                code.replace(i, j + 1, text);
                continue;
            }
            Type t = (Type)typeTable.elementAt(k);
            if (!t.getGlobalPart().equals(typeName.getGlobalPart()) || !t.getAnchor().equals(typeName.getAnchor())) {
                code.replace(i, j + 1, text);
                continue;
            }
            if (t.getValues() != null) {
                Vector<AnchoredName> tValues = t.getValues();
                int longest = 6;
                for (AnchoredName name : tValues) {
                    if (name.getName().length() <= longest) continue;
                    longest = name.getName().length();
                }
                String space = this.space(code.substring(0, i));
                text = "case " + data[0] + " is\n";
                for (int h = 0; h < tValues.size(); ++h) {
                    String tValue = tValues.elementAt(h).getName();
                    int distance = longest - tValue.length();
                    String space2 = "";
                    for (int l = 0; l < distance; ++l) {
                        space2 = space2 + " ";
                    }
                    text = text + space + "\t\twhen " + tValue + space2 + " => " + data[1] + "\n";
                }
                int distance = longest - 6;
                String space2 = "";
                for (int l = 0; l < distance; ++l) {
                    space2 = space2 + " ";
                }
                text = text + space + "\t\twhen others" + space2 + " => " + data[1] + "\n";
                text = text + space + "end case;";
            }
            code.replace(i, j + 1, text);
        }
        mark = "#case_body#";
        while (true) {
            text = "";
            i = code.indexOf(mark);
            if (i == -1) break;
            j = code.indexOf("#", i + 11);
            if (j == -1) {
                throw new CodeBuilderException("Found case_body without type name");
            }
            data = this.gainData(code.substring(i + 11, j));
            ca = new CodeAnalyzer(data[0]);
            AnchoredName typeName = new AnchoredName(ca.buildName());
            k = typeTable.findAnchor(typeName.getAnchor());
            if (k == -1) {
                code.replace(i, j + 1, text);
                continue;
            }
            Type t = (Type)typeTable.elementAt(k);
            if (!t.getGlobalPart().equals(typeName.getGlobalPart()) || !t.getAnchor().equals(typeName.getAnchor())) {
                code.replace(i, j + 1, text);
                continue;
            }
            if (t.getValues() != null) {
                Vector<AnchoredName> tValues = t.getValues();
                int longest = 6;
                for (AnchoredName name : tValues) {
                    if (name.getName().length() <= longest) continue;
                    longest = name.getName().length();
                }
                String space = this.space(code.substring(0, i));
                for (int h = 0; h < tValues.size(); ++h) {
                    String tValue = tValues.elementAt(h).getName();
                    int distance = longest - tValue.length();
                    String space2 = "";
                    for (int l = 0; l < distance; ++l) {
                        space2 = space2 + " ";
                    }
                    text = text + "when " + tValue + space2 + " => " + data[1] + "\n" + space;
                }
                int distance = longest - 6;
                String space2 = "";
                for (int l = 0; l < distance; ++l) {
                    space2 = space2 + " ";
                }
                text = text + "when others" + space2 + " => " + data[1];
            }
            code.replace(i, j + 1, text);
        }
        return code;
    }

    public StringBuffer createTestbench(StringBuffer testbench, String entityName, Table portTable, Table genericTable) {
        int j;
        String space2;
        String uut;
        String component;
        String space;
        int i = -1;
        String superseded = "$entity$";
        while ((i = testbench.indexOf(superseded)) != -1) {
            testbench.replace(i, i + superseded.length(), entityName);
        }
        superseded = "$component$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            component = "component " + entityName + "\n";
            if (!genericTable.isEmpty()) {
                component = component + space + "generic\t(\n";
                component = component + genericTable.toString(space + "\t\t");
                component = this.removeLastSemicolon(component);
                component = component + space + "\t\t);\n";
            }
            if (!portTable.isEmpty()) {
                component = component + space + "port\t(\n";
                component = component + portTable.toString(space + "\t\t");
                component = this.removeLastSemicolon(component);
                component = component + space + "\t\t);\n";
            }
            component = component + space + "end component;";
            testbench.replace(i, i + superseded.length(), component);
            i = testbench.indexOf(superseded);
        }
        superseded = "$component_generic$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            component = "";
            if (!genericTable.isEmpty()) {
                component = genericTable.toString(space);
                component = component.substring(space.length(), component.length() - 1);
                component = this.removeLastSemicolon(component);
            }
            testbench.replace(i, i + superseded.length(), component);
            i = testbench.indexOf(superseded);
        }
        superseded = "$component_port$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            component = "";
            if (!portTable.isEmpty()) {
                component = portTable.toString(space);
                component = component.substring(space.length(), component.length() - 1);
                component = this.removeLastSemicolon(component);
            }
            testbench.replace(i, i + superseded.length(), component);
            i = testbench.indexOf(superseded);
        }
        superseded = "$generic$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            component = "";
            if (!genericTable.isEmpty()) {
                component = component + "generic\t(\n";
                component = component + genericTable.toString(space + "\t\t");
                component = component.substring(0, component.length() - 1);
                component = this.removeLastSemicolon(component);
                component = component + "\n" + space + "\t\t);";
            }
            testbench.replace(i, i + superseded.length(), component);
            i = testbench.indexOf(superseded);
        }
        superseded = "$port$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            component = "";
            if (!portTable.isEmpty()) {
                component = component + "port\t(\n";
                component = component + portTable.toString(space + "\t\t");
                component = component.substring(0, component.length() - 1);
                component = this.removeLastSemicolon(component);
                component = component + "\n" + space + "\t\t);";
            }
            testbench.replace(i, i + superseded.length(), component);
            i = testbench.indexOf(superseded);
        }
        superseded = "$signals$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            String signals = "";
            if (!portTable.isEmpty()) {
                for (Rowable r : portTable) {
                    Port p = (Port)r;
                    signals = signals + "signal " + p.toSignalString(portTable.longestLength()) + "\n" + space;
                }
                signals = signals.substring(0, signals.length() - 1 - space.length());
            }
            testbench.replace(i, i + superseded.length(), signals);
            i = testbench.indexOf(superseded);
        }
        superseded = "$port_map$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            uut = "";
            if (!portTable.isEmpty()) {
                for (Rowable r : portTable) {
                    int distance = portTable.longestLength() - r.getName().length();
                    space2 = "";
                    for (j = 0; j < distance; ++j) {
                        space2 = space2 + " ";
                    }
                    uut = uut + space + r.getName() + space2 + " => " + r.getName() + ",\n";
                }
                uut = uut.substring(space.length(), uut.length() - 2);
            }
            testbench.replace(i, i + superseded.length(), uut);
            i = testbench.indexOf(superseded);
        }
        superseded = "$generic_map$";
        i = testbench.indexOf(superseded);
        while (i != -1) {
            space = this.space(testbench.substring(0, i));
            uut = "";
            if (!genericTable.isEmpty()) {
                for (Rowable r : genericTable) {
                    int distance = genericTable.longestLength() - r.getName().length();
                    space2 = "";
                    for (j = 0; j < distance; ++j) {
                        space2 = space2 + " ";
                    }
                    uut = uut + space + r.getName() + space2 + " => " + r.getName() + ",\n";
                }
                uut = uut.substring(space.length(), uut.length() - 2);
            }
            testbench.replace(i, i + superseded.length(), uut);
            i = testbench.indexOf(superseded);
        }
        return testbench;
    }

    private String removeLastSemicolon(String code) {
        int i = code.lastIndexOf(";");
        String end = "";
        if (i != code.length() - 1) {
            end = code.substring(i + 1, code.length());
        }
        if (i != -1) {
            code = code.substring(0, i) + end;
        }
        return code;
    }

    private String space(String code) {
        int i = code.lastIndexOf("\n");
        code = code.substring(i + 1, code.length());
        String space = "";
        for (int j = 0; j < code.length(); ++j) {
            space = code.charAt(j) == '\t' ? space + "\t" : space + " ";
        }
        return space;
    }

    private String[] gainData(String code) throws CodeBuilderException {
        String[] data = new String[2];
        data[1] = "";
        int i = code.indexOf("{");
        if (i == -1) {
            data[0] = code;
        } else {
            data[0] = code.substring(0, i);
            data[1] = code.substring(i + 1, code.length() - 1);
        }
        if (data[0].indexOf(" ") != -1) {
            throw new CodeBuilderException("Wrong case declaration found");
        }
        return data;
    }
}

