/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzerException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.LexicalAnalyzer;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.LexicalSymbol;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.AnchoredName;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Constant;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Generic;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Port;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Signal;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Table;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Type;
import java.io.File;
import java.util.Vector;

public class SyntaxAnalyzer {
    protected LexicalAnalyzer la;
    protected LexicalSymbol ls;
    String token;

    public SyntaxAnalyzer(String text) throws CodeAnalyzerException {
        this.la = new LexicalAnalyzer(text);
        this.ls = this.la.nextLexicalSymbol();
    }

    public SyntaxAnalyzer(File f) throws CodeAnalyzerException {
        this.la = new LexicalAnalyzer(f);
        this.ls = this.la.nextLexicalSymbol();
    }

    public void resetStream() throws CodeAnalyzerException {
        this.la.resetStream();
        this.ls = this.la.nextLexicalSymbol();
    }

    public void closeStream() {
        this.la.closeLAStream();
    }

    public Table fillGlobals(boolean ea) throws CodeAnalyzerException {
        Table globals = new Table();
        String[] ga = new String[]{"", "", ""};
        while (!this.accept(LexicalSymbol.ENTITY)) {
            if (this.ls == LexicalSymbol.GLOBAL) {
                ga[0] = this.la.getString();
                globals.add(new AnchoredName(ga));
            }
            if (this.ls == LexicalSymbol.EOF) {
                return globals;
            }
            this.ls = this.la.nextLexicalSymbol();
        }
        if (ea) {
            ga = this.buildName();
            globals.add(0, new AnchoredName(ga));
            if (!this.accept(LexicalSymbol.IS)) {
                throw new CodeAnalyzerException("Syntax error");
            }
            while (!this.accept(LexicalSymbol.ARCHITECTURE)) {
                this.ls = this.la.nextLexicalSymbol();
                if (this.ls != LexicalSymbol.EOF) continue;
                throw new CodeAnalyzerException("ARCHITECTURE not found");
            }
            ga = this.buildName();
            globals.add(1, new AnchoredName(ga));
            if (!this.accept(LexicalSymbol.OF)) {
                throw new CodeAnalyzerException("Syntax error");
            }
        }
        return globals;
    }

    public Table fillGenericTable() throws CodeAnalyzerException {
        Table genericTable = new Table();
        while (this.ls != LexicalSymbol.END && this.ls != LexicalSymbol.EOF) {
            if (this.ls == LexicalSymbol.IDENT || this.ls == LexicalSymbol.DIDENT) {
                this.trySignal(genericTable, (byte)1);
                continue;
            }
            this.ls = this.la.nextLexicalSymbol();
        }
        return genericTable;
    }

    public Table fillPortTable() throws CodeAnalyzerException {
        Table portTable = new Table();
        while (this.ls != LexicalSymbol.END && this.ls != LexicalSymbol.EOF) {
            if (this.ls == LexicalSymbol.IDENT || this.ls == LexicalSymbol.DIDENT) {
                this.tryPort(portTable);
                continue;
            }
            this.ls = this.la.nextLexicalSymbol();
        }
        return portTable;
    }

    public Table[] fillTSCTable() throws CodeAnalyzerException {
        Table[] tables = new Table[]{new Table(), new Table(), new Table()};
        block5: while (this.ls != LexicalSymbol.BEGIN && this.ls != LexicalSymbol.EOF) {
            switch (this.ls) {
                case TYPE: {
                    this.ls = this.la.nextLexicalSymbol();
                    if (this.ls != LexicalSymbol.IDENT && this.ls != LexicalSymbol.DIDENT) continue block5;
                    this.tryType(tables[0]);
                    continue block5;
                }
                case SIGNAL: {
                    this.ls = this.la.nextLexicalSymbol();
                    if (this.ls != LexicalSymbol.IDENT && this.ls != LexicalSymbol.DIDENT) continue block5;
                    this.trySignal(tables[1], (byte)4);
                    continue block5;
                }
                case CONSTANT: {
                    this.ls = this.la.nextLexicalSymbol();
                    if (this.ls != LexicalSymbol.IDENT && this.ls != LexicalSymbol.DIDENT) continue block5;
                    this.trySignal(tables[2], (byte)5);
                    continue block5;
                }
            }
            this.ls = this.la.nextLexicalSymbol();
        }
        return tables;
    }

    public void skipBehind(LexicalSymbol l) throws CodeAnalyzerException {
        while (!this.accept(l)) {
            this.ls = this.la.nextLexicalSymbol();
            if (this.ls != LexicalSymbol.EOF) continue;
            throw new CodeAnalyzerException((Object)((Object)l) + " not found");
        }
    }

    public void skipTo(LexicalSymbol l) throws CodeAnalyzerException {
        while (this.ls != l) {
            this.ls = this.la.nextLexicalSymbol();
            if (this.ls != LexicalSymbol.EOF) continue;
            throw new CodeAnalyzerException((Object)((Object)l) + " not found");
        }
    }

    public String getNextIdent() throws CodeAnalyzerException {
        while (this.ls != LexicalSymbol.IDENT) {
            this.ls = this.la.nextLexicalSymbol();
            if (this.ls != LexicalSymbol.EOF) continue;
            return null;
        }
        return this.la.getString();
    }

    public LexicalSymbol nextLexicalSymbol() throws CodeAnalyzerException {
        this.ls = this.la.nextLexicalSymbol();
        return this.ls;
    }

    private boolean accept(LexicalSymbol expected) throws CodeAnalyzerException {
        if (this.ls == expected) {
            this.ls = this.la.nextLexicalSymbol();
            return true;
        }
        return false;
    }

    private boolean accept(LexicalSymbol expected1, LexicalSymbol expected2, LexicalSymbol expected3, LexicalSymbol expected4) throws CodeAnalyzerException {
        if (this.ls == expected1 || this.ls == expected2 || this.ls == expected3 || this.ls == expected4) {
            this.ls = this.la.nextLexicalSymbol();
            return true;
        }
        return false;
    }

    private void tryPort(Table portTable) throws CodeAnalyzerException {
        Vector<String[]> anchors = new Vector<String[]>();
        do {
            String[] ga = this.buildName();
            anchors.add(ga);
        } while (this.accept(LexicalSymbol.COMMA));
        if (this.accept(LexicalSymbol.COLON)) {
            LexicalSymbol l = this.ls;
            if (this.accept(LexicalSymbol.IN, LexicalSymbol.OUT, LexicalSymbol.INOUT, LexicalSymbol.BUFFER) || this.accept(LexicalSymbol.LINKAGE)) {
                String[] values = this.tryValues();
                String direction = this.directionToString(l);
                while (!anchors.isEmpty()) {
                    portTable.add(new Port((String[])anchors.remove(0), direction, values[0], values[2]));
                }
            }
        }
    }

    private void trySignal(Table signalTable, byte choose) throws CodeAnalyzerException {
        Vector<String[]> anchors = new Vector<String[]>();
        do {
            String[] ga = this.buildName();
            anchors.add(ga);
        } while (this.accept(LexicalSymbol.COMMA));
        if (this.accept(LexicalSymbol.COLON) && this.ls != LexicalSymbol.IN && this.ls != LexicalSymbol.OUT && this.ls != LexicalSymbol.INOUT && this.ls != LexicalSymbol.BUFFER && this.ls != LexicalSymbol.LINKAGE) {
            String[] values = this.tryValues();
            while (!anchors.isEmpty()) {
                if (choose == 1) {
                    signalTable.add(new Generic((String[])anchors.remove(0), values[0], values[1], values[2]));
                    continue;
                }
                if (choose == 4) {
                    signalTable.add(new Signal((String[])anchors.remove(0), values[0], values[1], values[2]));
                    continue;
                }
                if (choose != 5) continue;
                signalTable.add(new Constant((String[])anchors.remove(0), values[0], values[1], values[2]));
            }
        }
    }

    private void tryType(Table typeTable) throws CodeAnalyzerException {
        Vector<AnchoredName> types = new Vector<AnchoredName>();
        String[] ga = this.buildName();
        if (this.accept(LexicalSymbol.IS)) {
            if (this.accept(LexicalSymbol.LPAR)) {
                do {
                    types.add(new AnchoredName(this.buildName()));
                } while (this.accept(LexicalSymbol.COMMA));
                if (this.accept(LexicalSymbol.RPAR) && this.accept(LexicalSymbol.SEMICOLON)) {
                    String comm = "";
                    if (this.ls == LexicalSymbol.COMMENT) {
                        comm = this.la.getString();
                        this.ls = this.la.nextLexicalSymbol();
                    }
                    typeTable.add(new Type(ga, types, comm));
                }
            } else {
                String[] values = this.tryValues();
                String[] type = new String[]{"", "", ""};
                type[0] = values[0];
                types.add(new AnchoredName(type));
                typeTable.add(new Type(ga, types, values[2]));
            }
        }
    }

    private String[] tryValues() throws CodeAnalyzerException {
        String[] separ;
        String all = "";
        String line = this.ls == LexicalSymbol.DIDENT ? "$" + this.la.getString() + "$" : this.la.getString();
        String[] values = new String[]{"", "", ""};
        String end = "";
        if (this.accept(LexicalSymbol.SEMICOLON)) {
            values[0] = null;
        } else {
            int n;
            while (true) {
                this.la.readRestOfLine();
                line = line + this.la.getString();
                separ = this.splitBy(line, "--");
                n = separ[0].indexOf(";");
                if (n != -1) break;
                all = all + line + "\n";
                line = "";
            }
            end = separ[0].substring(n);
            separ[0] = separ[0].substring(0, n);
            all = all + separ[0];
            values[2] = separ[1].trim();
            String[] rest = this.splitBy(all, ":=");
            values[0] = rest[0].trim();
            values[1] = rest[1].trim();
        }
        this.ls = end.indexOf("end") != -1 ? LexicalSymbol.END : this.la.nextLexicalSymbol();
        if (this.ls == LexicalSymbol.END || this.ls == LexicalSymbol.PORT) {
            all = all.trim();
            all = all.substring(0, all.length() - 1);
            separ = this.splitBy(all = all.trim(), "--");
            if (!separ[1].equals("")) {
                values[2] = separ[1].trim();
            }
            String[] rest = this.splitBy(separ[0], ":=");
            values[0] = rest[0].trim();
            values[1] = rest[1].trim();
        }
        return values;
    }

    public String[] buildName() throws CodeAnalyzerException {
        String[] ga = new String[3];
        String pref = "";
        String suf = "";
        if (this.ls == LexicalSymbol.U || this.ls == LexicalSymbol.UV) {
            if (this.ls == LexicalSymbol.U) {
                suf = "'";
                pref = "'";
            } else {
                suf = "\"";
                pref = "\"";
            }
            this.ls = this.la.nextLexicalSymbol();
        }
        if (this.ls == LexicalSymbol.DIDENT) {
            ga[0] = "";
            ga[1] = this.la.getString();
            this.ls = this.la.nextLexicalSymbol();
            if (this.ls == LexicalSymbol.IDENT) {
                ga[2] = this.la.getString();
                this.ls = this.la.nextLexicalSymbol();
            } else {
                ga[2] = "";
            }
        } else if (this.ls == LexicalSymbol.IDENT) {
            ga[0] = pref + this.la.getString() + suf;
            this.ls = this.la.nextLexicalSymbol();
            if (this.ls == LexicalSymbol.DIDENT) {
                ga[1] = this.la.getString();
                this.ls = this.la.nextLexicalSymbol();
                if (this.ls == LexicalSymbol.IDENT) {
                    ga[2] = this.la.getString();
                    this.ls = this.la.nextLexicalSymbol();
                } else {
                    ga[2] = "";
                }
            } else {
                ga[1] = "";
                ga[2] = "";
            }
        } else if (this.ls == LexicalSymbol.CONST) {
            ga[0] = pref + this.la.getConst() + suf;
            this.ls = this.la.nextLexicalSymbol();
            ga[2] = "";
            ga[1] = "";
        }
        if (this.ls == LexicalSymbol.U || this.ls == LexicalSymbol.UV) {
            this.ls = this.la.nextLexicalSymbol();
        }
        return ga;
    }

    private String directionToString(LexicalSymbol direction) {
        if (direction == LexicalSymbol.IN) {
            return "in";
        }
        if (direction == LexicalSymbol.OUT) {
            return "out";
        }
        if (direction == LexicalSymbol.INOUT) {
            return "inout";
        }
        if (direction == LexicalSymbol.BUFFER) {
            return "buffer";
        }
        return "linkage";
    }

    private String[] splitBy(String line, String token) {
        String[] values = new String[]{"", ""};
        values[0] = line;
        int i = line.indexOf(token);
        if (i != -1) {
            values[1] = line.substring(i + token.length(), line.length());
            values[0] = line.substring(0, i);
        }
        return values;
    }
}

