/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzerException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.LexicalSymbol;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Scanner;

public class LexicalAnalyzer {
    private String s;
    private File f;
    private Scanner sc;
    private String line;
    private int character;
    private int index;
    private int lineNumber;
    private int offset;
    private String word = "";
    private int value;
    private String whiteSpace = "";

    public LexicalAnalyzer(String s) {
        this.s = s;
        this.f = null;
        this.index = 0;
        this.lineNumber = 0;
        this.offset = -1;
        this.sc = new Scanner(s);
        this.character = this.readNext();
    }

    public LexicalAnalyzer(File f) throws CodeAnalyzerException {
        this.f = f;
        this.s = null;
        this.index = 0;
        this.lineNumber = 0;
        this.offset = -1;
        try {
            this.sc = new Scanner(new BufferedReader(new FileReader(f)));
            this.character = this.readNext();
        }
        catch (IOException e) {
            throw new CodeAnalyzerException("InputStream could not be opened");
        }
    }

    public void closeLAStream() {
        this.sc.close();
    }

    public void resetStream() throws CodeAnalyzerException {
        this.line = null;
        this.index = 0;
        this.lineNumber = 0;
        this.offset = -1;
        this.word = "";
        this.whiteSpace = "";
        if (this.s != null) {
            this.sc.close();
            this.sc = new Scanner(this.s);
            this.character = this.readNext();
        } else if (this.f != null) {
            try {
                this.sc.close();
                this.sc = new Scanner(new BufferedReader(new FileReader(this.f)));
                this.character = this.readNext();
            }
            catch (IOException e) {
                throw new CodeAnalyzerException("InputStream could not be opened");
            }
        } else {
            throw new CodeAnalyzerException("No InputStream initialized");
        }
    }

    public String getString() {
        return this.word;
    }

    public String getWhiteSpace() {
        return this.whiteSpace;
    }

    public int getConst() {
        return this.value;
    }

    public void readRestOfLine() {
        this.word = "";
        while (this.character != 10) {
            this.word = this.word + (char)this.character;
            this.character = this.readNext();
        }
        this.character = this.readNext();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getIndex() {
        return this.index - 1;
    }

    public void recalculateOffset(int difference) {
        this.offset += difference;
    }

    public LexicalSymbol nextLexicalSymbol() throws CodeAnalyzerException {
        this.whiteSpace = "";
        while (Character.isWhitespace(this.character)) {
            this.whiteSpace = this.whiteSpace + this.character;
            this.character = this.readNext();
        }
        if (this.character == 45) {
            this.character = this.readNext();
            if (this.character == 45) {
                this.word = "";
                this.character = this.readNext();
                while (this.character != 10) {
                    this.word = this.word + (char)this.character;
                    this.character = this.readNext();
                }
                return LexicalSymbol.COMMENT;
            }
            return LexicalSymbol.MINUS;
        }
        if (this.character == -1) {
            return LexicalSymbol.EOF;
        }
        this.word = "";
        if (Character.isLetter(this.character) || this.character == 95) {
            this.word = this.word + (char)this.character;
            this.character = this.readNext();
            while (Character.isDigit(this.character) || Character.isLetter(this.character) || this.character == 95) {
                this.word = this.word + (char)this.character;
                this.character = this.readNext();
            }
            LexicalSymbol ls = LexicalSymbol.evaluateLexicalSymbol(this.word);
            if (ls == LexicalSymbol.LIBRARY || ls == LexicalSymbol.USE) {
                this.skipImport();
            }
            return ls;
        }
        if (this.character == 64) {
            this.character = this.readNext();
            if (Character.isDigit(this.character) || Character.isLetter(this.character) || this.character == 95) {
                while (Character.isDigit(this.character) || Character.isLetter(this.character) || this.character == 95) {
                    this.word = this.word + (char)this.character;
                    this.character = this.readNext();
                }
                return LexicalSymbol.GLOBAL;
            }
            return LexicalSymbol.UNKNOWN;
        }
        if (this.character == 36) {
            this.character = this.readNext();
            while (this.character != 36) {
                if (!Character.isLetter(this.character) && !Character.isDigit(this.character) && this.character != 95) {
                    return LexicalSymbol.UNKNOWN;
                }
                this.word = this.word + (char)this.character;
                this.character = this.readNext();
            }
            this.character = this.readNext();
            return LexicalSymbol.DIDENT;
        }
        if (Character.isDigit(this.character)) {
            do {
                this.word = this.word + (char)this.character;
                this.character = this.readNext();
            } while (Character.isDigit(this.character));
            this.value = Integer.valueOf(this.word);
            return LexicalSymbol.CONST;
        }
        if (this.character == 39) {
            this.character = this.readNext();
            return LexicalSymbol.U;
        }
        if (this.character == 34) {
            this.character = this.readNext();
            return LexicalSymbol.UV;
        }
        if (this.isSpecial(this.character)) {
            LexicalSymbol ls;
            this.word = this.word + (char)this.character;
            this.character = this.readNext();
            if ((this.character == 61 || this.character == 62) && (ls = LexicalSymbol.evaluateLexicalSymbol(this.word + this.character)) != LexicalSymbol.IDENT) {
                this.word = this.word + this.character;
                this.character = this.readNext();
                return ls;
            }
            ls = LexicalSymbol.evaluateLexicalSymbol(this.word);
            if (ls != LexicalSymbol.IDENT) {
                return ls;
            }
        }
        this.character = this.readNext();
        return LexicalSymbol.UNKNOWN;
    }

    private int readNext() {
        int x = -1;
        if (this.line != null && this.index < this.line.length() - 1) {
            ++this.index;
            x = this.line.charAt(this.index);
            ++this.offset;
        } else if (this.sc.hasNext()) {
            this.index = 0;
            this.line = this.sc.nextLine() + '\n';
            x = this.line.charAt(this.index);
            ++this.lineNumber;
            ++this.offset;
        }
        return x;
    }

    private void skipImport() {
        this.character = this.readNext();
        while (this.character != 59) {
            this.word = this.word + (char)this.character;
            this.character = this.readNext();
        }
        this.character = this.readNext();
    }

    private boolean isSpecial(int x) {
        return x == 60 || x == 62 || x == 61 || x == 43 || x == 45 || x == 42 || x == 46 || x == 40 || x == 41 || x == 59 || x == 44 || x == 58 || x == 38;
    }
}

