/*
 * Decompiled with CFR 0.152.
 */
package cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer;

import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.CodeAnalyzerException;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.codeanalyzer.SyntaxAnalyzer;
import cz.cvut.fel.mateju.vhdlsgen.applicationtier.tables.Table;
import java.io.File;

public class CodeAnalyzer
extends SyntaxAnalyzer {
    public static final byte GLOBALS = 0;
    public static final byte GENERICS = 1;
    public static final byte PORTS = 2;
    public static final byte TYPES = 3;
    public static final byte SIGNALS = 4;
    public static final byte CONSTANTS = 5;

    public CodeAnalyzer(String text) throws CodeAnalyzerException {
        super(text);
    }

    public CodeAnalyzer(File f) throws CodeAnalyzerException {
        super(f);
    }

    public Table[] fillTables() throws CodeAnalyzerException {
        Table[] tables = new Table[6];
        Table[] tsc = new Table[3];
        tables[0] = this.fillGlobals(true);
        this.resetStream();
        tables[1] = this.fillGenericTable();
        this.resetStream();
        tables[2] = this.fillPortTable();
        tsc = this.fillTSCTable();
        tables[3] = tsc[0];
        tables[4] = tsc[1];
        tables[5] = tsc[2];
        this.resetStream();
        return tables;
    }

    public int offsetOf(String anchor) throws CodeAnalyzerException {
        int offset;
        String ident;
        do {
            if ((ident = this.getNextIdent()) == null) {
                return -1;
            }
            offset = this.la.getOffset();
            this.ls = this.la.nextLexicalSymbol();
        } while (!ident.equalsIgnoreCase(anchor));
        return offset;
    }

    public void recalculateOffset(int difference) {
        this.la.recalculateOffset(difference);
    }

    public int getOffset() {
        return this.la.getOffset();
    }

    public int getLineOffset() {
        return this.la.getIndex();
    }
}

